/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.multicharbrowser;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import info.textgrid.lab.xmleditor.multicharbrowser.IModelViewer;
import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class UnicodeModel {
    private static int columns = 8;
    private static Vector<String[]> chars = new Vector(2);
    private static String lastQueryBlock = "";
    private static int lastQueryStart = 0;
    private static int lastQueryEnd = 0;
    private Set<IModelViewer> changeListeners = new HashSet<IModelViewer>();
    private String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

    public UnicodeModel(int start, int end) {
        UnicodeModel.initVector(start, end);
    }

    public UnicodeModel(String name, boolean isBlock, int numberOfColumns) {
        this.resizeColumns(numberOfColumns);
        if (isBlock) {
            this.initBlockVector(name);
        } else {
            this.initScriptVector(name);
        }
    }

    public UnicodeModel(int numberOfColumns, String[] customChars) {
        this.resizeColumns(numberOfColumns);
        this.initCustomBlockset(customChars);
    }

    public void initCustomBlockset(String[] customChars) {
        chars.clear();
        Vector<String> vector = new Vector<String>();
        int iterator = 0;
        while (iterator < customChars.length) {
            int codePoint = customChars[iterator].codePointAt(0);
            while (Character.isWhitespace(codePoint) || !Character.isDefined(codePoint) || Character.isIdentifierIgnorable(codePoint) || Character.isSpaceChar(codePoint)) {
                ++codePoint;
            }
            vector.add(customChars[iterator]);
            ++iterator;
        }
        String[] temp = new String[columns];
        int index = 0;
        int iter = 0;
        while (iter < vector.size()) {
            if (index < columns) {
                temp[index] = (String)vector.get(iter);
                ++index;
            } else {
                chars.add(temp);
                temp = new String[columns];
                temp[0] = (String)vector.get(iter);
                index = 1;
            }
            ++iter;
        }
        chars.add(temp);
    }

    public void initBlockVector(String block) {
        if (block.equals(lastQueryBlock)) {
            chars.clear();
            UnicodeModel.initVector(lastQueryStart, lastQueryEnd);
        } else {
            chars.clear();
            int index = 0;
            int start = 0;
            int end = 65535;
            while (!UCharacter.UnicodeBlock.of((int)index).toString().equalsIgnoreCase(block)) {
                ++index;
            }
            start = index;
            while (UCharacter.UnicodeBlock.of((int)index).toString().equalsIgnoreCase(block)) {
                ++index;
            }
            end = index;
            lastQueryBlock = block;
            lastQueryStart = start;
            lastQueryEnd = end;
            UnicodeModel.initVector(start, end);
        }
    }

    public void initScriptVector(String script) {
        chars.clear();
        String[] temp = new String[columns];
        int index = 0;
        int i = 0;
        while (i < 0x10FFFF) {
            if (UScript.getName((int)UScript.getScript((int)i)).equalsIgnoreCase(script)) {
                if (index < columns) {
                    temp[index] = UnicodeModel.newString(i);
                    ++index;
                } else {
                    chars.add(temp);
                    temp = new String[columns];
                    temp[0] = UnicodeModel.newString(i);
                    index = 1;
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void initVector(int start, int end) {
        codePoint = start;
        j = 0;
        while (j < end / UnicodeModel.columns) {
            s = new String[UnicodeModel.columns];
            if (codePoint > end) break;
            i = 0;
            ** GOTO lbl14
            {
                ++codePoint;
                do {
                    if (Character.isWhitespace(codePoint) || !Character.isDefined(codePoint) || Character.isIdentifierIgnorable(codePoint) || Character.isSpaceChar(codePoint)) continue block1;
                    s[i] = UnicodeModel.newString(codePoint);
                    ++codePoint;
                    ++i;
lbl14:
                    // 2 sources

                } while (i < UnicodeModel.columns && codePoint <= end);
            }
            UnicodeModel.chars.add(s);
            ++j;
        }
    }

    public void resizeColumns(int newColumns) {
        columns = newColumns;
    }

    public void updateModel(int start, int end) {
        Iterator<IModelViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().updateModel(start, end);
        }
    }

    public void updateModel(String name) {
        Iterator<IModelViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().updateScript(name);
        }
    }

    public void updateFont(String fontName) {
        Iterator<IModelViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().updateFont(fontName);
        }
    }

    public int getColumns() {
        return columns;
    }

    public Vector<String[]> getChars() {
        return chars;
    }

    public String[] getFonts() {
        return this.fonts;
    }

    public void addChangeListener(IModelViewer viewer) {
        this.changeListeners.add(viewer);
    }

    public void removeChangeListener(IModelViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public static String newString(int codePoint) {
        if (Character.charCount(codePoint) == 1) {
            return String.valueOf((char)codePoint);
        }
        return new String(Character.toChars(codePoint));
    }

    public static void main(String[] args) {
    }
}

