/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui;

import info.textgrid.lab.search.ui.Activator;
import info.textgrid.lab.search.ui.Messages;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SearchUICalendar {
    Shell dialog = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 2144);
    DateTime calendar;
    Button ok;

    public SearchUICalendar(final Text textDate) {
        this.dialog.setLayout((Layout)new GridLayout(1, false));
        this.calendar = new DateTime((Composite)this.dialog, 3072);
        this.initCalendar(textDate.getText());
        this.ok = new Button((Composite)this.dialog, 8);
        this.ok.setText("OK");
        this.ok.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int iMonth = SearchUICalendar.this.calendar.getMonth() + 1;
                String sMonth = iMonth < 10 ? "0" + String.valueOf(iMonth) : String.valueOf(iMonth);
                String sDay = SearchUICalendar.this.calendar.getDay() < 10 ? "0" + SearchUICalendar.this.calendar.getDay() : String.valueOf(SearchUICalendar.this.calendar.getDay());
                textDate.setText(String.valueOf(SearchUICalendar.this.calendar.getYear()) + "-" + sMonth + "-" + sDay);
                SearchUICalendar.this.dialog.close();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        Point point = PlatformUI.getWorkbench().getDisplay().getCursorLocation();
        this.dialog.setLocation(point.x, point.y + 10);
        this.dialog.pack();
        this.dialog.open();
    }

    private void initCalendar(String str_date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date date = formatter.parse(str_date);
            GregorianCalendar gCalendar = new GregorianCalendar();
            gCalendar.setTime(date);
            this.calendar.setDate(gCalendar.get(1), gCalendar.get(2), gCalendar.get(5));
        }
        catch (ParseException e) {
            Status status = new Status(2, "info.textgrid.lab.search.ui", Messages.SearchUICalendar_ErrorMessage1, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }
}

