/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.utils;

import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.utils.Messages;
import info.textgrid.lab.core.metadataeditor.utils.OMItem;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.jaxen.JaxenException;
import org.osgi.framework.Bundle;

public class OMUtil {
    protected List<OMItem> items = new ArrayList<OMItem>();
    private static final String ORDER_CONFIG_FILE = "-order.conf";

    public static OMElement getElementWithName(String elementName, OMElement root, String namespace, String prefix) throws JaxenException {
        AXIOMXPath xpath = new AXIOMXPath("child::" + prefix + ":" + elementName + " | self::" + prefix + ":" + elementName);
        xpath.addNamespace(prefix, namespace);
        OMElement elem = (OMElement)xpath.selectSingleNode((Object)root);
        return elem;
    }

    public static List getElementListWithName(String elementName, OMElement root, String namespace, String prefix) throws JaxenException {
        AXIOMXPath xpath = new AXIOMXPath("child::" + prefix + ":" + elementName + " | self::" + prefix + ":" + elementName);
        xpath.addNamespace(prefix, namespace);
        List elems = xpath.selectNodes((Object)root);
        return elems;
    }

    public static List getElementListWithName_Deep(String elementName, OMElement root, String namespace, String prefix) throws JaxenException {
        AXIOMXPath xpath = new AXIOMXPath("//" + prefix + ":" + elementName);
        xpath.addNamespace(prefix, namespace);
        List elems = xpath.selectNodes((Object)root);
        return elems;
    }

    public void add(List<OMItem> items) {
        if (this.items.isEmpty()) {
            this.items = items;
        }
    }

    protected OMItem getOMItemById(String id) {
        for (OMItem item : this.items) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    @Deprecated
    protected List<OMItem> getOrderedItems(String elemName) {
        ArrayList<OMItem> l = new ArrayList<OMItem>();
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(String.valueOf(elemName) + ORDER_CONFIG_FILE), null);
        InputStream in = null;
        try {
            url = FileLocator.resolve((URL)url);
            in = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String s = null;
            while ((s = reader.readLine()) != null) {
                OMItem item = this.getOMItemById(s.trim());
                if (item == null) continue;
                l.add(item);
            }
        }
        catch (Exception e) {
            Activator.handleError(e, NLS.bind((String)Messages.OMUtil_itemNotFound, (Object)ORDER_CONFIG_FILE), new Object[0]);
            return this.items;
        }
        if (l.size() < this.items.size()) {
            for (OMItem i : this.items) {
                if (!l.contains(i)) {
                    l.add(i);
                }
                if (l.size() == this.items.size()) break;
            }
        }
        return l;
    }
}

