/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PositionVariable;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.ExpressionProcessor;
import net.sf.saxon.expr.flwor.ForClause;
import net.sf.saxon.expr.flwor.LetClause;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.ReturnClauseIterator;
import net.sf.saxon.expr.flwor.ReturnClausePush;
import net.sf.saxon.expr.flwor.SingularityPull;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.flwor.WhereClause;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FLWORExpression
extends Expression {
    public List<Clause> clauses;
    public Expression returnClause;

    public FLWORExpression(List<Clause> clauses, Expression returnClause) {
        this.clauses = clauses;
        this.returnClause = returnClause;
    }

    public List<Clause> getClauseList() {
        return this.clauses;
    }

    @Override
    public boolean hasLoopingSubexpression(final Expression child) {
        boolean foundLoopClause = false;
        final ArrayList bList = new ArrayList(5);
        ExpressionProcessor simplifier = new ExpressionProcessor(){

            public Expression processExpression(Expression expr) throws XPathException {
                if (expr == child) {
                    bList.add(true);
                }
                return expr;
            }
        };
        for (Clause c : this.clauses) {
            try {
                c.processSubExpressions(simplifier);
            }
            catch (XPathException e) {
                return true;
            }
            if (!bList.isEmpty()) {
                return foundLoopClause;
            }
            if (!FLWORExpression.isLoopingClause(c)) continue;
            foundLoopClause = true;
        }
        return foundLoopClause && this.returnClause == child;
    }

    private static boolean isLoopingClause(Clause c) {
        return c.getClauseKey() == 0 || c.getClauseKey() == 3 || c.getClauseKey() == 2;
    }

    public Expression getReturnClause() {
        return this.returnClause;
    }

    @Override
    public boolean hasVariableBinding(Binding binding) {
        for (Clause c : this.clauses) {
            if (!this.clauseHasBinding(c, binding)) continue;
            return true;
        }
        return false;
    }

    private boolean clauseHasBinding(Clause c, Binding binding) {
        for (LocalVariableBinding b : c.getRangeVariables()) {
            if (b != binding) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression simplify(final ExpressionVisitor visitor) throws XPathException {
        ExpressionProcessor simplifier = new ExpressionProcessor(){

            public Expression processExpression(Expression expr) throws XPathException {
                return visitor.simplify(expr);
            }
        };
        for (Clause c : this.clauses) {
            c.processSubExpressions(simplifier);
        }
        this.returnClause = visitor.simplify(this.returnClause);
        return this;
    }

    @Override
    public Expression typeCheck(final ExpressionVisitor visitor, final ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        ExpressionProcessor typeChecker = new ExpressionProcessor(){

            public Expression processExpression(Expression expr) throws XPathException {
                return visitor.typeCheck(expr, contextItemType);
            }
        };
        for (int i = 0; i < this.clauses.size(); ++i) {
            LocalVariableBinding[] bindings;
            this.clauses.get(i).processSubExpressions(typeChecker);
            this.clauses.get(i).typeCheck(visitor);
            for (LocalVariableBinding b : bindings = this.clauses.get(i).getRangeVariables()) {
                ArrayList<VariableReference> references = new ArrayList<VariableReference>();
                for (int j = i; j < this.clauses.size(); ++j) {
                    this.clauses.get(j).gatherVariableReferences(visitor, b, references);
                }
                ExpressionTool.gatherVariableReferences(this.returnClause, b, references);
                this.clauses.get(i).refineVariableType(visitor, references, this.returnClause);
            }
        }
        this.returnClause = visitor.typeCheck(this.returnClause, contextItemType);
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.returnClause.getItemType(th);
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        final ArrayList<Expression> list = new ArrayList<Expression>(5);
        ExpressionProcessor processor = new ExpressionProcessor(){

            public Expression processExpression(Expression expr) {
                list.add(expr);
                return expr;
            }
        };
        try {
            for (Clause c : this.clauses) {
                c.processSubExpressions(processor);
            }
        }
        catch (XPathException e) {
            throw new IllegalStateException(e);
        }
        list.add(this.returnClause);
        return list.iterator();
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        ExpressionProcessor processor = new ExpressionProcessor(){

            public Expression processExpression(Expression expr) throws XPathException {
                expr.checkForUpdatingSubexpressions();
                if (expr.isUpdatingExpression()) {
                    throw new XPathException("An updating expression cannot be used in a clause of a FLWOR expression", "XUST0001");
                }
                return expr;
            }
        };
        for (Clause c : this.clauses) {
            c.processSubExpressions(processor);
        }
        this.returnClause.checkForUpdatingSubexpressions();
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.returnClause.isUpdatingExpression();
    }

    @Override
    public boolean replaceSubExpression(final Expression original, final Expression replacement) {
        final ArrayList changed = new ArrayList();
        ExpressionProcessor processor = new ExpressionProcessor(){

            public Expression processExpression(Expression expr) {
                if (expr == original) {
                    changed.add(Boolean.TRUE);
                    return replacement;
                }
                return expr;
            }
        };
        try {
            for (Clause c : this.clauses) {
                c.processSubExpressions(processor);
            }
        }
        catch (XPathException e) {
            throw new IllegalStateException(e);
        }
        return !changed.isEmpty();
    }

    public void replaceVariable(Optimizer opt, Expression seq) throws XPathException {
        PromotionOffer offer2 = new PromotionOffer(opt);
        offer2.action = 12;
        offer2.containingExpression = seq;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("FLWOR");
        for (Clause c : this.clauses) {
            c.explain(out);
        }
        out.startSubsidiaryElement("return");
        this.returnClause.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }

    @Override
    public Expression copy() {
        ArrayList<Clause> newClauses = new ArrayList<Clause>();
        ArrayList<LocalVariableBinding> oldBindings = new ArrayList<LocalVariableBinding>();
        ArrayList<LocalVariableBinding> newBindings = new ArrayList<LocalVariableBinding>();
        for (Clause c : this.clauses) {
            Clause c2 = c.copy();
            oldBindings.addAll(Arrays.asList(c.getRangeVariables()));
            newBindings.addAll(Arrays.asList(c2.getRangeVariables()));
            newClauses.add(c2);
        }
        FLWORExpression f2 = new FLWORExpression(newClauses, this.returnClause.copy());
        for (int i = 0; i < oldBindings.size(); ++i) {
            ExpressionTool.rebindVariableReferences(f2, (Binding)oldBindings.get(i), (Binding)newBindings.get(i));
        }
        return f2;
    }

    @Override
    public Expression promote(final PromotionOffer offer, Expression parent) throws XPathException {
        ExpressionProcessor processor = new ExpressionProcessor(){

            public Expression processExpression(Expression expr) throws XPathException {
                return FLWORExpression.this.doPromotion(expr, offer);
            }
        };
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (offer.action == 11 || offer.action == 10) {
            Binding[] savedBindingList = offer.bindingList;
            for (Clause c : this.clauses) {
                offer.bindingList = this.extendBindingList(offer.bindingList, c.getRangeVariables());
                c.processSubExpressions(processor);
            }
            offer.bindingList = savedBindingList;
            return this;
        }
        try {
            for (Clause c : this.clauses) {
                c.processSubExpressions(processor);
            }
        }
        catch (XPathException e) {
            throw new IllegalStateException(e);
        }
        this.returnClause.promote(offer, this);
        return this;
    }

    private Binding[] extendBindingList(Binding[] bindings, LocalVariableBinding[] moreBindings) {
        if (bindings == null) {
            bindings = new Binding[]{};
        }
        if (moreBindings == null || moreBindings.length == 0) {
            return bindings;
        }
        Binding[] b2 = new Binding[bindings.length + moreBindings.length];
        System.arraycopy(bindings, 0, b2, 0, bindings.length);
        System.arraycopy(moreBindings, 0, b2, bindings.length, moreBindings.length);
        return b2;
    }

    @Override
    public int getEvaluationMethod() {
        return 4;
    }

    @Override
    public Expression optimize(final ExpressionVisitor visitor, final ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        for (Clause c : this.clauses) {
            c.processSubExpressions(new ExpressionProcessor(){

                public Expression processExpression(Expression expr) throws XPathException {
                    return visitor.optimize(expr, contextItemType);
                }
            });
            c.optimize(visitor, contextItemType);
        }
        this.returnClause = this.returnClause.optimize(visitor, contextItemType);
        boolean depends = false;
        for (Clause w : this.clauses) {
            if (!(w instanceof WhereClause) || !ExpressionTool.dependsOnFocus(((WhereClause)w).getPredicate())) continue;
            depends = true;
            break;
        }
        if (depends) {
            Expression expr1 = ExpressionTool.tryToFactorOutDot(this, contextItemType.itemType);
            if (expr1 == null || expr1 == this) {
                return this;
            }
            this.resetLocalStaticProperties();
            return expr1.optimize(visitor, contextItemType);
        }
        Expression expr2 = this.rewriteWhereClause(visitor, contextItemType);
        if (expr2 != null && expr2 != this) {
            return expr2.optimize(visitor, contextItemType);
        }
        boolean allForOrLetExpr = true;
        for (Clause c : this.clauses) {
            if (c instanceof ForClause || c instanceof LetClause) continue;
            allForOrLetExpr = false;
            break;
        }
        if (allForOrLetExpr) {
            return this.rewriteForOrLet(visitor, contextItemType);
        }
        return this;
    }

    private Expression rewriteWhereClause(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        int whereIndex = 0;
        class WhereClauseStruct {
            int whereIndex = 0;
            WhereClause whereClause;

            WhereClauseStruct() {
            }
        }
        ArrayList<WhereClauseStruct> whereList = new ArrayList<WhereClauseStruct>();
        for (Clause c : this.clauses) {
            if (c instanceof WhereClause) {
                WhereClauseStruct wStruct = new WhereClauseStruct();
                wStruct.whereClause = (WhereClause)c;
                wStruct.whereIndex = this.clauses.size() - whereIndex;
                whereList.add(wStruct);
            }
            ++whereIndex;
        }
        if (whereList.size() == 0) {
            return null;
        }
        while (!whereList.isEmpty()) {
            WhereClause whereClause = ((WhereClauseStruct)whereList.get((int)0)).whereClause;
            whereIndex = ((WhereClauseStruct)whereList.get((int)0)).whereIndex;
            Expression condition = whereClause.getPredicate();
            ArrayList<Expression> list = new ArrayList<Expression>(5);
            BooleanExpression.listAndComponents(condition, list);
            for (int i = list.size() - 1; i >= 0; --i) {
                Expression term = (Expression)list.get(i);
                for (int c = this.clauses.size() - whereIndex - 1; c >= 0; --c) {
                    Clause clause = this.clauses.get(c);
                    Binding[] bindingList = clause.getRangeVariables();
                    if (!ExpressionTool.dependsOnVariable(term, bindingList) && clause.getClauseKey() != 4) continue;
                    Expression removedExpr = (Expression)list.remove(i);
                    if (list.isEmpty()) {
                        this.clauses.remove(this.clauses.size() - whereIndex);
                    } else {
                        whereClause.setPredicate(this.makeAndCondition(list));
                    }
                    if (clause instanceof ForClause && !((ForClause)clause).isAllowingEmpty()) {
                        boolean added = ((ForClause)clause).addPredicate(visitor, contextItemType, term);
                        if (added) break;
                        this.clauses.add(c + 1, new WhereClause(removedExpr));
                        break;
                    }
                    WhereClause newWhere = new WhereClause(term);
                    this.clauses.add(c + 1, newWhere);
                    break;
                }
                if (list.size() - 1 != i) continue;
                list.remove(i);
                if (list.isEmpty()) {
                    this.clauses.remove(this.clauses.size() - whereIndex);
                } else {
                    whereClause.setPredicate(this.makeAndCondition(list));
                }
                WhereClause newWhere = new WhereClause(term);
                this.clauses.add(0, newWhere);
            }
            whereList.remove(0);
        }
        return this;
    }

    private Expression makeAndCondition(List<Expression> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        return new AndExpression(list.get(0), this.makeAndCondition(list.subList(1, list.size())));
    }

    private Expression rewriteForOrLet(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression action = this.returnClause;
        for (int i = this.clauses.size() - 1; i >= 0; --i) {
            if (this.clauses.get(i) instanceof ForClause) {
                ForClause forClause = (ForClause)this.clauses.get(i);
                ForExpression forExpr = forClause.isAllowingEmpty() ? (ForExpression)visitor.getConfiguration().obtainOptimizer().makeOuterForExpression() : new ForExpression();
                forExpr.setAction(action);
                forExpr.setSequence(forClause.getSequence());
                forExpr.setVariableQName(forClause.getRangeVariable().getVariableQName());
                forExpr.setRequiredType(forClause.getRangeVariable().getRequiredType());
                ExpressionTool.rebindVariableReferences(action, forClause.getRangeVariable(), forExpr);
                if (forClause.getPositionVariable() != null) {
                    PositionVariable posVar = new PositionVariable();
                    posVar.setVariableQName(forClause.getPositionVariable().getVariableQName());
                    ExpressionTool.rebindVariableReferences(action, forClause.getPositionVariable(), posVar);
                    forExpr.setPositionVariable(posVar);
                }
                action = forExpr;
                continue;
            }
            LetExpression letExpr = new LetExpression();
            letExpr.setAction(action);
            LetClause letClause = (LetClause)this.clauses.get(i);
            letExpr.setSequence(letClause.getSequence());
            letExpr.setVariableQName(letClause.getRangeVariable().getVariableQName());
            letExpr.setRequiredType(letClause.getRangeVariable().getRequiredType());
            letExpr.setRefCount(letClause.getRangeVariable().getNominalReferenceCount());
            ExpressionTool.rebindVariableReferences(action, letClause.getRangeVariable(), letExpr);
            action = letExpr;
        }
        action = action.optimize(visitor, contextItemType);
        return action;
    }

    @Override
    public SequenceIterator<? extends Item> iterate(XPathContext context) throws XPathException {
        for (int i = 1; i < this.clauses.size(); ++i) {
            if (this.clauses.get(i).getClauseKey() != 2) continue;
            Controller controller = context.getController();
            SequenceReceiver saved = context.getReceiver();
            SequenceOutputter seq = controller.allocateSequenceOutputter(20);
            seq.getPipelineConfiguration().setHostLanguage(this.getHostLanguage());
            context.setReceiver(seq);
            this.process(context);
            context.setReceiver(saved);
            seq.close();
            return seq.iterate();
        }
        TuplePull stream = new SingularityPull();
        for (Clause c : this.clauses) {
            stream = c.getPullStream(stream, context);
        }
        return new ReturnClauseIterator(stream, this, context);
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        TuplePush destination = new ReturnClausePush(this.returnClause);
        for (int i = this.clauses.size() - 1; i >= 0; --i) {
            Clause c = this.clauses.get(i);
            destination = c.getPushStream(destination, context);
        }
        ((TuplePush)destination).processTuple(context);
        ((TuplePush)destination).close();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        TuplePull stream = new SingularityPull();
        for (Clause c : this.clauses) {
            stream = c.getPullStream(stream, context);
        }
        while (((TuplePull)stream).nextTuple(context)) {
            this.returnClause.evaluatePendingUpdates(context, pul);
        }
    }

    @Override
    public String toString() {
        FastStringBuffer sb = new FastStringBuffer(64);
        for (Clause c : this.clauses) {
            sb.append(c.toString());
            sb.append(' ');
        }
        sb.append(" return ");
        sb.append(this.returnClause.toString());
        return sb.toString();
    }

    public boolean hasLoopingVariableReference(Binding binding, final Expression reference) {
        boolean foundBinding = false;
        boolean foundLoopingClause = false;
        final ArrayList bList = new ArrayList();
        ExpressionProcessor checker = new ExpressionProcessor(){

            public Expression processExpression(Expression expr) throws XPathException {
                if (expr == reference) {
                    bList.add(false);
                } else {
                    Stack<Expression> expressionStack = ExpressionTool.pathToContainedExpression(expr, reference, new Stack<Expression>());
                    if (expressionStack != null) {
                        for (int i = 0; i < expressionStack.size() - 1; ++i) {
                            Expression child;
                            Expression parent = (Expression)expressionStack.get(i);
                            if (!parent.hasLoopingSubexpression(child = (Expression)expressionStack.get(i + 1))) continue;
                            bList.add(true);
                            return expr;
                        }
                        bList.add(false);
                    }
                }
                return expr;
            }
        };
        for (Clause c : this.clauses) {
            block8: {
                if (!foundBinding && this.clauseHasBinding(c, binding)) {
                    foundBinding = true;
                    continue;
                }
                if (!foundBinding) continue;
                try {
                    c.processSubExpressions(checker);
                }
                catch (XPathException e) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
            if (!bList.isEmpty()) {
                return foundLoopingClause || (Boolean)bList.get(0) != false;
            }
            if (!FLWORExpression.isLoopingClause(c)) continue;
            foundLoopingClause = true;
        }
        if (foundBinding) {
            if (foundLoopingClause) {
                return true;
            }
            Stack<Expression> returnExpressionStack = ExpressionTool.pathToContainedExpression(this.returnClause, reference, new Stack<Expression>());
            if (returnExpressionStack != null) {
                return foundLoopingClause;
            }
        }
        return false;
    }
}

