/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.SequenceType;

public class XQueryFunction
implements InstructionInfo,
Container,
Declaration {
    private StructuredQName functionName;
    private List<UserFunctionParameter> arguments;
    private SequenceType resultType;
    private Expression body = null;
    private List references = new ArrayList(10);
    private int lineNumber;
    private int columnNumber;
    private String systemId;
    private Executable executable;
    private UserFunction compiledFunction = null;
    private boolean memoFunction;
    private NamespaceResolver namespaceResolver;
    private QueryModule staticContext;
    private boolean isUpdating = false;
    private boolean isPrivate = false;

    public XQueryFunction() {
        this.arguments = new ArrayList<UserFunctionParameter>(8);
    }

    public int getContainerGranularity() {
        return 2;
    }

    public void setFunctionName(StructuredQName name) {
        this.functionName = name;
    }

    public void addArgument(UserFunctionParameter argument) {
        this.arguments.add(argument);
    }

    public void setResultType(SequenceType resultType) {
        this.resultType = resultType;
    }

    public void setBody(Expression body) {
        this.body = body;
        if (body != null) {
            body.setContainer(this);
        }
    }

    public Expression getBody() {
        return this.body;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setLineNumber(int line) {
        this.lineNumber = line;
    }

    public void setColumnNumber(int column) {
        this.columnNumber = column;
    }

    public StructuredQName getFunctionName() {
        return this.functionName;
    }

    public String getDisplayName() {
        return this.functionName.getDisplayName();
    }

    public String getIdentificationKey() {
        return this.functionName.getClarkName() + '/' + this.arguments.size();
    }

    public static String getIdentificationKey(String uri, String localName, int arity) {
        FastStringBuffer sb = new FastStringBuffer(uri.length() + localName.length() + 8);
        sb.append('{');
        sb.append(uri);
        sb.append('}');
        sb.append(localName);
        sb.append('/');
        sb.append(arity + "");
        return sb.toString();
    }

    public static String getIdentificationKey(StructuredQName qName, int arity) {
        String uri = qName.getURI();
        String localName = qName.getLocalPart();
        FastStringBuffer sb = new FastStringBuffer(uri.length() + localName.length() + 8);
        sb.append('{');
        sb.append(uri);
        sb.append('}');
        sb.append(localName);
        sb.append("/" + arity);
        return sb.toString();
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public void setExecutable(Executable exec) {
        this.executable = exec;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public LocationProvider getLocationProvider() {
        return this.executable.getLocationMap();
    }

    public void setStaticContext(QueryModule env) {
        this.staticContext = env;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public SequenceType[] getArgumentTypes() {
        SequenceType[] types = new SequenceType[this.arguments.size()];
        for (int i = 0; i < this.arguments.size(); ++i) {
            types[i] = this.arguments.get(i).getRequiredType();
        }
        return types;
    }

    public UserFunctionParameter[] getParameterDefinitions() {
        UserFunctionParameter[] params = new UserFunctionParameter[this.arguments.size()];
        return this.arguments.toArray(params);
    }

    public int getNumberOfArguments() {
        return this.arguments.size();
    }

    public void registerReference(UserFunctionCall ufc) {
        this.references.add(ufc);
    }

    public void setMemoFunction(boolean isMemoFunction) {
        this.memoFunction = isMemoFunction;
    }

    public boolean isMemoFunction() {
        return this.memoFunction;
    }

    public void setUpdating(boolean isUpdating) {
        this.isUpdating = isUpdating;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public void setPrivate(boolean privateFunction) {
        this.isPrivate = privateFunction;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void compile() throws XPathException {
        Configuration config = this.staticContext.getConfiguration();
        try {
            if (this.compiledFunction == null) {
                SlotManager map = config.makeSlotManager();
                UserFunctionParameter[] params = this.getParameterDefinitions();
                for (int i = 0; i < params.length; ++i) {
                    params[i].setSlotNumber(i);
                    map.allocateSlotNumber(params[i].getVariableQName());
                }
                ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext, this.getExecutable());
                this.body = visitor.simplify(this.body);
                this.body = visitor.typeCheck(this.body, null);
                this.body.setContainer(this);
                RoleLocator role = new RoleLocator(5, this.functionName, 0);
                this.body = TypeChecker.staticTypeCheck(this.body, this.resultType, false, role, visitor);
                if (config.isCompileWithTracing()) {
                    this.namespaceResolver = this.staticContext.getNamespaceResolver();
                    TraceExpression trace = new TraceExpression(this.body);
                    trace.setConstructType(155);
                    trace.setObjectName(this.functionName);
                    trace.setLocationId(this.staticContext.getLocationMap().allocateLocationId(this.systemId, this.lineNumber));
                    this.body = trace;
                }
                this.compiledFunction = config.newUserFunction(this.memoFunction);
                this.compiledFunction.setBody(this.body);
                this.compiledFunction.setHostLanguage(51);
                this.compiledFunction.setFunctionName(this.functionName);
                this.compiledFunction.setParameterDefinitions(params);
                this.compiledFunction.setResultType(this.getResultType());
                this.compiledFunction.setLineNumber(this.lineNumber);
                this.compiledFunction.setSystemId(this.systemId);
                this.compiledFunction.setExecutable(this.executable);
                this.compiledFunction.setStackFrameMap(map);
                this.compiledFunction.setUpdating(this.isUpdating);
                for (int i = 0; i < params.length; ++i) {
                    UserFunctionParameter param = params[i];
                    int refs = ExpressionTool.getReferenceCount(this.body, param, false);
                    param.setReferenceCount(refs);
                }
            }
            this.fixupReferences();
            FunctionLibraryList libList = this.executable.getFunctionLibrary();
            if (libList.getLibraryList().size() == 1 && libList.getLibraryList().get(0) instanceof ExecutableFunctionLibrary) {
                ExecutableFunctionLibrary lib = (ExecutableFunctionLibrary)libList.getLibraryList().get(0);
                lib.addFunction(this.compiledFunction);
            }
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            throw e;
        }
    }

    public void optimize() throws XPathException {
        this.body.checkForUpdatingSubexpressions();
        if (this.isUpdating) {
            if (!ExpressionTool.isAllowedInUpdatingContext(this.body)) {
                XPathException err = new XPathException("The body of an updating function must be an updating expression", "XUST0002");
                err.setLocator(this.body);
                throw err;
            }
        } else if (this.body.isUpdatingExpression()) {
            XPathException err = new XPathException("The body of a non-updating function must be a non-updating expression", "XUST0001");
            err.setLocator(this.body);
            throw err;
        }
        ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext, this.getExecutable());
        Configuration config = this.staticContext.getConfiguration();
        Optimizer opt = config.obtainOptimizer();
        int arity = this.arguments.size();
        if (opt.getOptimizationLevel() != 0) {
            int tailCalls;
            this.body = visitor.optimize(this.body, null);
            Expression b2 = opt.promoteExpressionsToGlobal(this.body, visitor);
            if (b2 != null) {
                this.body = visitor.optimize(b2, null);
            }
            if (!this.isUpdating && (tailCalls = ExpressionTool.markTailFunctionCalls(this.body, this.functionName, arity)) != 0) {
                this.compiledFunction.setBody(this.body);
                this.compiledFunction.setTailRecursive(tailCalls > 0, tailCalls > 1);
                this.body = new TailCallLoop(this.compiledFunction);
            }
            this.body.setContainer(this);
            this.compiledFunction.setBody(this.body);
        }
        this.compiledFunction.computeEvaluationMode();
        ExpressionTool.allocateSlots(this.body, arity, this.compiledFunction.getStackFrameMap());
        if (config.isGenerateByteCode(51)) {
            Expression cbody = opt.compileToByteCode(this.body, this.getFunctionName().getDisplayName(), 6);
            if (cbody != null) {
                this.body = cbody;
            }
            this.compiledFunction.setBody(this.body);
        }
    }

    public void fixupReferences() throws XPathException {
        for (UserFunctionCall ufc : this.references) {
            ufc.setFunction(this.compiledFunction);
            ufc.computeArgumentEvaluationModes();
        }
    }

    public void checkReferences(ExpressionVisitor visitor) throws XPathException {
        for (UserFunctionCall ufc : this.references) {
            ufc.checkFunctionCall(this.compiledFunction, visitor);
            ufc.computeArgumentEvaluationModes();
        }
        this.references = new ArrayList(0);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("declareFunction");
        out.emitAttribute("name", this.functionName.getDisplayName());
        out.emitAttribute("arity", "" + this.getNumberOfArguments());
        if (this.compiledFunction == null) {
            out.emitAttribute("unreferenced", "true");
        } else {
            if (this.compiledFunction.isMemoFunction()) {
                out.emitAttribute("memo", "true");
            }
            out.emitAttribute("tailRecursive", this.compiledFunction.isTailRecursive() ? "true" : "false");
            this.body.explain(out);
        }
        out.endElement();
    }

    public UserFunction getUserFunction() {
        return this.compiledFunction;
    }

    public int getConstructType() {
        return 155;
    }

    public StructuredQName getObjectName() {
        return this.functionName;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getSystemId(long locationId) {
        return this.getSystemId();
    }

    public int getLineNumber(long locationId) {
        return this.getLineNumber();
    }

    public int getColumnNumber(long locationId) {
        return this.getColumnNumber();
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public Object getProperty(String name) {
        if ("name".equals(name)) {
            return this.functionName.getDisplayName();
        }
        if ("as".equals(name)) {
            return this.resultType.toString();
        }
        return null;
    }

    public Iterator getProperties() {
        return new PairIterator<String>("name", "as");
    }

    public int getHostLanguage() {
        return 51;
    }
}

