/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.log.logsession;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.lab.workflow.Messages;
import info.textgrid.lab.workflow.WorkflowJob;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.AbortWorkflowRequest;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.AbortWorkflowResponse;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.GetMyWorkflowIDsRequest;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.GetMyWorkflowIDsResponse;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.GetWorkflowDocumentRequest;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.GetWorkflowDocumentResponse;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.Gwesproxy;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.PortGwesproxy;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.Property;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.WFDetails;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class WorkflowEngine {
    private static final String GWESPROXY_DEFAULT_ENDPOINT = "https://textgridlab.org/1.0/workflow/GWESproxy.wsdl";
    private static PortGwesproxy gwesProxy;
    private static WorkflowEngine we;

    static {
        we = null;
    }

    private WorkflowEngine() {
        Status status;
        String endpoint = GWESPROXY_DEFAULT_ENDPOINT;
        try {
            endpoint = ConfClient.getInstance().getValue("workflow");
        }
        catch (OfflineException e) {
            OnlineStatus.netAccessFailed((String)Messages.WorkflowEngine_2, (Throwable)e);
        }
        if ("".equals(endpoint)) {
            status = new Status(2, "info.textgrid.lab.workflow", Messages.WorkflowEngine_1, null);
            Activator.getDefault().getLog().log((IStatus)status);
            endpoint = GWESPROXY_DEFAULT_ENDPOINT;
        }
        status = new Status(1, "info.textgrid.lab.workflow", "gwesProxy endpoint: " + endpoint, null);
        Activator.getDefault().getLog().log((IStatus)status);
        try {
            Gwesproxy gp = new Gwesproxy(URI.create(endpoint).toURL());
            gwesProxy = gp.getTnsGwesproxy();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public PortGwesproxy getGwesProxy() {
        return gwesProxy;
    }

    public static WorkflowEngine getInstance() {
        if (we == null) {
            we = new WorkflowEngine();
        }
        return we;
    }

    public String getStatus(String workflowID) {
        GetMyWorkflowIDsRequest req = new GetMyWorkflowIDsRequest();
        req.setAuth(RBACSession.getInstance().getSID(false));
        GetMyWorkflowIDsResponse resp = this.getGwesProxy().getMyWorkflowIDs(req);
        for (WFDetails detail : resp.getWorkflow()) {
            if (!detail.getID().equals(workflowID)) continue;
            for (Property p : detail.getProperty()) {
                if (!p.getName().equals("status")) continue;
                return p.getValue();
            }
        }
        return Messages.WorkflowEngine_0;
    }

    public WorkflowJob getWorkflowJob(String workflowID) {
        GetMyWorkflowIDsRequest req = new GetMyWorkflowIDsRequest();
        req.setAuth(RBACSession.getInstance().getSID(false));
        GetMyWorkflowIDsResponse resp = this.getGwesProxy().getMyWorkflowIDs(req);
        for (WFDetails detail : resp.getWorkflow()) {
            if (!detail.getID().equals(workflowID)) continue;
            return new WorkflowJob(detail);
        }
        return null;
    }

    public ArrayList<WorkflowJob> getMyJobs() {
        ArrayList<WorkflowJob> result = new ArrayList<WorkflowJob>();
        GetMyWorkflowIDsRequest req = new GetMyWorkflowIDsRequest();
        req.setAuth(RBACSession.getInstance().getSID(false));
        req.setLog(logsession.getInstance().getloginfo());
        GetMyWorkflowIDsResponse resp = this.getGwesProxy().getMyWorkflowIDs(req);
        for (WFDetails detail : resp.getWorkflow()) {
            result.add(new WorkflowJob(detail));
        }
        return result;
    }

    public String getWorkflowString(String workflowID) {
        GetWorkflowDocumentRequest req = new GetWorkflowDocumentRequest();
        req.setWorkflowid(workflowID);
        req.setAuth(RBACSession.getInstance().getSID(false));
        req.setLog(logsession.getInstance().getloginfo());
        GetWorkflowDocumentResponse resp = this.getGwesProxy().getWorkflowDocument(req);
        return resp.getGwdl();
    }

    public boolean abortWorkflow(String workflowID) {
        AbortWorkflowRequest req = new AbortWorkflowRequest();
        req.setWorkflowid(workflowID);
        req.setAuth(RBACSession.getInstance().getSID(false));
        req.setLog(logsession.getInstance().getloginfo());
        AbortWorkflowResponse resp = this.getGwesProxy().abortWorkflow(req);
        return resp.isResult();
    }
}

