/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.views;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.lab.workflow.WorkflowEngine;
import info.textgrid.lab.workflow.WorkflowJob;
import info.textgrid.lab.workflow.views.Messages;
import info.textgrid.lab.workflow.views.WorkflowResults;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.PortGwesproxy;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class JobManagement
extends ViewPart {
    public static final String WORKFLOW_RESULTS_VIEW_ID = "info.textgrid.lab.workflow.views.WorkflowResults";
    private TableViewer viewer;
    private ArrayList<WorkflowJob> jobList = new ArrayList();
    private PortGwesproxy proxy;
    private SimpleDateFormat shortDateFormatter = new SimpleDateFormat("dd.MM. HH:mm:ss");
    private Job neverEndingJob = null;
    private Job openOutputsJob = null;
    private WorkflowJob[] jobArray;
    private WorkflowResults wpInstance = null;

    public JobManagement() {
        this.proxy = WorkflowEngine.getInstance().getGwesProxy();
    }

    public void createPartControl(Composite parent) {
        Composite c = new Composite(parent, 4);
        c.setLayout((Layout)new GridLayout(1, false));
        GridData cGD = new GridData();
        cGD.horizontalAlignment = 4;
        cGD.grabExcessVerticalSpace = true;
        cGD.grabExcessHorizontalSpace = true;
        cGD.heightHint = 100;
        cGD.widthHint = 400;
        cGD.verticalAlignment = 4;
        c.setLayoutData((Object)cGD);
        this.viewer = new TableViewer(c, 66308);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        TableColumn tcDesc = new TableColumn(this.viewer.getTable(), 0);
        tcDesc.setText(Messages.JobManagement_WFJobTitle);
        tcDesc.setWidth(150);
        TableColumn tcStart = new TableColumn(this.viewer.getTable(), 0);
        tcStart.setText(Messages.JobManagement_WFJobStart);
        tcStart.setWidth(100);
        TableColumn tcStat = new TableColumn(this.viewer.getTable(), 0);
        tcStat.setText(Messages.JobManagement_WFJobStatus);
        tcStat.setWidth(70);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.refreshJobList();
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JobManagement.this.openOutputs();
            }
        });
        GridData vGD = new GridData();
        vGD.horizontalAlignment = 4;
        vGD.grabExcessVerticalSpace = true;
        vGD.grabExcessHorizontalSpace = true;
        vGD.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)vGD);
        Composite bottomBar = new Composite(c, 4);
        bottomBar.setLayout((Layout)new GridLayout(4, false));
        GridDataFactory.fillDefaults().applyTo((Control)bottomBar);
        Button abortButton = new Button(bottomBar, 8);
        abortButton.setText(Messages.JobManagement_AbortButtonText);
        abortButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JobManagement.this.abortWorkflow();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void openOutputs() {
        if (this.openOutputsJob != null) {
            this.openOutputsJob.cancel();
        }
        this.openOutputsJob = new Job(Messages.JobManagement_JobOpeningResults){

            protected IStatus run(IProgressMonitor monitor) {
                JobManagement.this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IStructuredSelection wfss = (IStructuredSelection)JobManagement.this.viewer.getSelection();
                        WorkflowJob wfJ = (WorkflowJob)wfss.getFirstElement();
                        if (wfJ == null) {
                            return;
                        }
                        if (wfJ.hasErrors()) {
                            JobManagement.this.logNshowErrors(wfJ);
                            wfJ = null;
                        }
                        if (JobManagement.this.wpInstance == null) {
                            IViewPart wfResultsView = null;
                            try {
                                wfResultsView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(JobManagement.WORKFLOW_RESULTS_VIEW_ID);
                            }
                            catch (PartInitException e) {
                                Status status = new Status(4, "info.textgrid.lab.workflow", "Could not open workflow results view", (Throwable)e);
                                Activator.getDefault().getLog().log((IStatus)status);
                            }
                            if (wfResultsView != null && wfResultsView instanceof WorkflowResults) {
                                WorkflowResults wpInstance = (WorkflowResults)wfResultsView;
                                wpInstance.refreshViewer(wfJ);
                            }
                        } else {
                            JobManagement.this.wpInstance.refreshViewer(wfJ);
                        }
                    }
                });
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.openOutputsJob.setPriority(20);
        this.openOutputsJob.schedule();
    }

    public void abortWorkflow() {
        IStructuredSelection wfss = (IStructuredSelection)this.viewer.getSelection();
        WorkflowJob oneJob = (WorkflowJob)wfss.getFirstElement();
        WorkflowEngine.getInstance().abortWorkflow(oneJob.getWfID());
        this.refreshJobList();
    }

    public void spawnNeverEndingJob() {
        if (this.neverEndingJob != null) {
            this.neverEndingJob.cancel();
        }
        this.neverEndingJob = new Job(Messages.JobManagement_JobMgmtUpdaterJob){

            protected IStatus run(IProgressMonitor monitor) {
                boolean allJobsCompleted = false;
                while (!allJobsCompleted && !JobManagement.this.viewer.getControl().isDisposed()) {
                    allJobsCompleted = true;
                    ArrayList<WorkflowJob> jobList = WorkflowEngine.getInstance().getMyJobs();
                    for (WorkflowJob wfjob : jobList) {
                        if (!wfjob.getStatus().equals("ACTIVE")) continue;
                        allJobsCompleted = false;
                        break;
                    }
                    JobManagement.this.jobArray = jobList.toArray(new WorkflowJob[0]);
                    Arrays.sort(JobManagement.this.jobArray, null);
                    JobManagement.this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            JobManagement.this.viewer.setInput((Object)JobManagement.this.jobArray);
                        }
                    });
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.neverEndingJob.setSystem(true);
        this.neverEndingJob.setPriority(30);
        this.neverEndingJob.schedule();
    }

    public void refreshJobList() {
        if (RBACSession.getInstance().getSID(false).equals("")) {
            return;
        }
        this.spawnNeverEndingJob();
    }

    public void setFocus() {
    }

    private void logNshowErrors(WorkflowJob j) {
        Status status = new Status(4, "info.textgrid.lab.workflow", j.getErrors(), (Throwable)new Exception("GWES workflow engine found errors in workflow " + j.toString() + " started at " + this.shortDateFormatter.format(j.getDate())));
        Activator.getDefault().getLog().log((IStatus)status);
        MessageBox mb = new MessageBox(this.getSite().getWorkbenchWindow().getShell(), 33);
        mb.setText(MessageFormat.format(Messages.JobManagement_FailedMessageTitle, j.toString(), this.shortDateFormatter.format(j.getDate())));
        mb.setMessage(String.valueOf(Messages.JobManagement_FailedMessageDetails) + j.getErrors());
        mb.open();
    }

    public void dispose() {
        super.dispose();
        this.neverEndingJob.cancel();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (index == 0) {
                return obj.toString();
            }
            if (index == 1) {
                return JobManagement.this.shortDateFormatter.format(((WorkflowJob)obj).getDate());
            }
            if (index == 2) {
                String statusstring = ((WorkflowJob)obj).getStatus();
                if (statusstring.equals("TERMINATED")) {
                    return Messages.JobManagement_StatusFailed;
                }
                if (statusstring.equals("COMPLETED")) {
                    return Messages.JobManagement_StatusCompleted;
                }
                if (statusstring.equals("ACTIVE")) {
                    return Messages.JobManagement_StatusActive;
                }
                return statusstring.toLowerCase();
            }
            return "extra column " + index;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

