/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.wizard;

import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.ChainTGWF;
import info.textgrid.lab.workflow.tgwf.Tgwf;
import info.textgrid.lab.workflow.wizard.FinalPage;
import info.textgrid.lab.workflow.wizard.LinkInsertionPage;
import info.textgrid.lab.workflow.wizard.Messages;
import info.textgrid.lab.workflow.wizard.MetadataTransformationPage;
import info.textgrid.lab.workflow.wizard.ServiceConfigurationPage;
import info.textgrid.lab.workflow.wizard.ServiceOrderingPage;
import info.textgrid.lab.workflow.wizard.ServiceSelectionPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXB;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class WorkflowWizard
extends Wizard
implements INewWizard {
    Chain chain = new Chain();
    ServiceSelectionPage serviceSelection;
    ServiceOrderingPage serviceOrdering;
    LinkInsertionPage linkInsertion;
    ServiceConfigurationPage serviceConfiguration;
    MetadataTransformationPage metadataTransformation;
    FinalPage finalPage;
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    private TextGridObject originalTGO;
    private String originalProjectId;
    private String originalTitle;

    public void addPages() {
        this.serviceSelection = new ServiceSelectionPage("XXX");
        this.addPage((IWizardPage)this.serviceSelection);
        this.serviceOrdering = new ServiceOrderingPage("YYY");
        this.addPage((IWizardPage)this.serviceOrdering);
        this.linkInsertion = new LinkInsertionPage("LLL");
        this.addPage((IWizardPage)this.linkInsertion);
        this.serviceConfiguration = new ServiceConfigurationPage("CCC");
        this.addPage((IWizardPage)this.serviceConfiguration);
        this.metadataTransformation = new MetadataTransformationPage("MMM");
        this.addPage((IWizardPage)this.metadataTransformation);
        this.finalPage = new FinalPage("FFF");
        this.addPage((IWizardPage)this.finalPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object obj;
        this.workbench = workbench;
        this.selection = selection;
        if (selection != null && !selection.isEmpty() && (obj = selection.getFirstElement()) instanceof TextGridObject) {
            this.originalTGO = (TextGridObject)obj;
            this.setChainFromTGWF(this.originalTGO);
        }
    }

    public void setChainFromTGWF(TextGridObject tgwfTGO) {
        this.originalTGO = tgwfTGO;
        IFile tgwfFile = (IFile)tgwfTGO.getAdapter(IFile.class);
        Tgwf tgwf = null;
        try {
            tgwf = (Tgwf)JAXB.unmarshal((InputStream)tgwfFile.getContents(true), Tgwf.class);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ChainTGWF ct = new ChainTGWF(tgwf);
        this.chain = ct.getChain();
        try {
            this.originalTitle = tgwfTGO.getTitle();
            this.setWindowTitle(this.originalTitle);
            this.originalProjectId = tgwfTGO.getProject();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public TextGridObject getOriginalTGO() {
        return this.originalTGO;
    }

    public String getOriginalProjectId() {
        return this.originalProjectId;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setOriginalTGO(TextGridObject originalTGO) {
        this.originalTGO = originalTGO;
    }

    public void setOriginalProjectId(String originalProjectId) {
        this.originalProjectId = originalProjectId;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
    }

    Chain getChain() {
        return this.chain;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.finalPage && (this.originalTGO != null && this.finalPage.getUpdateOriginalTGO() != false || this.finalPage.getNameTextString() != null && this.finalPage.getNameTextString().length() > 0 && this.finalPage.getSelectedProject() != null);
    }

    private void showMessage(String message) {
        MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 42);
        mb.setMessage(message);
        mb.open();
    }

    public boolean performFinish() {
        TextGridObject tgwfTGO;
        this.chain.setDescription(this.finalPage.getDescriptionText().getText());
        String tgwf = this.chain.toString();
        String title = this.finalPage.getNameTextString();
        if (this.originalTGO != null && this.finalPage.getUpdateOriginalTGO().booleanValue()) {
            tgwfTGO = this.originalTGO;
        } else {
            if (this.finalPage.getSelectedProject() == null) {
                this.showMessage(Messages.WorkflowWizard_NoTargetProjectMessage);
                return false;
            }
            tgwfTGO = TextGridObject.getNewObjectInstance((TextGridProject)this.finalPage.getSelectedProject(), (TGContentType)TGContentType.getContentType((String)"text/tg.workflow+xml"), (String)title);
        }
        IFile file = (IFile)AdapterUtils.getAdapter((Object)tgwfTGO, IFile.class);
        if (file == null) {
            System.out.println("Cannot save " + title);
        } else {
            try {
                file.setContents((InputStream)new ByteArrayInputStream(tgwf.getBytes("UTF-8")), true, false, null);
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
        return true;
    }
}

