/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.configurators;

import info.textgrid.lab.core.importexport.configurators.AbstractAggregationSupplier;
import info.textgrid.lab.core.importexport.model.ISpecialImportEntrySupplier;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;

public class ZipFileSupplier
extends AbstractAggregationSupplier
implements ISpecialImportEntrySupplier {
    private final ZipFile zipFile;

    public ZipFileSupplier(ZipFile zipFile, ImportEntry entry) {
        super(entry);
        this.zipFile = zipFile;
    }

    @Override
    protected String[] getAggregationEntries() {
        ArrayList<? extends ZipEntry> entries = Collections.list(this.zipFile.entries());
        String[] result = new String[entries.size()];
        int i = 0;
        for (ZipEntry zipEntry : entries) {
            result[i++] = String.valueOf(FilenameUtils.getName((String)this.zipFile.getName())) + "/" + zipEntry.getName();
        }
        return result;
    }

    @Override
    public File getFile() {
        return new File(this.zipFile.getName());
    }
}

