/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.ui;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import info.textgrid.lab.core.importexport.ui.Messages;
import info.textgrid.lab.core.model.ITextGridProjectListener;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.ui.core.utils.ProjectCombo;
import info.textgrid.lab.ui.core.utils.TGODefaultLabelProvider;
import info.textgrid.lab.ui.core.utils.UpdatingDeferredListContentProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class TargetProjectCombo
extends ProjectCombo {
    private Set<String> reimportProjects = ImmutableSet.of();

    public void textGridProjectChanged(ITextGridProjectListener.Event event, TextGridProject project) {
        if (this.isLoadDone()) {
            switch (event) {
                case CREATED: {
                    this.add(new ProjectEntry(project, false));
                    break;
                }
                case DELETED: {
                    this.remove(new ProjectEntry(project, false));
                    this.remove(new ProjectEntry(project, true));
                }
            }
        }
    }

    public void setProject(TextGridProject project) {
        this.selectedProject = project;
        if (this.isLoadDone()) {
            this.setSelection((ISelection)new StructuredSelection((Object)new ProjectEntry(project, false)));
        }
    }

    public void init(TextGridProjectRoot.LEVELS level) {
        ContentProvider contentProvider = new ContentProvider();
        this.setContentProvider((IContentProvider)contentProvider);
        contentProvider.addDoneListener((DeferredListContentProvider.IDoneListener)this);
        this.setLabelProvider((IBaseLabelProvider)new TGODefaultLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ProjectEntry) {
                    ProjectEntry entry = (ProjectEntry)element;
                    if (entry.revision) {
                        return NLS.bind((String)Messages.TargetProjectCombo_x_create_new_revisions, (Object)super.getText((Object)entry.project));
                    }
                    return super.getText((Object)entry.project);
                }
                return super.getText(element);
            }
        });
        super.init(level);
    }

    public TargetProjectCombo(Composite parent) {
        super(parent, TextGridProjectRoot.LEVELS.EDITOR);
    }

    public synchronized void setReimportProjects(Set<String> reimportProjects) {
        this.reimportProjects = Collections.synchronizedSet(reimportProjects);
        this.refreshReimport();
    }

    public synchronized Set<String> getReimportProjects() {
        return this.reimportProjects;
    }

    public void refreshReimport() {
        ((ContentProvider)this.getContentProvider()).setNextUpdateInternal(true);
        this.refresh();
    }

    public boolean isNewRevision() {
        IStructuredSelection selection;
        if (!this.getControl().isDisposed() && !(selection = (IStructuredSelection)this.getSelection()).isEmpty()) {
            return ((ProjectEntry)selection.getFirstElement()).revision;
        }
        return false;
    }

    private final class ContentProvider
    extends UpdatingDeferredListContentProvider {
        private Set<TextGridProject> projects = Collections.synchronizedSet(new HashSet());
        private boolean internalUpdate = false;

        private ContentProvider() {
        }

        public void setNextUpdateInternal(boolean internalUpdate) {
            this.internalUpdate = internalUpdate;
        }

        public boolean isNextUpdateInternal() {
            return this.internalUpdate;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (this.projects != null) {
                this.projects.clear();
            }
            super.inputChanged(viewer, oldInput, newInput);
        }

        public Object[] getElements(Object inputElement) {
            if (this.isNextUpdateInternal() && !this.projects.isEmpty()) {
                this.setNextUpdateInternal(false);
                return this.getPreparedObjectEntries();
            }
            return super.getElements(inputElement);
        }

        private ProjectEntry[] getPreparedObjectEntries() {
            ArrayList result = Lists.newArrayListWithExpectedSize((int)(this.projects.size() + 1));
            for (TextGridProject project : this.projects) {
                if (TargetProjectCombo.this.getReimportProjects().contains(project.getId())) {
                    result.add(new ProjectEntry(project, true));
                }
                result.add(new ProjectEntry(project, false));
            }
            return result.toArray(new ProjectEntry[0]);
        }

        protected void addElements(Object[] elements, IProgressMonitor monitor) {
            ArrayList result = Lists.newArrayList();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                TextGridProject project = (TextGridProject)AdapterUtils.getAdapter((Object)element, TextGridProject.class);
                this.projects.add(project);
                if (TargetProjectCombo.this.getReimportProjects().contains(project.getId())) {
                    result.add(new ProjectEntry(project, true));
                } else {
                    result.add(new ProjectEntry(project, false));
                }
                ++n2;
            }
            super.addElements(result.toArray(), monitor);
        }
    }

    private static class ProjectEntry
    implements IAdaptable {
        public final TextGridProject project;
        public final boolean revision;

        public ProjectEntry(TextGridProject project, boolean revision) {
            this.project = project;
            this.revision = revision;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            result = 31 * result + (this.revision ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectEntry other = (ProjectEntry)obj;
            if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
                return false;
            }
            return this.revision == other.revision;
        }

        public String toString() {
            return "ProjectEntry [project=" + this.project + ", revision=" + this.revision + "]";
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(TextGridProject.class)) {
                return this.project;
            }
            return null;
        }
    }
}

