/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.SchedulingException;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class ModelAdaptorFactory
implements IAdapterFactory {
    private Class[] adapterList = new Class[]{IFile.class, TextGridObject.class, File.class};

    protected static IFile getFileFor(TextGridObject object, boolean createProject) {
        IProject project;
        block10: {
            project = ModelAdaptorFactory.getOpenProject(object, createProject);
            if (project != null) break block10;
            return null;
        }
        try {
            String nameCandidate = object.getNameCandidate();
            if (System.getProperties().getProperty("os.name").toUpperCase().contains("WINDOWS")) {
                nameCandidate = nameCandidate.replaceAll("[:/\\\\*?\"<>|]", "_");
            }
            String fileExtension = ModelAdaptorFactory.computeFileExtension(object);
            long nameSuffix = 0L;
            Pattern namePattern = Pattern.compile(String.valueOf(Pattern.quote(nameCandidate)) + "(?: \\([1-9][0-9]*\\))?" + Pattern.quote(fileExtension), 2);
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member instanceof IFile) {
                    if (object.getEFSURI().equals(member.getLocationURI())) {
                        return (IFile)member;
                    }
                    Matcher matcher = namePattern.matcher(member.getName());
                    if (matcher.matches()) {
                        if (matcher.groupCount() >= 1 && matcher.group(1) != null) {
                            int matchedSuffix = Integer.parseInt(matcher.group(1));
                            nameSuffix = Math.max((long)(matchedSuffix + 1), nameSuffix);
                        } else {
                            ++nameSuffix;
                        }
                    }
                }
                ++n2;
            }
            String name = nameSuffix == 0L ? String.valueOf(nameCandidate) + fileExtension : String.valueOf(nameCandidate) + " (" + nameSuffix + ")" + fileExtension;
            IFile file = project.getFile(name);
            return file;
        }
        catch (CoreException e) {
            Activator.handleError(e, "Internal Error: Cannot extract {0}'s project. Please file a bug report.", object);
            return null;
        }
    }

    protected static IFile createFileFor(TextGridObject object) {
        IFile file;
        block6: {
            file = ModelAdaptorFactory.getFileFor(object, true);
            if (file != null && !file.exists()) {
                try {
                    SchedulingException.check(file.getWorkspace().getRuleFactory().createRule((IResource)file), object, "Could not create the link {0} for {1} due to scheduling issues.", file, object);
                    if (Activator.getDefault().isDebugging()) {
                        System.out.println(NLS.bind((String)"ModelAdaptorFactory: IFile({0}).createLink({1})", (Object)file, (Object)object));
                    }
                    if (!file.exists()) {
                        file.createLink(object.getEFSURI(), 272, null);
                    }
                }
                catch (ResourceException e) {
                    Activator.handleProblem(2, e, "Problem creating link to {0} as {1}", object, file);
                }
                catch (Exception e) {
                    Activator.handleError(e, "Error creating link to {0} as {1}", object, file);
                    if (e instanceof CoreException) break block6;
                    throw (RuntimeException)e;
                }
            }
        }
        return file;
    }

    protected static IProject getOpenProject(TextGridObject object, boolean createProject) throws CoreException {
        String projectName;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName = object.getProject());
        if (!project.exists()) {
            if (createProject) {
                ISchedulingRule createRule = project.getWorkspace().getRuleFactory().createRule((IResource)project);
                SchedulingException.check(createRule, object, "Failed to get the file for {0}: We need to materialize the project, {1}, but we aren't allowed to due to the current scheduling rules.\nThis is probably a programming error within TextGridLab, please file a detailed bug report.", new Object[0]);
                project.create(null);
            } else {
                return null;
            }
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        return project;
    }

    private TextGridObject getTextGridObjectFor(IFile file) throws CrudServiceException {
        URI uri = TextGridObject.computeTextGridURI(file.getLocationURI());
        if (uri == null) {
            return null;
        }
        if ("textgrid".equalsIgnoreCase(uri.getScheme()) || "textgrid-newfile".equalsIgnoreCase(uri.getScheme())) {
            return TextGridObject.getInstance(uri, false);
        }
        if (!file.exists()) {
            try {
                uri = new URI("textgrid", file.getFullPath().toPortableString(), null);
            }
            catch (URISyntaxException e) {
                Activator.handleError(e, "Subtle temporary URI creation problem for {0}. This should not happen, please file a bug report.", file);
            }
        }
        return null;
    }

    private static String computeFileExtension(TextGridObject object) {
        String format = "";
        try {
            format = object.getContentTypeID();
        }
        catch (CoreException e) {
            Activator.handleError(e, "Could not determine the TextGridObjects format!", new Object[0]);
        }
        String result = ".tgo";
        TGContentType type = TGContentType.findMatchingContentType(format);
        if (type != null && type.getExtension() != null && !"".equals(type.getExtension())) {
            result = "." + type.getExtension();
        }
        return result;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        Object tgo;
        if (!(adaptableObject instanceof TextGridObject) && !adapterType.isAssignableFrom(TextGridObject.class) && (tgo = Platform.getAdapterManager().getAdapter(adaptableObject, TextGridObject.class)) != null) {
            adaptableObject = tgo;
        }
        if (adaptableObject instanceof TextGridObject) {
            TextGridObject object = (TextGridObject)adaptableObject;
            if (adapterType.equals(IFile.class)) {
                return ModelAdaptorFactory.createFileFor(object);
            }
            if (adapterType.equals(File.class)) {
                try {
                    IFileStore store = EFS.getStore((URI)object.getEFSURI());
                    return store.toLocalFile(4096, null);
                }
                catch (CoreException e) {
                    Activator.handleError(e, "Error creating a local cached copy of {0}", object);
                }
            }
        } else if (adaptableObject instanceof IFile && adapterType.isAssignableFrom(TextGridObject.class)) {
            try {
                return this.getTextGridObjectFor((IFile)adaptableObject);
            }
            catch (CrudServiceException e) {
                Activator.handleError((Throwable)((Object)e), "Could not convert {0} to {1}: {2}", adaptableObject, adapterType, e.getLocalizedMessage());
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return this.adapterList;
    }
}

