/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import info.textgrid.lab.core.model.Activator;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;

public class TGContentType
implements Comparable<TGContentType> {
    private static Map<String, TGContentType> registry;
    private static List<TGContentType> publicTypes;
    public static final String UNKNOWN_ID = "unknown/unknown";
    private String id;
    private String description;
    private Pattern additionalTypes;
    private String extension;
    private String eclipseContentType;
    private boolean internal = false;
    private IContributor contributor;
    private ImageDescriptor imageDescriptor;
    private String imagePath;
    private boolean creatable;
    private boolean adHoc = false;

    public boolean isCreatable() {
        return this.creatable;
    }

    public boolean isAdHoc() {
        return this.adHoc;
    }

    public String getExtension() {
        return this.extension;
    }

    public Pattern getAdditionalTypes() {
        return this.additionalTypes;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEclipseContentTypeID() {
        return this.eclipseContentType;
    }

    public IContentType getEclipseContentType() {
        return this.eclipseContentType == null ? null : Platform.getContentTypeManager().getContentType(this.eclipseContentType);
    }

    public boolean isInternal() {
        return this.internal;
    }

    public IContributor getContributor() {
        return this.contributor;
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor descriptor;
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        if (this.imageDescriptor == null && this.imagePath != null) {
            ImageDescriptor descriptor2 = this.imageDescriptorFromPlugin(this.contributor.getName(), this.imagePath);
            this.setImageDescriptor(descriptor2);
            if (Activator.getDefault().isDebugging()) {
                System.out.println(MessageFormat.format("Set image descriptor {0} for {1} from imagePath {2}", descriptor2, this, this.imagePath));
            }
        }
        String filename = this.extension == null ? "TextGridObject" : "TextGridObject." + this.extension;
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (this.imageDescriptor == null && this.eclipseContentType != null) {
            descriptor = editorRegistry.getImageDescriptor(filename, this.getEclipseContentType());
            this.setImageDescriptor(descriptor);
            if (Activator.getDefault().isDebugging()) {
                System.out.println(MessageFormat.format("Image descriptor {0} from eclipse type {1} for content type {2}", descriptor, this.eclipseContentType, this));
            }
        }
        if (this.imageDescriptor == null && this.extension != null) {
            descriptor = editorRegistry.getImageDescriptor(filename);
            this.setImageDescriptor(descriptor);
            if (Activator.getDefault().isDebugging()) {
                System.out.println(MessageFormat.format("ImageDescriptor {0} for filename {1} for contenttype {2}", descriptor, filename, this));
            }
        }
        return this.imageDescriptor;
    }

    private Image loadImage() {
        ImageDescriptor descriptor = this.getImageDescriptor();
        if (descriptor == null) {
            return null;
        }
        Image image = descriptor.createImage(false);
        if (image == null) {
            Activator.getDefault().handleProblem(2, MessageFormat.format("Could not load the icon for content type {0} (image descriptor {1}).", this, this.imageDescriptor), null);
            return null;
        }
        Activator.getDefault().getImageRegistry().put(this.getId(), image);
        return image;
    }

    private ImageDescriptor imageDescriptorFromPlugin(String plugin, String path) {
        ImageDescriptor descriptor;
        if (plugin == null || path == null) {
            throw new IllegalArgumentException();
        }
        Bundle bundle = Platform.getBundle((String)plugin);
        URL rawURL = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        if (rawURL == null) {
            return null;
        }
        try {
            URL resolvedURL = FileLocator.resolve((URL)rawURL);
            ImageDescriptor descriptor2 = ImageDescriptor.createFromURL((URL)resolvedURL);
            if (descriptor2 != null && !descriptor2.equals(ImageDescriptor.getMissingImageDescriptor())) {
                return descriptor2;
            }
        }
        catch (IOException e) {
            Activator.handleProblem(2, e, "Could not resolve {0}, which is said to be the image {1} in {2}.", rawURL, path, plugin);
        }
        if (rawURL != null && (descriptor = ImageDescriptor.createFromURL((URL)rawURL)) != null && !descriptor.equals(ImageDescriptor.getMissingImageDescriptor())) {
            return descriptor;
        }
        return null;
    }

    public Image getImage(boolean fallback) {
        Image image = null;
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        image = registry.get(this.getId());
        if (image == null) {
            image = this.loadImage();
        }
        if (image == null && fallback) {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        return image;
    }

    protected void setImageDescriptor(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return;
        }
        this.imageDescriptor = imageDescriptor;
    }

    public TGContentType(String id, String description, String extension, String additionalTypes, boolean internal, String eclipseContentType) throws CoreException {
        if (id == null || "".equals(id)) {
            throw new CoreException(Activator.handleProblem(2, null, "Could not create content type for invalid id {0} (name would be {1}, Eclipse content type {2}).", id, description));
        }
        this.id = id;
        this.description = description;
        this.extension = extension;
        if (additionalTypes != null && !"".equals(additionalTypes)) {
            this.additionalTypes = Pattern.compile(additionalTypes);
        }
        this.internal = internal;
        this.eclipseContentType = eclipseContentType;
    }

    public TGContentType(IConfigurationElement element) throws InvalidRegistryObjectException, CoreException {
        this(element.getAttribute("typeID"), element.getAttribute("name"), element.getAttribute("extension"), element.getAttribute("additionalContentTypePattern"), "true".equals(element.getAttribute("internal")), element.getAttribute("eclipseContentType"));
        this.contributor = element.getContributor();
        this.imagePath = element.getAttribute("image");
        this.creatable = !"false".equals(element.getAttribute("creatable"));
    }

    protected static void loadContentTypes() {
        IConfigurationElement[] elements;
        registry = new LinkedHashMap<String, TGContentType>();
        publicTypes = new LinkedList<TGContentType>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = extensionRegistry.getConfigurationElementsFor("info.textgrid.lab.core.model.contentTypes");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                TGContentType newType = new TGContentType(element);
                TGContentType replaced = registry.put(newType.getId(), newType);
                if (!newType.isInternal()) {
                    publicTypes.add(newType);
                }
                if (replaced != null) {
                    Activator.handleProblem(2, null, "Replaced content type {0}, contributed by {1}, with new value {2}, contributed by {3}. Please notify the authors of the conflicting plug-ins.", replaced, replaced.getContributor(), newType, newType.getContributor());
                }
            }
            catch (CoreException e) {
                Activator.handleProblem(4, e, "Could not add a content type due to an invalid specification in the extension registry.The offending element is {0} in {1}. Please file a bug report.", element, element.getContributor().getName());
            }
            ++n2;
        }
        Activator.getDefault().getLog().log((IStatus)new Status(1, "info.textgrid.lab.core.model", TGContentType.getDebugInfo()));
    }

    public static String getDebugInfo() {
        String table = Joiner.on((String)"\n|-\n| ").join(Iterables.transform(registry.values(), (Function)new Function<TGContentType, String>(){

            public String apply(TGContentType arg0) {
                return arg0.toDebugString(" || ");
            }
        }));
        return MessageFormat.format("Loaded the following content types from the plug-in registry: \n{0}", table);
    }

    public static TGContentType getContentType(String id) {
        if (registry == null) {
            TGContentType.loadContentTypes();
        }
        return registry.get(id);
    }

    public static TGContentType findMatchingContentType(String id) {
        TGContentType contentType = TGContentType.getContentType(id);
        if (contentType != null) {
            return contentType;
        }
        for (TGContentType candidate : registry.values()) {
            Matcher matcher;
            if (candidate.getAdditionalTypes() == null || !(matcher = candidate.getAdditionalTypes().matcher(id)).matches()) continue;
            return candidate;
        }
        return TGContentType.getContentType(UNKNOWN_ID);
    }

    public static TGContentType of(String id) throws IllegalArgumentException {
        TGContentType contentType = TGContentType.findMatchingContentType(id);
        if (contentType.isUnknown() && !UNKNOWN_ID.equals(id)) {
            try {
                MimeType mimeType = new MimeType(id);
                String subType = mimeType.getSubType();
                int plusPos = subType.indexOf(43);
                String extension = plusPos >= 1 ? subType.substring(0, plusPos - 1) : subType;
                contentType = new TGContentType(id, id, extension, null, false, null);
                contentType.adHoc = true;
                contentType.creatable = false;
                registry.put(id, contentType);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.core.model");
            }
            catch (MimeTypeParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return contentType;
    }

    @Deprecated
    public static TGContentType[] getContentTypes() {
        return TGContentType.getContentTypes(false);
    }

    public static TGContentType[] getContentTypes(boolean onlyPublic) {
        if (registry == null) {
            TGContentType.loadContentTypes();
        }
        Collection<TGContentType> values = onlyPublic ? publicTypes : registry.values();
        return values.toArray(new TGContentType[0]);
    }

    public static TGContentType[] getContentTypes(Predicate<TGContentType> filter) {
        return Collections2.filter(registry.values(), filter).toArray(new TGContentType[0]);
    }

    public String toString() {
        if (this.internal) {
            return MessageFormat.format("{0} ({1}, internal)", this.description, this.id);
        }
        return MessageFormat.format("{0} ({1})", this.description, this.id);
    }

    public boolean isUnknown() {
        return UNKNOWN_ID.equals(this.id);
    }

    public static TGContentType findByExtension(String extension) {
        for (TGContentType contentType : registry.values()) {
            if (!extension.equalsIgnoreCase(contentType.getExtension())) continue;
            return contentType;
        }
        return null;
    }

    public static TGContentType getByFilename(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        TGContentType contentType = TGContentType.findByExtension(extension);
        if (contentType == null) {
            TGContentType byEclipseType;
            String mimeType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(filename);
            contentType = TGContentType.getContentType(mimeType);
            IContentType eclipseContentType = Platform.getContentTypeManager().findContentTypeFor(filename);
            if ((contentType == null || "application/octet-stream".equals(mimeType)) && (byEclipseType = TGContentType.findByEclipseType(eclipseContentType)) != null) {
                contentType = byEclipseType;
            }
            if (contentType == null) {
                String description;
                String eclipseType;
                if (eclipseContentType != null) {
                    eclipseType = eclipseContentType.getId();
                    description = eclipseContentType.getName();
                } else {
                    eclipseType = null;
                    description = NLS.bind((String)"{0} ({1})", (Object)mimeType, (Object)extension);
                }
                try {
                    contentType = new TGContentType(mimeType, description, extension, null, false, eclipseType);
                    contentType.adHoc = true;
                    contentType.creatable = false;
                    registry.put(mimeType, contentType);
                    StatusManager.getManager().handle((IStatus)new Status(1, "info.textgrid.lab.core.model", MessageFormat.format("The new ad-hoc content type {0} has been created and registered for {1}. Eclipse content type: {2}.", contentType, filename, eclipseType)));
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "info.textgrid.lab.core.model");
                }
            }
        }
        return contentType;
    }

    public static TGContentType findByEclipseType(final IContentType type) {
        if (type == null) {
            return null;
        }
        TGContentType[] candidates = TGContentType.getContentTypes(new Predicate<TGContentType>(){

            public boolean apply(TGContentType input) {
                return type.equals(input.getEclipseContentType());
            }
        });
        if (candidates.length == 0) {
            return TGContentType.findByEclipseType(type.getBaseType());
        }
        return candidates[0];
    }

    public String toDebugString(String delimiter) {
        StringBuilder s = new StringBuilder();
        s.append(this.description);
        s.append(delimiter);
        s.append(this.id);
        s.append(delimiter);
        if (this.isInternal()) {
            s.append("internal ");
        }
        if (this.isCreatable()) {
            s.append("creatable ");
        }
        if (this.isAdHoc()) {
            s.append("ad-hoc ");
        }
        if (this.isUnknown()) {
            s.append("unknown ");
        }
        s.append(delimiter);
        s.append(this.getExtension());
        s.append(delimiter);
        s.append(this.getEclipseContentTypeID());
        s.append(delimiter);
        if (this.getContributor() != null) {
            s.append(this.getContributor().getName());
        }
        return s.toString();
    }

    @Override
    public int compareTo(TGContentType contentType) {
        if (contentType.getDescription() == null && this.getDescription() == null) {
            return 0;
        }
        if (this.getDescription() == null) {
            return 1;
        }
        if (contentType.getDescription() == null) {
            return -1;
        }
        return this.getDescription().compareTo(contentType.getDescription());
    }
}

