/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import info.textgrid.lab.core.model.TextGridObject;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;

public class TGObjectReference
extends PlatformObject {
    private String refURI;
    private TextGridObject tgo;
    private static ListenerList listeners = new ListenerList();
    private TGObjectReference aggregation = null;

    public TGObjectReference(String refURI, TextGridObject tgo) {
        this.refURI = refURI;
        this.tgo = tgo;
    }

    public TGObjectReference(URI uri) {
        this.refURI = uri.toString();
        this.tgo = TextGridObject.getInstanceOffline(uri);
    }

    public String getRefUri() {
        return this.refURI;
    }

    public TextGridObject getTgo() {
        return this.tgo;
    }

    public boolean isLatestRef() {
        return !this.refURI.contains(".");
    }

    public String getRevisionNumber() {
        try {
            return this.tgo.getURI().toString().split("\\.")[1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public static void addListener(ITGObjectReferenceListener listener) {
        listeners.add((Object)listener);
    }

    public static void removeListener(ITGObjectReferenceListener listener) {
        listeners.remove((Object)listener);
    }

    public static void notifyListeners(final ITGObjectReferenceListener.Event event, final TGObjectReference tgObjectReference) {
        UIJob job = new UIJob("Notifying TextGridProject listeners"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object[] objectArray = listeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((ITGObjectReferenceListener)listener).tgObjectReferenceChanged(event, tgObjectReference);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == TextGridObject.class) {
            return this.tgo;
        }
        return super.getAdapter(adapter);
    }

    public TGObjectReference getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(TGObjectReference aggregation) {
        this.aggregation = aggregation;
    }

    public boolean isPartOfAggregation() {
        return this.aggregation != null;
    }

    public static interface ITGObjectReferenceListener {
        public void tgObjectReferenceChanged(Event var1, TGObjectReference var2);

        public static enum Event {
            NAVIGATOR_OBJECT_CREATED;

        }
    }
}

