/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.feedback.ui.bugreport;

import info.textgrid.lab.feedback.ui.Activator;
import info.textgrid.lab.feedback.ui.bugreport.BugInfoDialogArea;
import info.textgrid.lab.feedback.ui.bugreport.Messages;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class BugInfoDialog
extends TrayDialog {
    private static final int COPY_ID = -1;
    private static final int OPEN_VIEW_ID = -2;
    private static final int SAVE_LOG_ID = -3;
    private BugInfoDialogArea dialogArea;

    protected BugInfoDialog(IShellProvider parentShell) {
        super(parentShell);
        this.initialize();
    }

    public BugInfoDialog(Shell parentShell) {
        super(parentShell);
        this.initialize();
    }

    protected void initialize() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, -1, Messages.BugInfoDialog_CopyLog, false);
        this.createButton(parent, -2, Messages.BugInfoDialog_ErrorLogView, false);
        this.createButton(parent, -3, Messages.BugInfoDialog_SaveLog, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    public void saveLogAs() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setFileName("textgridlab.log");
        dialog.setText(Messages.BugInfoDialog_CopyLogTo);
        dialog.setFilterExtensions(new String[]{"*.log", "*"});
        dialog.setFilterNames(new String[]{Messages.BugInfoDialog_LogFiles, Messages.BugInfoDialog_AllFiles});
        String target = dialog.open();
        if (target != null) {
            IPath log = Platform.getLogFileLocation();
            AbstractInterruptibleChannel inChannel = null;
            AbstractInterruptibleChannel outChannel = null;
            try {
                try {
                    inChannel = new FileInputStream(log.toFile()).getChannel();
                    outChannel = new FileOutputStream(target).getChannel();
                    ((FileChannel)inChannel).transferTo(0L, ((FileChannel)inChannel).size(), (WritableByteChannel)((Object)outChannel));
                }
                catch (FileNotFoundException e) {
                    Activator.getDefault().handleProblem(4, NLS.bind((String)Messages.BugInfoDialogArea_LogHides, (Object)log), e);
                    try {
                        if (inChannel != null) {
                            inChannel.close();
                        }
                        if (outChannel != null) {
                            outChannel.close();
                        }
                    }
                    catch (IOException e2) {
                        Activator.getDefault().handleProblem(4, e2);
                    }
                }
                catch (IOException e) {
                    Activator.getDefault().handleProblem(4, NLS.bind((String)Messages.BugInfoDialog_WriteError, (Object)target), e);
                    try {
                        if (inChannel != null) {
                            inChannel.close();
                        }
                        if (outChannel != null) {
                            outChannel.close();
                        }
                    }
                    catch (IOException e3) {
                        Activator.getDefault().handleProblem(4, e3);
                    }
                }
            }
            finally {
                try {
                    if (inChannel != null) {
                        inChannel.close();
                    }
                    if (outChannel != null) {
                        outChannel.close();
                    }
                }
                catch (IOException e) {
                    Activator.getDefault().handleProblem(4, e);
                }
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogArea = new BugInfoDialogArea(parent, 0, this);
        this.dialogArea.updateLogText();
        if (this.getShell() != null) {
            this.getShell().setText(Messages.BugInfoDialog_Title);
        }
        return this.dialogArea;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 12) {
            this.close();
        } else if (buttonId == -2) {
            this.showLogView();
        } else if (buttonId == -3) {
            this.saveLogAs();
        } else if (buttonId == -1) {
            this.dialogArea.copy();
        }
    }

    public void showLogView() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
        }
        catch (PartInitException e) {
            this.getButton(-2).setEnabled(false);
            Activator.getDefault().handleProblem(2, Messages.BugInfoDialog_CannotOpenLogView, e);
        }
    }
}

