/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.locking;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.tgcrud.client.CrudClientUtilities;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.locking.LockingJob;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.AuthFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.IoFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.ObjectNotFoundFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.TGCrudService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osgi.util.NLS;

public class LockingService {
    public static final long LOCKING_DELAY = 1740000L;
    private static LockingService instance;
    private static Map<TextGridObject, LockingJob> jobRegistry;

    static {
        jobRegistry = new ConcurrentHashMap<TextGridObject, LockingJob>();
    }

    private LockingService() {
    }

    public static synchronized LockingService getInstance() {
        if (instance == null) {
            instance = new LockingService();
        }
        return instance;
    }

    public boolean lockObject(TextGridObject object, boolean message) {
        LockingJob lockingJob = jobRegistry.get(object);
        if (lockingJob != null) {
            return true;
        }
        lockingJob = new LockingJob(NLS.bind((String)"Locking object {0}", (Object)object.toString()), object, message);
        jobRegistry.put(object, lockingJob);
        try {
            lockingJob.schedule();
            lockingJob.join();
            return lockingJob.isLocked();
        }
        catch (InterruptedException e) {
            Activator.handleError(e, e.getMessage(), object);
            return false;
        }
    }

    public boolean unlockObject(TextGridObject object) {
        LockingJob lockingJob = jobRegistry.get(object);
        if (lockingJob != null) {
            this.removeJobFromRegistry(object);
            String sid = RBACSession.getInstance().getSID(false);
            TGCrudService crudServiceStub = CrudClientUtilities.getCrudServiceStub();
            try {
                return crudServiceStub.unlock(sid, "", object.getURI().toString());
            }
            catch (AuthFault e) {
                Activator.handleError(e, e.getMessage(), object);
            }
            catch (IoFault e) {
                Activator.handleError(e, e.getMessage(), object);
            }
            catch (ObjectNotFoundFault e) {
                Activator.handleError(e, e.getMessage(), object);
            }
        }
        return false;
    }

    public boolean removeJobFromRegistry(TextGridObject object) {
        LockingJob lockingJob = jobRegistry.get(object);
        if (lockingJob != null) {
            lockingJob.cancel();
            jobRegistry.remove(object);
            return true;
        }
        return false;
    }

    public boolean objectIsLocked(TextGridObject object) {
        return jobRegistry.containsKey(object);
    }

    public void removeAllJobsFromRegistry() {
        for (Map.Entry<TextGridObject, LockingJob> e : jobRegistry.entrySet()) {
            this.unlockObject((TextGridObject)e.getValue());
        }
    }
}

