/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.menus;

import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.locking.LockingPartListener;
import info.textgrid.lab.ui.core.locking.LockingService;
import info.textgrid.lab.ui.core.menus.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;

public class OpenObjectService {
    private static OpenObjectService instance;
    private static Map<String, ArrayList<IConfigurationElement>> ContentTypeMap;

    static {
        ContentTypeMap = null;
    }

    public static synchronized OpenObjectService getInstance() {
        if (instance == null) {
            instance = new OpenObjectService();
            OpenObjectService.CreateContentTypeMap();
        }
        return instance;
    }

    public boolean openObject(TextGridObject object, int mode, boolean readonly) {
        CommandSettings extensionCommand;
        String contentType;
        block12: {
            contentType = null;
            try {
                TGContentType tgContentType;
                if (!readonly && !this.userHasEditRights(object)) {
                    readonly = true;
                }
                if ((tgContentType = object.getContentType(true)) != null) {
                    contentType = tgContentType.getId();
                    break block12;
                }
                Activator.handleError(null, Messages.OpenObjectService_EM_NoEditor, object.getContentTypeID(), object);
                return false;
            }
            catch (CoreException e) {
                Activator.getDefault().handleProblem(e);
                return false;
            }
        }
        if (mode < 2 && (extensionCommand = this.findExtensionCommand(contentType)) != null && extensionCommand.hasCommand()) {
            ParameterizedCommand paramCommand = this.setCommandParameter(extensionCommand, object, readonly);
            this.callExtensionCommand(paramCommand);
            return true;
        }
        if (mode != 1) {
            LockingService lockingService = LockingService.getInstance();
            if (readonly) {
                object.setOpenAsReadOnly(true);
            } else if (!lockingService.lockObject(object, true)) {
                object.setOpenAsReadOnly(true);
            }
            IFile file = null;
            if (file == null && object != null) {
                file = (IFile)AdapterUtils.getAdapter((Object)object, IFile.class);
            }
            IEditorDescriptor editorDescriptor = this.findDefaultEditor(contentType, file);
            FileEditorInput input = new FileEditorInput(file);
            try {
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, editorDescriptor.getId());
                editorPart.getSite().getPage().addPartListener((IPartListener2)new LockingPartListener(object));
            }
            catch (PartInitException e) {
                Activator.getDefault().handleProblem(e);
                return false;
            }
            return true;
        }
        return false;
    }

    private CommandSettings findExtensionCommand(String contentType) {
        ArrayList<IConfigurationElement> extensionList = null;
        extensionList = ContentTypeMap.get(contentType);
        if (extensionList != null) {
            IConfigurationElement selectedElement = null;
            String selectedPriority = null;
            for (IConfigurationElement element : extensionList) {
                if (selectedElement != null && Integer.parseInt(element.getAttribute("priority")) <= Integer.parseInt(selectedPriority)) continue;
                selectedElement = element;
                selectedPriority = element.getAttribute("priority");
            }
            return new CommandSettings(selectedElement.getAttribute("command"), selectedElement.getAttribute("parameter_uri"), selectedElement.getAttribute("parameter_readonly"));
        }
        return null;
    }

    private void callExtensionCommand(ParameterizedCommand extensionCommand) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerService.executeCommand(extensionCommand, null);
        }
        catch (ExecutionException e) {
            Activator.getDefault().handleProblem(e);
        }
        catch (NotDefinedException e) {
            Activator.getDefault().handleProblem(e);
        }
        catch (NotEnabledException e) {
            Activator.getDefault().handleProblem(e);
        }
        catch (NotHandledException e) {
            Activator.getDefault().handleProblem(e);
        }
    }

    private ParameterizedCommand setCommandParameter(CommandSettings extensionCommand, TextGridObject object, boolean readonly) {
        ParameterizedCommand parmCommand = null;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        Command command = commandService.getCommand(extensionCommand.getCommand());
        try {
            IParameter parameter1 = command.getParameter(extensionCommand.getParameterUri());
            IParameter parameter2 = command.getParameter(extensionCommand.getParameterReadOnly());
            Parameterization parm1 = new Parameterization(parameter1, object.getURI().toString());
            Parameterization parm2 = new Parameterization(parameter2, new Boolean(readonly).toString());
            parmCommand = new ParameterizedCommand(command, new Parameterization[]{parm1, parm2});
        }
        catch (NotDefinedException e) {
            Activator.getDefault().handleProblem(e);
        }
        return parmCommand;
    }

    private IEditorDescriptor findDefaultEditor(String contentType, IFile file) {
        IEditorDescriptor editorDescriptor = null;
        IContentType eclipseContentType = null;
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        TGContentType tgContentType = TGContentType.getContentType((String)contentType);
        if (contentType != null) {
            eclipseContentType = tgContentType.getEclipseContentType();
        }
        editorDescriptor = editorRegistry.getDefaultEditor(file.getName(), eclipseContentType);
        return editorDescriptor;
    }

    private static void CreateContentTypeMap() {
        IConfigurationElement[] elements;
        ContentTypeMap = new HashMap<String, ArrayList<IConfigurationElement>>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("info.textgrid.lab.ui.core.openObject");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            IConfigurationElement element = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = children = element.getChildren();
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                if (child.getName().equals("contentType")) {
                    ArrayList<IConfigurationElement> extensionList = ContentTypeMap.containsKey(child.getAttribute("id")) ? ContentTypeMap.get(child.getAttribute("id")) : new ArrayList<IConfigurationElement>();
                    extensionList.add(element);
                    ContentTypeMap.put(child.getAttribute("id"), extensionList);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private boolean userHasEditRights(TextGridObject tgo) {
        try {
            tgo.getProjectInstance();
            return TextGridProject.checkForRole((String)tgo.getProjectInstance().getId(), (String)"Bearbeiter");
        }
        catch (CoreException e) {
            Activator.getDefault().handleProblem(e);
            return false;
        }
    }

    private class CommandSettings {
        private String command;
        private String parameter_uri;
        private String parameter_readonly;

        public CommandSettings(String command, String parameter_uri, String parameter_readonly) {
            this.command = command;
            this.parameter_uri = parameter_uri;
            this.parameter_readonly = parameter_readonly;
        }

        public String getCommand() {
            return this.command;
        }

        public String getParameterUri() {
            return this.parameter_uri;
        }

        public String getParameterReadOnly() {
            return this.parameter_readonly;
        }

        public boolean hasCommand() {
            return this.command != null;
        }

        public boolean hasParameter() {
            return this.parameter_uri != null;
        }
    }
}

