/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui;

import info.textgrid.lab.core.aggregations.ui.AggregationsUIPlugin;
import info.textgrid.lab.core.aggregations.ui.model.Aggregation;
import info.textgrid.lab.core.aggregations.ui.model.TGOentry;
import info.textgrid.lab.core.aggregations.ui.views.AggregationComposerEditor;
import info.textgrid.lab.core.aggregations.ui.views.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveItemHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        System.out.println("RemoveItemHandler");
        String message = null;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        AggregationComposerEditor acEditor = (AggregationComposerEditor)editor;
        Aggregation aggregationRoot = acEditor.getAggregationRoot();
        ISelection selection = editor.getSite().getWorkbenchWindow().getSelectionService().getSelection();
        if (((IStructuredSelection)selection).size() == 1) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof Aggregation) {
                Aggregation aggregation = (Aggregation)obj;
                message = aggregation.getChildren().length > 0 ? NLS.bind((String)Messages.AggregationComposerEditor_RemoveWithChildren, (Object)aggregation.getName()) : NLS.bind((String)Messages.AggregationComposerEditor_Remove, (Object)aggregation.getName());
            } else if (obj instanceof TGOentry) {
                TGOentry entry = (TGOentry)obj;
                try {
                    message = NLS.bind((String)Messages.AggregationComposerEditor_Remove, (Object)entry.getTitle());
                }
                catch (CoreException e) {
                    AggregationsUIPlugin.handleError(e, "Aggregation Composer Error.", new Object[0]);
                }
            }
        } else {
            message = NLS.bind((String)Messages.AggregationComposerEditor_RemoveItemWithChildren, (Object)((IStructuredSelection)selection).size());
        }
        if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Aggregation Composer", (String)message)) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof Aggregation) {
                    ((Aggregation)item).delete();
                    acEditor.setIsChanged(true);
                } else if (item instanceof TGOentry) {
                    ((TGOentry)item).delete();
                }
                ++n2;
            }
            acEditor.getViewer().refresh((Object)aggregationRoot);
            acEditor.getViewer().setSelection((ISelection)new StructuredSelection((Object)aggregationRoot), true);
        }
        return null;
    }
}

