/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.revisions.ui;

import info.textgrid.lab.core.aggregations.ui.AggregationsUIPlugin;
import info.textgrid.lab.core.metadataeditor.MetaDataSection;
import info.textgrid.lab.core.metadataeditor.ScrolledPageArea;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.revisions.ui.Messages;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.statushandlers.StatusManager;

public class SaveAsRevisionDialog
extends TitleAreaDialog {
    private MetaDataSection metaDataSection;
    private ProgressMonitorPart progressMonitorPart;
    protected IEditorPart editor;
    private TextGridObject newRevision;
    private TextGridObject currentRevision;

    protected Control createDialogArea(final Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.SaveAsRevisionDialog_SaveAsNewRevision);
        this.getShell().setText(Messages.SaveAsRevisionDialog_SaveAs);
        this.setMessage(Messages.SaveAsRevisionDialog_IM_SaveNewRevision);
        ScrolledPageArea scrolledPageArea = new ScrolledPageArea(area);
        Composite composite = scrolledPageArea.getPageAreaComposite();
        ScrolledForm scrolledForm = scrolledPageArea.getPageAreaScrolledForm();
        GridDataFactory.fillDefaults().grab(true, true).hint(600, 400).applyTo((Control)composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scrolledForm);
        Group metadataGroup = new Group(composite, 16);
        metadataGroup.setLayout((Layout)new GridLayout(1, false));
        metadataGroup.setText(Messages.SaveAsRevisionDialog_Metadata);
        this.metaDataSection = new MetaDataSection((Composite)metadataGroup, scrolledForm, null);
        this.metaDataSection.checkAllFields();
        this.progressMonitorPart = new ProgressMonitorPart(area, null){
            private ControlEnableState controlEnableState;
            {
                super($anonymous0, $anonymous1);
                this.controlEnableState = null;
            }

            public void beginTask(String name, int totalWork) {
                super.beginTask(name, totalWork);
                if (this.controlEnableState == null) {
                    this.controlEnableState = ControlEnableState.disable((Control)parent);
                }
            }

            public void done() {
                super.done();
                if (this.controlEnableState != null) {
                    this.controlEnableState.restore();
                    this.controlEnableState = null;
                }
            }
        };
        this.progressMonitorPart.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 1024).create());
        this.progressMonitorPart.setVisible(false);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getButton(0).setText(Messages.SaveAsRevisionDialog_Save);
        this.progressMonitorPart.attachToCancelComponent((Control)this.getButton(1));
        return contents;
    }

    public SaveAsRevisionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected IStatus run(IRunnableWithProgress runnable, boolean fork) {
        block8: {
            try {
                if (this.progressMonitorPart != null && !this.progressMonitorPart.isDisposed()) {
                    this.progressMonitorPart.setVisible(true);
                    try {
                        ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.progressMonitorPart, (Display)this.getShell().getDisplay());
                        break block8;
                    }
                    finally {
                        this.progressMonitorPart.done();
                        this.progressMonitorPart.setVisible(false);
                    }
                }
                PlatformUI.getWorkbench().getProgressService().run(fork, true, runnable);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    CoreException c = (CoreException)e.getCause();
                    return new MultiStatus(c.getStatus().getPlugin(), 0, new IStatus[]{c.getStatus()}, c.getMessage(), (Throwable)c);
                }
                return new Status(4, "info.textgrid.lab.core.aggregations.ui", e.getCause().getLocalizedMessage(), (Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    public void associateWithEditor(final IEditorPart editor) {
        IStatus status = this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
                if (editor != null) {
                    SaveAsRevisionDialog.this.editor = editor;
                    IEditorInput editorInput = editor.getEditorInput();
                    SaveAsRevisionDialog.this.currentRevision = (TextGridObject)AdapterUtils.getAdapter((Object)editorInput, TextGridObject.class);
                    progress.worked(1);
                    if (SaveAsRevisionDialog.this.currentRevision == null) {
                        throw new InvocationTargetException(new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.aggregations.ui", NLS.bind((String)Messages.SaveAsRevisionDialog_EM_NoTextGridObject, (Object)editorInput))));
                    }
                    progress.setTaskName(NLS.bind((String)Messages.SaveAsRevisionDialog_PreparingNewRevisionOf, (Object)SaveAsRevisionDialog.this.currentRevision));
                    SaveAsRevisionDialog.this.newRevision = SaveAsRevisionDialog.this.currentRevision.prepareNewRevision((IProgressMonitor)progress.newChild(5));
                    AdapterUtils.getAdapter((Object)SaveAsRevisionDialog.this.newRevision, IFile.class);
                    progress.worked(1);
                    if (SaveAsRevisionDialog.this.metaDataSection != null) {
                        SaveAsRevisionDialog.this.metaDataSection.setNewTGObject(SaveAsRevisionDialog.this.newRevision, true);
                    }
                    progress.worked(4);
                }
                progress.done();
            }
        }, false);
        if (!status.isOK()) {
            StatusManager.getManager().handle(status);
        }
    }

    private static void log(String message, Object ... arguments) {
        StatusManager.getManager().handle((IStatus)new Status(1, "info.textgrid.lab.core.aggregations.ui", MessageFormat.format(message, arguments)));
    }

    public void okPressed() {
        this.metaDataSection.updateTextGridObject();
        try {
            this.newRevision.setProject(this.currentRevision.getProjectInstance());
        }
        catch (IllegalStateException e) {
            AggregationsUIPlugin.handleError(e, NLS.bind((String)Messages.SaveAsRevisionDialog_EM_RetvievingProject, (Object)this.currentRevision.toString()), new Object[0]);
        }
        catch (CoreException e) {
            AggregationsUIPlugin.handleError(e, NLS.bind((String)Messages.SaveAsRevisionDialog_EM_RetvievingProject, (Object)this.currentRevision.toString()), new Object[0]);
        }
        IStatus result = this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.SaveAsRevisionDialog_Saving, (Object)SaveAsRevisionDialog.this.newRevision), (int)10);
                if (SaveAsRevisionDialog.this.editor != null) {
                    progress.worked(1);
                    if (SaveAsRevisionDialog.this.editor.isDirty()) {
                        SaveAsRevisionDialog.this.editor.doSave((IProgressMonitor)progress.newChild(6));
                    } else {
                        try {
                            IFile currentFile = (IFile)AdapterUtils.getAdapter((Object)SaveAsRevisionDialog.this.currentRevision, IFile.class);
                            currentFile.setContents(currentFile.getContents(), true, false, (IProgressMonitor)progress.newChild(6));
                        }
                        catch (CoreException e1) {
                            e1.printStackTrace();
                        }
                    }
                    SaveAsRevisionDialog.log(Messages.SaveAsRevisionDialog_Saved, new Object[]{SaveAsRevisionDialog.this.newRevision});
                    IEditorInput newInput = null;
                    progress.worked(1);
                    if (SaveAsRevisionDialog.this.editor instanceof IReusableEditor) {
                        IReusableEditor reusableEditor = (IReusableEditor)SaveAsRevisionDialog.this.editor;
                        newInput = (IEditorInput)AdapterUtils.getAdapter((Object)SaveAsRevisionDialog.this.newRevision, IEditorInput.class);
                        reusableEditor.setInput(newInput);
                        SaveAsRevisionDialog.log("Set resusable editor {0} to open new input {1}", new Object[]{SaveAsRevisionDialog.this.editor, newInput});
                    } else {
                        IWorkbenchPage page = SaveAsRevisionDialog.this.editor.getEditorSite().getPage();
                        page.closeEditor(SaveAsRevisionDialog.this.editor, false);
                        try {
                            newInput = (IEditorInput)AdapterUtils.getAdapter((Object)SaveAsRevisionDialog.this.newRevision, IEditorInput.class);
                            page.openEditor(newInput, SaveAsRevisionDialog.this.editor.getSite().getId());
                            SaveAsRevisionDialog.log("Set resusable editor {0} to open new input {1}", new Object[]{SaveAsRevisionDialog.this.editor, newInput});
                        }
                        catch (PartInitException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
            }
        }, false);
        if (result.isOK()) {
            super.okPressed();
        } else {
            StatusManager.getManager().handle(result, 3);
        }
    }
}

