/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.versions.ui;

import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.versions.ui.Messages;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import java.util.EnumSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class VersionView
extends ViewPart {
    private TextGridObjectTableViewer viewer;
    private TextGridObject tgo;
    private Composite composite;
    private Label tgoLabel;

    public void createPartControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridData gdc = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)gdc);
        GridLayout glp = new GridLayout(1, false);
        this.composite.setLayout((Layout)glp);
        this.tgoLabel = new Label(this.composite, 16384);
        this.viewer = new TextGridObjectTableViewer(this.composite, 772);
        this.viewer.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.TITLE, TextGridObjectTableViewer.Column.PROJECT, TextGridObjectTableViewer.Column.DATE, TextGridObjectTableViewer.Column.OWNER));
        this.viewer.getTable().setHeaderVisible(true);
        GridData gd1 = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gd1);
        this.viewer.setSorter(new ViewerSorter());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu((TableViewer)this.viewer);
    }

    public void refreshViewer(final TextGridObject tgo) {
        this.setTgo(tgo);
        try {
            this.tgoLabel.setText(NLS.bind((String)Messages.VersionView_VersionsOfInProject, (Object)this.getTgo().getTitle(), (Object)this.getTgo().getProjectInstance().getName()));
        }
        catch (CoreException e) {
            Activator.handleError((Throwable)e);
        }
        this.composite.layout();
        final SearchRequest searchRequest = new SearchRequest();
        UIJob job = new UIJob(Messages.VersionView_RetrieveVersions){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                    progress.beginTask(NLS.bind((String)Messages.VersionView_QueryingForChildren, (Object)tgo.getTitle()), 100);
                    searchRequest.setQueryRelated("isDerivedFrom", VersionView.this.getTgo().getURI().toString());
                    VersionView.this.viewer.setInput((Object)searchRequest);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    Activator.handleError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void hookContextMenu(TableViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public TextGridObject getTgo() {
        return this.tgo;
    }

    public void setTgo(TextGridObject tgo) {
        this.tgo = tgo;
    }
}

