/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.conf;

import info.textgrid.lab.conf.ConfPlugin;
import java.net.NoRouteToHostException;
import java.text.MessageFormat;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.progress.UIJob;

public class OnlineStatus {
    private static boolean online = true;
    private static ListenerList onlineStatusChangeListeners = new ListenerList();
    private static IStatusLineManager statusLineManager = new StatusLineManager();
    private static String OFFLINE_COMMAND;

    public static void addOnlineStatusChangeListener(IStatusChangeListener listener) {
        onlineStatusChangeListeners.add((Object)listener);
    }

    public static void removeOnlineStatusChangeListener(IStatusChangeListener listener) {
        onlineStatusChangeListeners.remove((Object)listener);
    }

    protected static void notifyOnlineStatusChangeListeners(boolean newStatus) {
        Object[] objectArray = onlineStatusChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IStatusChangeListener)listener).statusChanged(newStatus);
            ++n2;
        }
    }

    public static boolean isOnline() {
        return online;
    }

    public static boolean isOnlineWithNotification(String message) {
        if (online) {
            return true;
        }
        OnlineStatus.showUnobstrusiveOnlineErrorMessage(message, null);
        return false;
    }

    public static void setOnline() {
        OnlineStatus.setOnline(true);
    }

    public static void setOnline(boolean newOnlineState) {
        boolean oldOnline = online;
        online = newOnlineState;
        if (oldOnline != newOnlineState) {
            final ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            OFFLINE_COMMAND = "info.textgrid.lab.conf.toggleoffline";
            Command offlineCommand = commandService.getCommand(OFFLINE_COMMAND);
            State state = offlineCommand.getState("STYLE");
            state.setValue((Object)(!online ? 1 : 0));
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    commandService.refreshElements(OFFLINE_COMMAND, null);
                }
            });
            OnlineStatus.notifyOnlineStatusChangeListeners(online);
        }
    }

    public static void setOffline() {
        OnlineStatus.setOnline(false);
    }

    public static boolean isOfflineException(Exception e) {
        if (e.getMessage().toLowerCase().startsWith("no route to host")) {
            return true;
        }
        return e instanceof NoRouteToHostException || e.getCause() != null && e.getCause() instanceof NoRouteToHostException;
    }

    public static void netAccessFailed(String message, Throwable cause) {
        ConfPlugin.log(4, cause, "network access failed ({0})", message);
        if (OnlineStatus.isOnline()) {
            OnlineStatus.setOffline();
            OnlineStatus.showOfflineErrorDialog(message, cause);
        } else {
            OnlineStatus.showUnobstrusiveOnlineErrorMessage(message, cause);
        }
    }

    protected static void showUnobstrusiveOnlineErrorMessage(final String message, final Throwable cause) {
        new UIJob("Showing unobtrusive online error message"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                statusLineManager.setErrorMessage(MessageFormat.format("{0} (system is offline)", message));
                ConfPlugin.log(1, cause, "Offline notification: {0}", message);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected static void showOfflineErrorDialog(final String message, final Throwable cause) {
        new UIJob("Display offline error dialog"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                Status status = new Status(4, "info.textgrid.lab.conf", MessageFormat.format("Network access failed: {0}.\nReason: {1}", message, cause));
                String dialogMessage = MessageFormat.format("{0}\n\nNetwork access is not possible.\nWhen you have re-established a network connection, please uncheck \"Hide network warnings\" in the File menu and try again.", message);
                ErrorDialog errorDialog = new ErrorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Network access failed", dialogMessage, (IStatus)status, 0xFFFFFFF);
                errorDialog.setBlockOnOpen(false);
                if (!monitor.isCanceled()) {
                    errorDialog.open();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public static void setStatusLineManager(IStatusLineManager statusLineManager) {
        OnlineStatus.statusLineManager = statusLineManager;
    }

    public static interface IStatusChangeListener {
        public void statusChanged(boolean var1);
    }
}

