/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.codegen.SourceGenerator;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.model.wadl.WadlGenerator;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGeneratorProvider
implements RequestHandler {
    public static final String CODE_QUERY = "_code";
    public static final String LANGUAGE_QUERY = "_lang";
    public static final String OS_QUERY = "_os";
    public static final String SOURCE_QUERY = "_source";
    public static final String CODE_TYPE_QUERY = "_codeType";
    private static final Logger LOG = LogUtils.getL7dLogger(CodeGeneratorProvider.class);
    private static final Set<String> SUPPORTED_LANGUAGES = new HashSet<String>(Arrays.asList("java"));
    private static final File TMPDIR = FileUtils.getDefaultTempDir();
    private Comparator<String> importsComparator;
    private UriInfo ui;
    private String resourcePackageName;
    private String resourceName;
    private boolean generateInterfaces = true;
    private Bus bus;

    @Context
    public void setUriInfo(UriInfo uriInfo) {
        this.ui = uriInfo;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        if (!"GET".equals(m.get("org.apache.cxf.request.method"))) {
            return null;
        }
        if (this.ui.getQueryParameters().containsKey((Object)SOURCE_QUERY)) {
            CodeGeneratorProvider codeGeneratorProvider = this;
            synchronized (codeGeneratorProvider) {
                return this.getSource(new File(TMPDIR, this.getStem(resourceClass, "zip")));
            }
        }
        String codeQuery = (String)this.ui.getQueryParameters().getFirst((Object)CODE_QUERY);
        if (codeQuery == null) {
            return null;
        }
        String language = (String)this.ui.getQueryParameters().getFirst((Object)LANGUAGE_QUERY);
        if (language != null && !SUPPORTED_LANGUAGES.contains(language)) {
            return Response.noContent().entity((Object)("Unsupported language" + language)).type("text/plain").build();
        }
        return this.doHandleRequest(m, resourceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Response doHandleRequest(Message m, ClassResourceInfo resourceClass) {
        CodeGeneratorProvider codeGeneratorProvider = this;
        synchronized (codeGeneratorProvider) {
            File zipDir = new File(TMPDIR, this.getStem(resourceClass, "zip"));
            Response r = this.getLink(zipDir, m);
            if (r != null) {
                return r;
            }
            File srcDir = new File(TMPDIR, this.getStem(resourceClass, "src"));
            if (!srcDir.exists() && !srcDir.mkdir()) {
                throw new IllegalStateException("Unable to create working directory " + srcDir.getPath());
            }
            String codeType = (String)this.ui.getQueryParameters().getFirst((Object)CODE_TYPE_QUERY);
            try {
                String wadl = this.getWadl(m, resourceClass);
                if (wadl == null) {
                    LOG.warning("WADL for " + (resourceClass != null ? resourceClass.getServiceClass().getName() : "this service") + " can not be loaded");
                    Response response = Response.noContent().build();
                    return response;
                }
                Map<String, String> properties = this.getProperties();
                SourceGenerator sg = new SourceGenerator(properties);
                sg.setGenerateInterfaces(this.generateInterfaces);
                sg.setImportsComparator(this.importsComparator);
                sg.setResourceName(this.resourceName);
                sg.setPackageName(this.resourcePackageName);
                sg.setBus(this.bus);
                sg.generateSource(wadl, srcDir, codeType);
                this.zipSource(srcDir, zipDir);
                Response response = this.getLink(zipDir, m);
                return response;
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Code can not be generated for " + (resourceClass != null ? resourceClass.getServiceClass().getName() : "this service"), ex);
                FileUtils.removeDir(zipDir);
                Response response2 = Response.noContent().build();
                return response2;
            }
            finally {
                FileUtils.removeDir(srcDir);
            }
        }
    }

    private Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("line.separator", this.getLineSep());
        map.put("file.separator", this.getFileSep());
        return map;
    }

    private void zipSource(File srcDir, File zipDir) throws Exception {
        if (!zipDir.exists()) {
            zipDir.mkdir();
        }
        File zipFile = new File(zipDir.getAbsolutePath(), "src.zip");
        zipFile.createNewFile();
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        List<File> srcFiles = FileUtils.getFilesRecurse(srcDir, ".+\\.java$");
        for (File f : srcFiles) {
            String entryName = f.getAbsolutePath().substring(srcDir.getAbsolutePath().length() + 1);
            zos.putNextEntry(new ZipEntry(entryName));
            IOUtils.copy(new FileInputStream(f), zos);
        }
        zos.close();
    }

    private String getLineSep() {
        String os = (String)this.ui.getQueryParameters().getFirst((Object)OS_QUERY);
        if (os == null) {
            return SystemPropertyAction.getProperty("line.separator");
        }
        return "unix".equals(os) ? "\r" : "\r\n";
    }

    private String getFileSep() {
        String os = (String)this.ui.getQueryParameters().getFirst((Object)OS_QUERY);
        if (os == null) {
            return SystemPropertyAction.getProperty("file.separator");
        }
        return "unix".equals(os) ? "/" : "\\";
    }

    private Response getSource(File zipDir) {
        File zipFile;
        if (zipDir.exists() && (zipFile = new File(zipDir.getAbsolutePath(), "src.zip")).exists()) {
            try {
                return Response.ok().type("application/zip").entity((Object)new FileInputStream(zipFile)).build();
            }
            catch (FileNotFoundException ex) {
                throw new WebApplicationException();
            }
        }
        return Response.noContent().build();
    }

    private Response getLink(File zipDir, Message m) {
        if (zipDir.exists() && new File(zipDir.getAbsolutePath(), "src.zip").exists()) {
            UriBuilder builder = this.ui.getAbsolutePathBuilder();
            String link = builder.queryParam(SOURCE_QUERY, new Object[0]).build(new Object[0]).toString();
            StringBuilder sb = new StringBuilder();
            sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
            sb.append("<head><title>Download the source</title></head>");
            sb.append("<body>");
            sb.append("<h1>Link:</h1><br/>");
            sb.append("<ul><a href=\"" + link + "\">" + link + "</a>" + "</ul>");
            sb.append("</body>");
            sb.append("</html>");
            m.getExchange().put("ignore.message.writers", true);
            return Response.ok().type("application/xhtml+xml").entity((Object)sb.toString()).build();
        }
        return null;
    }

    public void removeCode(ClassResourceInfo cri) {
        CodeGeneratorProvider.removeCode(new File(TMPDIR, this.getStem(cri, "src")));
        CodeGeneratorProvider.removeCode(new File(TMPDIR, this.getStem(cri, "zip")));
    }

    protected String getStem(ClassResourceInfo cri, String suffix) {
        if (cri == null) {
            return "cxf-jaxrs-" + suffix;
        }
        return "cxf-jaxrs-" + cri.getServiceClass().getName() + "-" + suffix;
    }

    private static void removeCode(File src) {
        if (src.exists()) {
            FileUtils.removeDir(src);
        }
    }

    protected String getWadl(Message m, ClassResourceInfo resourceClass) {
        m.put(Message.QUERY_STRING, "_wadl");
        List<ProviderInfo<RequestHandler>> shs = ProviderFactory.getInstance(m).getRequestHandlers();
        if (shs.size() > 0 && shs.get(0).getProvider() instanceof WadlGenerator) {
            WadlGenerator wg = (WadlGenerator)shs.get(0).getProvider();
            wg = new WadlGenerator(wg);
            wg.setAddResourceAndMethodIds(true);
            Response r = wg.handleRequest(m, resourceClass);
            return r == null ? null : (String)r.getEntity();
        }
        return null;
    }

    public void setImportsComparator(Comparator<String> importsComparator) {
        this.importsComparator = importsComparator;
    }

    public void setGenerateInterfaces(boolean generateInterfaces) {
        this.generateInterfaces = generateInterfaces;
    }

    public void setPackageName(String name) {
        this.resourcePackageName = name;
    }

    public void setResourceName(String name) {
        this.resourceName = name;
    }
}

