/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.authn;

import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.authn.Messages;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class AuthNDialog
extends TrayDialog {
    AuthBrowser browserComp;
    AuthNDialog thisDialog;
    Button neverAsk;
    AuthBrowser.ISIDChangedListener sidChangedListener;

    protected AuthNDialog(IShellProvider parentShell) {
        super(parentShell);
        this.initialize();
    }

    public AuthNDialog(Shell parentShell) {
        super(parentShell);
        this.initialize();
    }

    protected void initialize() {
        this.thisDialog = this;
        this.sidChangedListener = new AuthBrowser.ISIDChangedListener(){

            @Override
            public void sidChanged(String newSID, String newEPPN) {
                if (!RBACSession.getInstance().getSID(false).equals("")) {
                    new UIJob(Messages.AuthNDialog_ClosingDialog){

                        public IStatus runInUIThread(IProgressMonitor m) {
                            (this).AuthNDialog.this.thisDialog.destroy();
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        };
        AuthBrowser.addSIDChangedListener(this.sidChangedListener);
    }

    protected void initialize(Composite parent) {
    }

    protected void destroy() {
        AuthBrowser.removeSIDChangedListener(this.sidChangedListener);
        this.thisDialog.close();
        RBACSession.authDialogIsOpen(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
        this.createButton(parent, 127, Messages.AuthNDialog_PasswordResetBtn, false);
        this.neverAsk = new Button(parent, 32);
        this.neverAsk.setText(Messages.AuthNDialog_NeverAskCheckbox);
        this.createButton(parent, 123, Messages.AuthNDialog_BackBtn, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        boolean success;
        super.buttonPressed(buttonId);
        if (buttonId == 12) {
            if (this.neverAsk.getSelection()) {
                RBACSession.neverAsk(true);
            }
            this.destroy();
        }
        if (buttonId == 123 && !(success = this.browserComp.getAuthBrowser().back())) {
            this.browserComp.resetAuthBrowser();
        }
        if (buttonId == 127) {
            URL pwrurl = null;
            try {
                ConfClient confClient = ConfClient.getInstance();
                String pwrurlString = confClient.getValue("PasswordReset");
                pwrurl = URI.create(pwrurlString).toURL();
                PlatformUI.getWorkbench().getBrowserSupport().createBrowser(128, "xyz123abc456", "Hallo", "egal").openURL(pwrurl);
                MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 34);
                mb.setText(Messages.AuthNDialog_ResettingPassword);
                mb.setMessage(Messages.AuthNDialog_ResetMessage);
                mb.open();
            }
            catch (OfflineException e) {
                OnlineStatus.netAccessFailed((String)Messages.AuthNDialog_CouldNotContactConfserv, (Throwable)e);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.browserComp = new AuthBrowser(parent);
        this.getShell().setText(Messages.AuthNDialog_WayfMessage);
        return this.browserComp;
    }
}

