/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.utilities.workspacecleaner;

import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class WorkspaceCleanerBundle
implements BundleActivator {
    private static BundleContext context;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        System.out.println("Cleaner bundle started");
        this.cleanWorkspace();
    }

    private void cleanWorkspace() {
        IPath workspacePath = InternalPlatform.getDefault().getMetaArea().getInstanceDataLocation();
        System.out.println("The workspace is here: " + workspacePath);
        File workspace = workspacePath.toFile();
        if (workspace.exists() && workspace.isDirectory()) {
            File[] projectDirs;
            File[] fileArray = projectDirs = workspace.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !pathname.getName().startsWith(".");
                }
            });
            int n = projectDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File[] files;
                File projectDir = fileArray[n2];
                File projectFile = null;
                boolean doNotTouch = false;
                File[] fileArray2 = files = projectDir.listFiles();
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray2[n4];
                    if (!file.getName().equals(".project")) {
                        doNotTouch = true;
                        System.err.println(MessageFormat.format("{0} blocks deletion of {1}", file, projectDir));
                        break;
                    }
                    projectFile = file;
                    ++n4;
                }
                if (!doNotTouch) {
                    boolean success;
                    if (projectFile != null) {
                        projectFile.delete();
                    }
                    if (success = projectDir.delete()) {
                        System.out.println(MessageFormat.format("Successfully deleted {0}", projectDir));
                    } else {
                        System.err.println(MessageFormat.format("Could not delete {0}", projectDir));
                    }
                }
                ++n2;
            }
            File resourcesPluginDir = new File(workspace, "/.metadata/.plugins/org.eclipse.core.resources");
            if (resourcesPluginDir.exists() && resourcesPluginDir.isDirectory()) {
                WorkspaceCleanerBundle.deleteRecursively(resourcesPluginDir);
            }
        }
    }

    private static void deleteRecursively(File dir) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                WorkspaceCleanerBundle.deleteRecursively(file);
            }
            file.delete();
            ++n2;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }
}

