/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator.filters;

import info.textgrid.lab.navigator.filters.Messages;
import java.util.ArrayList;

public class ProjectFilterData {
    private String name;
    private String role;
    private ArrayList<ProjectFilterData> children = new ArrayList();
    private static ProjectFilterData instance = new ProjectFilterData("Root", null);

    private ProjectFilterData(String name, String role) {
        this.name = name;
        this.role = role;
    }

    public static ProjectFilterData getInstance() {
        if (!instance.isParent()) {
            ProjectFilterData.init();
        }
        return instance;
    }

    private static void init() {
        ProjectFilterData p2 = new ProjectFilterData(Messages.ProjectFilterData_ProjectRoles, null);
        ProjectFilterData.instance.children.add(p2);
        ProjectFilterData c1 = new ProjectFilterData(Messages.ProjectFilterData_AuthorityToDeleteRole, "Administrator");
        ProjectFilterData c2 = new ProjectFilterData(Messages.ProjectFilterData_EditorRole, "Bearbeiter");
        ProjectFilterData c3 = new ProjectFilterData(Messages.ProjectFilterData_ObserverRole, "Beobachter");
        ProjectFilterData c4 = new ProjectFilterData(Messages.ProjectFilterData_ProjectManagerRole, "Projektleiter");
        p2.children.add(c1);
        p2.children.add(c2);
        p2.children.add(c3);
        p2.children.add(c4);
    }

    public String toString() {
        return this.name;
    }

    public ProjectFilterData[] getChildren() {
        return this.children.toArray(new ProjectFilterData[0]);
    }

    public boolean isParent() {
        return !this.children.isEmpty();
    }

    public String getRole() {
        return this.role;
    }

    public static ProjectFilterData getItem(String role) {
        ProjectFilterData[] projectFilterDataArray = instance.getChildren()[0].getChildren();
        int n = projectFilterDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectFilterData item = projectFilterDataArray[n2];
            if (item.role.equals(role)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public static int getChildCount() {
        return instance.getChildren()[0].getChildren().length + 1;
    }
}

