/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.templateeditor.utils;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class AdvancedControlElement {
    private Control control = null;
    private String id = null;
    private String name = null;
    private String ref = null;
    private String refId = null;
    private int readOnlyFlag = 0;
    private OMElement element = null;
    private String inputType = "string";
    private boolean required = false;
    private Label label = null;

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public AdvancedControlElement(Control control, String id, String name, String ref, int readOnlyFlag) {
        this.control = control;
        this.id = this.refId = id;
        this.name = name;
        this.ref = ref;
        this.readOnlyFlag = readOnlyFlag;
        if (this.name == null) {
            this.name = id;
        }
    }

    public String getId() {
        return this.id;
    }

    void setRefId(String refId) {
        this.refId = refId;
    }

    public String getRefId() {
        return this.refId;
    }

    public String getName() {
        return this.name;
    }

    public String getRef() {
        return this.ref;
    }

    public Control getControl() {
        return this.control;
    }

    public OMElement getOMElement() {
        return this.element;
    }

    public int getReadOnlyFlag() {
        return this.readOnlyFlag;
    }

    void createOMElement(OMFactory omFactory, OMElement parent, OMNamespace ns, boolean asAttribute) {
        if (!asAttribute) {
            this.createOMElementControl(omFactory, parent, ns);
        } else {
            this.createOMElementControlAsAttribute(omFactory, parent);
        }
    }

    private void createOMElementControl(OMFactory omFactory, OMElement parent, OMNamespace ns) {
        String value = "";
        if (this.control instanceof Text) {
            Text t = (Text)this.control;
            value = t.getText();
        } else if (this.control instanceof Combo) {
            Combo c = (Combo)this.control;
            value = c.getText();
        } else if (this.control instanceof List) {
            List l = (List)this.control;
            if (l.getSelectionIndex() > -1) {
                value = l.getItem(l.getSelectionIndex());
            }
        } else {
            return;
        }
        this.element = omFactory.createOMElement(this.name, ns);
        this.element.setText(value);
        parent.addChild((OMNode)this.element);
    }

    void clearContent() {
        if (this.control instanceof Text) {
            ((Text)this.control).setText("");
        } else if (this.control instanceof Combo) {
            ((Combo)this.control).select(0);
        } else if (this.control instanceof List) {
            ((List)this.control).select(0);
        } else {
            return;
        }
    }

    private void createOMElementControlAsAttribute(OMFactory omFactory, OMElement parent) {
        List l;
        String value = "";
        if (this.control instanceof Text) {
            Text t = (Text)this.control;
            value = t.getText();
        } else if (this.control instanceof Combo) {
            Combo c = (Combo)this.control;
            value = c.getText();
        } else if (this.control instanceof List && (l = (List)this.control).getSelectionIndex() > -1) {
            value = l.getItem(l.getSelectionIndex());
        }
        parent.addAttribute(omFactory.createOMAttribute(this.name, null, value));
    }

    public void dispose() {
        if (this.control != null) {
            this.control.dispose();
        }
    }
}

