/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.templateeditor.utils;

import info.textgrid.lab.templateeditor.utils.AdvancedControlElement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class RepeatItemsGroup {
    private LinkedList<AdvancedControlElement> advancedControls = new LinkedList();
    private Map<String, Control> elements = new HashMap<String, Control>();
    private Button remove_btn = null;

    public void addAdvancedControl(AdvancedControlElement e) {
        this.advancedControls.addLast(e);
        this.elements.put(e.getId(), e.getControl());
    }

    public void addRemoveButton(Button b) {
        this.remove_btn = b;
    }

    public LinkedList<Control> getControls() {
        LinkedList<Control> l = new LinkedList<Control>();
        for (AdvancedControlElement e : this.advancedControls) {
            l.add(e.getControl());
        }
        return l;
    }

    void clearControls() {
        for (AdvancedControlElement e : this.advancedControls) {
            e.clearContent();
        }
    }

    public LinkedList<AdvancedControlElement> getAdvancedControls() {
        return this.advancedControls;
    }

    public Map<String, Control> getItems() {
        return this.elements;
    }

    public Control getControlById(String id) {
        return this.elements.get(id);
    }

    String getIdByRefId(String refId) {
        for (AdvancedControlElement e : this.advancedControls) {
            if (!e.getRefId().equals(refId)) continue;
            return e.getId();
        }
        return refId;
    }

    private AdvancedControlElement getAdvancedControlElementById(String id) {
        for (AdvancedControlElement e : this.advancedControls) {
            if (!e.getId().equals(id)) continue;
            return e;
        }
        return null;
    }

    void createOMElements(OMFactory omFactory, OMElement parent, OMNamespace ns) {
        for (AdvancedControlElement e : this.advancedControls) {
            if (e.getRef() != null) {
                AdvancedControlElement ac = this.getAdvancedControlElementById(e.getRef());
                if (ac == null) continue;
                e.createOMElement(omFactory, ac.getOMElement(), ns, true);
                continue;
            }
            e.createOMElement(omFactory, parent, ns, false);
        }
    }

    public void dispose() {
        while (!this.advancedControls.isEmpty()) {
            AdvancedControlElement e = this.advancedControls.getLast();
            e.dispose();
            this.advancedControls.removeLast();
        }
        this.remove_btn.dispose();
        this.elements.clear();
    }
}

