/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.templateeditor.xsdcreator;

import java.util.Arrays;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

public class XSDElement {
    private String name;
    private String type;
    private String min;
    private String max;
    public static String[] xsd_types = new String[]{"string", "date", "integer", "boolean", "time", "decimal"};

    public XSDElement(String name, String type, String min, String max) {
        this.name = name;
        this.type = type;
        this.min = min;
        this.max = max;
        Arrays.sort(xsd_types);
    }

    OMElement createXSDElement(OMFactory omfactory, OMNamespace ns) {
        OMAttribute name = omfactory.createOMAttribute("name", null, this.name);
        String pref = "";
        if (Arrays.binarySearch(xsd_types, this.type) > -1) {
            pref = String.valueOf(ns.getPrefix()) + ":";
        }
        OMAttribute type = omfactory.createOMAttribute("type", null, String.valueOf(pref) + this.type);
        OMAttribute min = omfactory.createOMAttribute("minOccurs", null, this.min);
        OMAttribute max = omfactory.createOMAttribute("maxOccurs", null, this.max);
        OMElement e = omfactory.createOMElement("element", ns);
        e.addAttribute(name);
        e.addAttribute(type);
        e.addAttribute(min);
        e.addAttribute(max);
        return e;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getMin() {
        return this.min;
    }

    public String getMax() {
        return this.max;
    }
}

