/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.dialogs;

import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.ui.core.dialogs.INewObjectPreparator;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizard;
import info.textgrid.lab.ui.core.dialogs.NewObjectWizard;
import info.textgrid.lab.xmleditor.dialogs.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;

public class NewXMLObjectPreparator
implements INewObjectPreparator {
    private ITextGridWizard wizard;
    private String grammarURI;
    private ICatalogEntry xmlCatalogEntry;
    private TextGridObject grammarObject;

    public void initializeObject(TextGridObject textGridObject) {
    }

    public boolean performFinish(TextGridObject textGridObject) {
        if (this.wizard instanceof NewObjectWizard) {
            return ((NewObjectWizard)this.wizard).defaultPerformFinish();
        }
        return false;
    }

    public void setWizard(ITextGridWizard wizard) {
        this.wizard = wizard;
    }

    public String getGrammarURI() {
        return this.grammarURI;
    }

    public void setGrammarURI(String uri) {
        this.grammarURI = uri;
    }

    public ICatalogEntry getXMLCatalogEntry() {
        return this.xmlCatalogEntry;
    }

    public void setXMLCatalogEntry(ICatalogEntry xmlCatalogEntry) {
        this.xmlCatalogEntry = xmlCatalogEntry;
        if (xmlCatalogEntry != null) {
            this.grammarObject = null;
        }
    }

    public void setGrammarObject(TextGridObject schemaObject) {
        this.grammarObject = schemaObject;
        try {
            this.wizard.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.NewXMLObjectPreparator_FetchingSchema, (Object)NewXMLObjectPreparator.this.grammarObject), (int)100);
                    try {
                        File localFile = NewXMLObjectPreparator.this.grammarObject.toLocalFile((IProgressMonitor)progress.newChild(100, 4), true);
                        if (localFile != null) {
                            NewXMLObjectPreparator.this.setGrammarURI(localFile.toURI().toString());
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError((Throwable)e.getCause(), (String)Messages.NewXMLObjectPreparator_ErrorLocalSchemaCopy, (Object[])new Object[]{schemaObject});
        }
        catch (InterruptedException e) {
            Activator.handleError((Throwable)e, (String)Messages.NewXMLObjectPreparator_ErrorLocalSchemaCopy, (Object[])new Object[]{schemaObject});
        }
    }

    public TextGridObject getGrammarObject() {
        return this.grammarObject;
    }
}

