/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor.actions;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.search.FullTextEntry;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.menus.OpenObjectService;
import info.textgrid.lab.xmleditor.mpeditor.actions.Messages;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;

public class OpenXMLObjectHandler
extends AbstractHandler
implements IHandler {
    private static final String PARAMETER_URI_ID = "info.textgrid.lab.xmleditor.mpeditor.openxmlobject.parameter.uri";
    private static final String PARAMETER_READONLY_ID = "info.textgrid.lab.xmleditor.mpeditor.openxmlobject.parameter.readonly";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String parameterURI = null;
        String parameterReadOnly = null;
        TextGridObject object = null;
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ISelection selection = null;
        IStructuredSelection sel = null;
        parameterURI = event.getParameter(PARAMETER_URI_ID);
        parameterReadOnly = event.getParameter(PARAMETER_READONLY_ID);
        if (parameterURI != null) {
            try {
                object = TextGridObject.getInstance((URI)new URI(parameterURI), (boolean)false);
                selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                if (selection instanceof IStructuredSelection) {
                    sel = (IStructuredSelection)selection;
                }
            }
            catch (CrudServiceException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.ui.core", Messages.OpenXMLObjectHandler_CouldNotRetrieveTGO, (Throwable)e));
            }
            catch (URISyntaxException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.ui.core", Messages.OpenXMLObjectHandler_CouldNotRetrieveTGO, (Throwable)e));
            }
        }
        if (object != null) {
            if ("info.textgrid.lab.linkeditor.rcp_linkeditor.perspective".equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId())) {
                try {
                    handlerService.executeCommand("info.textgrid.lab.linkeditor.rcp_linkeditor.defaultOpen", null);
                }
                catch (CommandException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.ui.core", Messages.OpenXMLObjectHandler_CouldNotOpenLinkeditor, (Throwable)e));
                }
                return null;
            }
            if ("info.textgrid.lab.ttle.perspective".equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId())) {
                try {
                    handlerService.executeCommand("info.textgrid.lab.ttle.defaultOpen", null);
                }
                catch (CommandException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.ui.core", Messages.OpenXMLObjectHandler_CouldNotOpenTTLE, (Throwable)e));
                }
                return null;
            }
            try {
                PlatformUI.getWorkbench().showPerspective("info.textgrid.lab.welcome.XMLEditorPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                Status status = new Status(4, "info.textgrid.lab.ui.core", Messages.OpenXMLObjectHandler_CouldNotOpenPerspective, (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            OpenObjectService.getInstance().openObject(object, 2, Boolean.parseBoolean(parameterReadOnly));
            if (sel != null && sel.getFirstElement() instanceof FullTextEntry) {
                OpenXMLObjectHandler.callSelectByIDCommand((FullTextEntry)sel.getFirstElement());
            }
        }
        return null;
    }

    private static void callSelectByIDCommand(FullTextEntry entry) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        Command command = commandService.getCommand("info.textgrid.lab.xmleditor.mpeditor.selectByID");
        try {
            IParameter parameterID = command.getParameter("info.textgrid.lab.xmleditor.mpeditor.selectByID.ID");
            Parameterization parameter1 = new Parameterization(parameterID, entry.getXpath());
            IParameter parameterSearchTerm = command.getParameter("info.textgrid.lab.xmleditor.mpeditor.selectByID.SearchTerm");
            Parameterization parameter2 = new Parameterization(parameterSearchTerm, entry.getMatch());
            ParameterizedCommand parmCommand = new ParameterizedCommand(command, new Parameterization[]{parameter1, parameter2});
            handlerService.executeCommand(parmCommand, null);
        }
        catch (NotDefinedException e) {
            Activator.handleError((Throwable)e, (String)Messages.OpenXMLObjectHandler_CouldNotSelectX, (Object[])new Object[]{entry});
        }
        catch (ExecutionException e) {
            Activator.handleError((Throwable)e, (String)Messages.OpenXMLObjectHandler_CouldNotSelectX, (Object[])new Object[]{entry});
        }
        catch (NotEnabledException e) {
            Activator.handleError((Throwable)e, (String)Messages.OpenXMLObjectHandler_CouldNotSelectX, (Object[])new Object[]{entry});
        }
        catch (NotHandledException e) {
            Activator.handleError((Throwable)e, (String)Messages.OpenXMLObjectHandler_CouldNotSelectX, (Object[])new Object[]{entry});
        }
    }
}

