/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.projectadmin.dialogs;

import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.navigator.DeferredTreeContentProvider;
import info.textgrid.lab.navigator.NaviView;
import info.textgrid.lab.projectadmin.dialogs.Messages;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class CreateProjectDialog
extends TrayDialog {
    Group g;
    Text newProjectName;
    Text newProjectDescription;
    TextGridProject newtgp;
    Label statusLabel;
    Button closeButton;
    Button createButton;
    final Shell parent;
    Button centerUM;
    DeferredTreeContentProvider.IDeferredTreeListener naviListener;

    public CreateProjectDialog(Shell shell) {
        super(shell);
        this.parent = shell;
        this.initialize();
    }

    public CreateProjectDialog(IShellProvider parentShell) {
        super(parentShell);
        this.parent = null;
        this.initialize();
    }

    protected void initialize() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        this.centerUM = new Button(parent, 32);
        this.centerUM.setText(Messages.CreateProjectDialog_OpenUM);
        this.centerUM.setSelection(true);
        this.closeButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton = this.createButton(parent, -123, "Create", true);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 1) {
            this.close();
        } else if (buttonId == -123) {
            this.createButton.setEnabled(false);
            boolean created = this.evaluateAndCreate();
            if (created) {
                this.close();
            } else {
                this.createButton.setEnabled(true);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.CreateProjectDialog_NewProject);
        GridData parentGD = new GridData();
        parentGD.horizontalAlignment = 4;
        parentGD.grabExcessVerticalSpace = true;
        parentGD.grabExcessHorizontalSpace = true;
        parentGD.heightHint = 300;
        parentGD.widthHint = 400;
        parentGD.verticalAlignment = 4;
        this.g = new Group(parent, 0);
        this.g.setLayout((Layout)new GridLayout(1, false));
        this.g.setText(Messages.CreateProjectDialog_NewProjectText);
        Label hint = new Label((Composite)this.g, 64);
        hint.setText(MessageFormat.format(Messages.CreateProjectDialog_GeneralHint, TextGridProject.findLabelForRBACRole((String)"Projektleiter")));
        Composite c = new Composite((Composite)this.g, 4);
        GridData cGD = new GridData();
        cGD.horizontalAlignment = 4;
        cGD.grabExcessVerticalSpace = true;
        cGD.grabExcessHorizontalSpace = true;
        cGD.heightHint = 100;
        cGD.widthHint = 400;
        cGD.verticalAlignment = 4;
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)cGD);
        Label nameLabel = new Label(c, 16384);
        nameLabel.setText(Messages.CreateProjectDialog_ProjectNameLabel);
        this.newProjectName = new Text(c, 16388);
        GridData gd1 = new GridData(4, 2, true, false);
        this.newProjectName.setLayoutData((Object)gd1);
        Label descLabel = new Label(c, 16384);
        descLabel.setText(Messages.CreateProjectDialog_ProjectDescriptionLabel);
        this.newProjectDescription = new Text(c, 16388);
        GridData gd2 = new GridData(4, 2, true, false);
        this.newProjectDescription.setLayoutData((Object)gd2);
        Label stLabel = new Label(c, 16384);
        stLabel.setText("");
        this.statusLabel = new Label(c, 64);
        GridData stGD = new GridData();
        stGD.horizontalAlignment = 4;
        stGD.grabExcessVerticalSpace = true;
        stGD.grabExcessHorizontalSpace = true;
        stGD.heightHint = 80;
        stGD.widthHint = 300;
        stGD.verticalAlignment = 4;
        this.statusLabel.setText(Messages.CreateProjectDialog_StatusHint);
        this.statusLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        this.setNaviViewListener();
        return this.g;
    }

    private boolean evaluateAndCreate() {
        if (this.newProjectName.getText().length() > 0 && this.newProjectDescription.getText().length() > 0) {
            this.informUser(Messages.CreateProjectDialog_StatusCreating);
            this.startJob(this.newProjectName.getText(), this.newProjectDescription.getText(), this.centerUM.getSelection());
            return true;
        }
        this.informUser(Messages.CreateProjectDialog_StatusHintMessage);
        return false;
    }

    public void informUser(String message) {
        this.statusLabel.setText(message);
        this.statusLabel.pack();
    }

    private void startJob(final String name, final String description, final boolean centerUM) {
        Job currentJob = new Job(Messages.CreateProjectDialog_13){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.CreateProjectDialog_14, -1);
                try {
                    CreateProjectDialog.this.newtgp = TextGridProject.createNewProject((String)name, (String)description);
                    if (centerUM) {
                        CreateProjectDialog.this.parent.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CreateProjectDialog.this.showUM();
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
                catch (RemoteException e) {
                    OnlineStatus.netAccessFailed((String)MessageFormat.format(Messages.CreateProjectDialog_16, name), (Throwable)e);
                    e.getMessage();
                    return Status.OK_STATUS;
                }
            }
        };
        currentJob.setPriority(30);
        currentJob.schedule();
    }

    public void showUM() {
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchPage wbPage = wb.getActiveWorkbenchWindow().getActivePage();
            if (wbPage == null) {
                wb.getActiveWorkbenchWindow().openPage(Messages.CreateProjectDialog_17, null);
            }
            PlatformUI.getWorkbench().showPerspective(Messages.CreateProjectDialog_18, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
    }

    public void centerNavigatorOnNewProject(TextGridProject newtgp) {
        IViewPart naviView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(Messages.CreateProjectDialog_19);
        if (naviView != null && naviView instanceof NaviView && newtgp != null) {
            NaviView nVinstance = (NaviView)naviView;
            StructuredSelection sel = new StructuredSelection((Object)newtgp);
            nVinstance.setSelection((ISelection)sel, true);
            DeferredTreeContentProvider.removeListener((DeferredTreeContentProvider.IDeferredTreeListener)this.naviListener);
        }
    }

    private void setNaviViewListener() {
        this.naviListener = new DeferredTreeContentProvider.IDeferredTreeListener(){

            public void deferredTreeDone() {
                CreateProjectDialog.this.centerNavigatorOnNewProject(CreateProjectDialog.this.newtgp);
            }
        };
        DeferredTreeContentProvider.addListener((DeferredTreeContentProvider.IDeferredTreeListener)this.naviListener);
    }
}

