/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.debug.decoraters;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.debug.LabDebugPlugin;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.statushandlers.StatusManager;

public class ResourceProblemDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    public static final String MOVE_TGOBJECT = "MOVE_TGOBJECT";
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            Object[] deltas = event.findMarkerDeltas("org.eclipse.core.resources.marker", true);
            ArrayList resources = Lists.newArrayListWithCapacity((int)deltas.length);
            Object[] objectArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta delta = objectArray[n2];
                resources.add(delta.getResource());
                ++n2;
            }
            ResourceProblemDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ResourceProblemDecorator.this, deltas));
        }
    };

    public ResourceProblemDecorator() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 16);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.dispose();
    }

    public void decorate(Object element, IDecoration decoration) {
        IResource resource = null;
        IJobManager jobMan = Job.getJobManager();
        Job[] jobs = jobMan.find((Object)MOVE_TGOBJECT);
        if (jobs.length == 0) {
            resource = (IResource)AdapterUtils.getAdapter((Object)element, IFile.class);
        }
        if (resource != null) {
            try {
                IMarker[] markers = resource.findMarkers(null, true, 2);
                int severity = 0;
                LinkedList messages = Lists.newLinkedList();
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    if (marker.exists()) {
                        severity = Math.max(severity, marker.getAttribute("severity", 0));
                        messages.add(marker.getAttribute("message", null));
                    }
                    ++n2;
                }
                if (severity > 0) {
                    String joinedMessage = Joiner.on((String)"; ").join(Iterables.filter((Iterable)messages, (Predicate)Predicates.notNull()));
                    decoration.addSuffix(joinedMessage);
                    ImageDescriptor overlay = LabDebugPlugin.getDefault().getImageRegistry().getDescriptor(severity == 2 ? "IMG_DEC_FIELD_ERROR" : "IMG_DEC_FIELD_WARNING");
                    decoration.addOverlay(overlay, 2);
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.core.model");
            }
        }
    }
}

