/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.model.graphics;

import info.textgrid.lab.linkeditor.model.Activator;
import info.textgrid.lab.linkeditor.model.graphics.TGShape;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class TGLine
extends TGShape {
    private static final int maxPointToLineDist = 5;
    private static final int minDeltaX = 10;
    private static final int minDeltaY = 10;
    private Point selectedPoint = null;
    private ArrayList<Point> points = new ArrayList(2);

    public TGLine(String imageUri) {
        this.imageUri = imageUri;
    }

    public TGLine(Point[] points, String imageUri) {
        this.addPoints(points);
        this.imageUri = imageUri;
    }

    @Override
    public TGShape clone() {
        TGLine l = new TGLine(this.getPoints(), this.imageUri);
        l.setWritingMode(this.getWritingMode());
        l.setLinked(this.isLinked());
        return l;
    }

    public void addPoints(Point[] points) {
        int i = 0;
        while (i < points.length) {
            this.addPoint(points[i]);
            ++i;
        }
    }

    public void addPoint(int x, int y) {
        this.addPoint(new Point(x, y));
    }

    public void addPoint(Point point) {
        this.points.add(new Point(point.x, point.y));
    }

    public Point[] getPoints() {
        Point[] p = new Point[this.size()];
        return this.points.toArray(p);
    }

    public int[] getPointsArray() {
        ArrayList<Integer> ia = new ArrayList<Integer>();
        for (Point p : this.points) {
            ia.add(p.x);
            ia.add(p.y);
        }
        int[] a = new int[ia.size()];
        int i = 0;
        while (i < ia.size()) {
            a[i] = (Integer)ia.get(i);
            ++i;
        }
        return a;
    }

    public int[] getXPoints() {
        int[] ia = new int[this.points.size()];
        int i = 0;
        while (i < this.points.size()) {
            ia[i] = this.getPoints()[i].x;
            ++i;
        }
        return ia;
    }

    public int[] getYPoints() {
        int[] ia = new int[this.points.size()];
        int i = 0;
        while (i < this.points.size()) {
            ia[i] = this.getPoints()[i].y;
            ++i;
        }
        return ia;
    }

    public String getPointsSequenceString() {
        int[] a = this.getPointsArray();
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < a.length) {
            s.append(a[i]);
            if (i < a.length - 1) {
                s.append(",");
            }
            ++i;
        }
        return s.toString();
    }

    @Override
    public boolean equals(Object obj) {
        TGLine other = null;
        if (!(obj instanceof TGLine)) {
            return false;
        }
        other = (TGLine)obj;
        return this.getPointsSequenceString().equals(other.getPointsSequenceString()) && this.imageUri.equals(other.imageUri);
    }

    public String toString() {
        return String.valueOf(super.hashCode()) + " Points {x1,y1,x2,y2} = {" + this.getPointsSequenceString() + "} imageUri: " + this.getImageUri();
    }

    public int size() {
        return this.points.size();
    }

    public boolean isDeltaXOK() {
        int[] xp = this.getXPoints();
        int[] yp = this.getYPoints();
        return Math.abs(xp[0] - xp[1]) >= 10 || Math.abs(yp[0] - yp[1]) >= 10;
    }

    public Point getLastPoint() {
        if (this.size() < 1) {
            return null;
        }
        return this.getPoints()[this.size() - 1];
    }

    public void reset() {
        this.points.clear();
    }

    public boolean isPointAlmostOnSelectedRegion(int x, int y) {
        Point[] pointArray = this.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            if (TGLine.createRectAroundThePoint(p, 5).contains(x, y)) {
                this.selectedPoint = p;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Rectangle createRectAroundThePoint(Point point, int pixel) {
        int x = point.x;
        int y = point.y;
        return new Rectangle(x - pixel, y - pixel, 2 * pixel, 2 * pixel);
    }

    @Override
    public boolean contains(int px, int py) {
        int x1 = this.getXPoints()[0];
        int x2 = this.getXPoints()[1];
        int y1 = this.getYPoints()[0];
        int y2 = this.getYPoints()[1];
        double dist = Line2D.ptLineDist(x1, y1, x2, y2, px, py);
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minY = Math.min(y1, y2);
        int maxY = Math.max(y1, y2);
        return dist <= 5.0 && px >= minX && px <= maxX && py >= minY && py <= maxY;
    }

    @Override
    public void move(int dx, int dy) {
        if (this.size() == 0) {
            return;
        }
        TGLine tempLine = new TGLine(this.imageUri);
        Point[] pointArray = this.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            tempLine.addPoint(p.x + dx, p.y + dy);
            ++n2;
        }
        this.reset();
        this.addPoints(tempLine.getPoints());
        if (this.selectedPoint != null) {
            this.selectedPoint = new Point(this.selectedPoint.x + dx, this.selectedPoint.y + dy);
        }
    }

    @Override
    public void resize(int dx, int dy, int cursor) {
        if (this.selectedPoint == null) {
            return;
        }
        TGLine temp = new TGLine(this.imageUri);
        Point[] pointArray = this.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            if (!p.equals((Object)this.selectedPoint)) {
                temp.addPoint(p.x, p.y);
            } else {
                this.selectedPoint = new Point(p.x + dx, p.y + dy);
                temp.addPoint(this.selectedPoint);
            }
            ++n2;
        }
        this.reset();
        this.addPoints(temp.getPoints());
    }

    public Rectangle getBoundsRect() {
        if (this.size() == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        Point first = this.getPoints()[0];
        minX = first.x;
        minY = first.y;
        Point[] pointArray = this.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (p.y > maxY) {
                maxY = p.y;
            }
            ++n2;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public boolean isCompletedShape() {
        return this.size() > 0;
    }

    public String createAnnotatedLink(int image_width, int image_height) {
        return "<dockingLine " + this.dockingLineToPercent(image_width, image_height) + " imageUri=\"" + this.imageUri + "\"/>\n";
    }

    private String dockingLineToPercent(int image_width, int image_height) {
        double help = 0.0;
        String linePercent = "";
        int i = 0;
        while (i < this.size()) {
            Point p = this.getPoints()[i];
            help = (double)p.x * 100.0 / (double)image_width;
            linePercent = String.valueOf(linePercent) + help + ",";
            help = (double)p.y * 100.0 / (double)image_height;
            linePercent = String.valueOf(linePercent) + help + (i == this.size() - 1 ? "" : ",");
            ++i;
        }
        return "lineCoords=\"" + linePercent + "\"";
    }

    public double getAngleValue() {
        Point p1 = null;
        Point p2 = null;
        double angle = 0.0;
        try {
            int[] xPoints = this.getXPoints();
            int[] yPoints = this.getYPoints();
            p1 = new Point(xPoints[0], yPoints[0]);
            p2 = new Point(xPoints[1], yPoints[1]);
            double dx = p2.x - p1.x;
            double dy = p2.y - p1.y;
            angle = Math.toDegrees(Math.atan(dy / dx));
        }
        catch (Exception e) {
            e.printStackTrace();
            Activator.handleWarning(e);
        }
        angle = angle < 0.0 ? (angle *= -1.0) : 180.0 - angle;
        if (angle == 180.0) {
            angle = 0.0;
        }
        angle = StrictMath.floor(angle);
        return angle;
    }

    public Point[] transformLine(String art) {
        Point p1 = null;
        Point p2 = null;
        try {
            int[] xPoints = this.getXPoints();
            int[] yPoints = this.getYPoints();
            p1 = new Point(xPoints[0], yPoints[0]);
            p2 = new Point(xPoints[1], yPoints[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Point[] points = null;
        try {
            double dx = p2.x - p1.x;
            double dy = p2.y - p1.y;
            double length = Math.sqrt(dy * dy + dx * dx);
            int ym = Math.abs((p1.y - p2.y) / 2);
            ym = p1.y >= p2.y ? (ym += p2.y) : (ym += p1.y);
            int xm = Math.abs((p1.x - p2.x) / 2);
            xm = p1.x >= p2.x ? (xm += p2.x) : (xm += p1.x);
            points = new Point[2];
            if (art.equals("HORIZONTAL")) {
                points[0] = new Point((int)((double)xm - length / 2.0), ym);
                points[1] = new Point((int)((double)xm + length / 2.0), ym);
            } else if (art.equals("VERTICAL")) {
                points[0] = new Point(xm, (int)((double)ym - length / 2.0));
                points[1] = new Point(xm, (int)((double)ym + length / 2.0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return points;
    }

    @Deprecated
    private String dockingLineCoordsToPercent(int image_width, int image_height) {
        double help = 0.0;
        String linePercent = "";
        Point p1 = this.points.get(0);
        Point p2 = this.points.get(1);
        help = (double)p1.x * 100.0 / (double)image_width;
        linePercent = String.valueOf(linePercent) + "x1=\"" + help + "\" ";
        help = (double)p1.y * 100.0 / (double)image_height;
        linePercent = String.valueOf(linePercent) + "y1=\"" + help + "\" ";
        help = (double)p2.x * 100.0 / (double)image_width;
        linePercent = String.valueOf(linePercent) + "x2=\"" + help + "\" ";
        help = (double)p2.y * 100.0 / (double)image_height;
        linePercent = String.valueOf(linePercent) + "y2=\"" + help + "\"";
        return linePercent;
    }

    @Override
    public OMElement createOMElement(OMFactory factory, OMElement parent, OMNamespace ns, int imageWidth, int imageHeight) {
        OMElement lineElem = factory.createOMElement("line", ns, (OMContainer)parent);
        double value = 0.0;
        Point p1 = this.points.get(0);
        Point p2 = this.points.get(1);
        value = (double)p1.x * 100.0 / (double)imageWidth;
        lineElem.addAttribute("x1", String.valueOf(String.valueOf(value)) + "%", null);
        value = (double)p1.y * 100.0 / (double)imageHeight;
        lineElem.addAttribute("y1", String.valueOf(String.valueOf(value)) + "%", null);
        value = (double)p2.x * 100.0 / (double)imageWidth;
        lineElem.addAttribute("x2", String.valueOf(String.valueOf(value)) + "%", null);
        value = (double)p2.y * 100.0 / (double)imageHeight;
        lineElem.addAttribute("y2", String.valueOf(String.valueOf(value)) + "%", null);
        return lineElem;
    }

    @Override
    public TGShape.TYPE getType() {
        return TGShape.TYPE.DOCKING_LINE;
    }

    public static void main(String[] args) {
        TGLine l = new TGLine("ssssss");
        l.addPoint(5, 10);
        l.addPoint(20, 30);
        System.err.println(l.getPointsSequenceString());
        System.err.println(l.getXPoints()[0]);
    }
}

