/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.model.graphics;

import info.textgrid.lab.linkeditor.model.graphics.TGShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class TGPolygon
extends TGShape {
    private Point selectedPoint = null;
    private List<Point> points = Collections.synchronizedList(new ArrayList());

    public TGPolygon(String imageUri) {
        this.imageUri = imageUri;
    }

    public TGPolygon(Point[] points, String imageUri) {
        this.addPoints(points);
        this.imageUri = imageUri;
    }

    @Override
    public TGShape clone() {
        TGPolygon p = new TGPolygon(this.getPoints(), this.imageUri);
        p.setWritingMode(this.getWritingMode());
        p.setLinked(this.isLinked());
        p.setLayerValues(new Integer(this.getLayer()), this.getLayerName(), this.getLayerRGB());
        p.assocLink = this.assocLink;
        return p;
    }

    public void addPoints(Point[] points) {
        int i = 0;
        while (i < points.length) {
            this.addPoint(points[i]);
            ++i;
        }
    }

    public void addPoint(int x, int y) {
        this.addPoint(new Point(x, y));
    }

    public void addPoint(Point point) {
        this.points.add(new Point(point.x, point.y));
    }

    public void addPointVertex(int x, int y) {
        this.addPointVertex(new Point(x, y));
    }

    public void addPointVertex(Point point) {
        if (this.isPointAlmostOnSelectedRegion(point.x, point.y)) {
            Point p = new Point(this.selectedPoint.x, this.selectedPoint.y);
            Point pN = new Point(this.selectedPoint.x - 10, this.selectedPoint.y);
            int pos = this.points.indexOf(p);
            this.points.add(pos, pN);
        }
    }

    public void remPoint(int x, int y) {
        this.remPoint(new Point(x, y));
    }

    public void remPoint(Point point) {
        if (this.isPointAlmostOnSelectedRegion(point.x, point.y)) {
            Point pN = new Point(this.selectedPoint.x, this.selectedPoint.y);
            this.points.remove(pN);
        }
    }

    public Point[] getPoints() {
        Point[] p = new Point[this.size()];
        return this.points.toArray(p);
    }

    public int[] getPointsArray() {
        ArrayList<Integer> ia = new ArrayList<Integer>();
        for (Point p : this.points) {
            ia.add(p.x);
            ia.add(p.y);
        }
        int[] a = new int[ia.size()];
        int i = 0;
        while (i < ia.size()) {
            a[i] = (Integer)ia.get(i);
            ++i;
        }
        return a;
    }

    public int[] getXPoints() {
        int[] ia = new int[this.points.size()];
        int i = 0;
        while (i < this.points.size()) {
            ia[i] = this.getPoints()[i].x;
            ++i;
        }
        return ia;
    }

    public int[] getYPoints() {
        int[] ia = new int[this.points.size()];
        int i = 0;
        while (i < this.points.size()) {
            ia[i] = this.getPoints()[i].y;
            ++i;
        }
        return ia;
    }

    public String getPointsSequenceString() {
        int[] a = this.getPointsArray();
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < a.length) {
            s.append(a[i]);
            if (i < a.length - 1) {
                s.append(",");
            }
            ++i;
        }
        return s.toString();
    }

    @Override
    public boolean equals(Object obj) {
        TGPolygon other = null;
        if (!(obj instanceof TGPolygon)) {
            return false;
        }
        other = (TGPolygon)obj;
        return this.getPointsSequenceString().equals(other.getPointsSequenceString()) && this.imageUri.equals(other.imageUri);
    }

    public String toString() {
        return String.valueOf(super.hashCode()) + " Points {x1,y1,x2,y2,...} = {" + this.getPointsSequenceString() + "} imageUri: " + this.imageUri;
    }

    public int size() {
        return this.points.size();
    }

    public Point getLastPoint() {
        if (this.size() < 1) {
            return null;
        }
        return this.getPoints()[this.size() - 1];
    }

    public void reset() {
        this.points.clear();
    }

    public boolean isPointOnBoundary(int x, int y) {
        if (this.points.isEmpty()) {
            return false;
        }
        Point p1 = this.points.get(0);
        Point p2 = null;
        int i = 1;
        while (i < this.points.size()) {
            p2 = this.points.get(i);
            float m = (p2.y - p1.y) / (p2.x - p1.x);
            float bb = (float)p1.y - m * (float)p1.x;
            float b = (float)y - m * (float)x;
            if (Math.abs(bb - b) <= 10.0f) {
                return true;
            }
            p1 = p2;
            ++i;
        }
        return false;
    }

    public boolean isPointAlmostOnSelectedRegion(int x, int y) {
        Point[] pointArray = this.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            if (TGPolygon.createRectAroundThePoint(p, 5).contains(x, y)) {
                this.selectedPoint = p;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Rectangle createRectAroundThePoint(Point point, int pixel) {
        int x = point.x;
        int y = point.y;
        return new Rectangle(x - pixel, y - pixel, 2 * pixel, 2 * pixel);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.size() == 0) {
            return false;
        }
        TGPolygon poly = new TGPolygon(this.getPoints(), this.getImageUri());
        poly.addPoint(this.getPoints()[0]);
        int counter = 0;
        double xinters = 0.0;
        Point p1 = this.getPoints()[0];
        Point p2 = null;
        int size = poly.size();
        int i = 1;
        while (i <= size) {
            p2 = poly.getPoints()[i % size];
            if (y > Math.min(p1.y, p2.y) && y <= Math.max(p1.y, p2.y) && x <= Math.max(p1.x, p2.x) && p1.y != p2.y) {
                xinters = (y - p1.y) * (p2.x - p1.x) / (p2.y - p1.y) + p1.x;
                if (p1.x == p2.x || (double)x <= xinters) {
                    ++counter;
                }
            }
            p1 = p2;
            ++i;
        }
        return counter % 2 != 0;
    }

    @Override
    public void move(int dx, int dy) {
        if (this.size() == 0) {
            return;
        }
        TGPolygon tempPoly = new TGPolygon(this.imageUri);
        Point[] pointArray = this.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            tempPoly.addPoint(p.x + dx, p.y + dy);
            ++n2;
        }
        this.reset();
        this.addPoints(tempPoly.getPoints());
        if (this.selectedPoint != null) {
            this.selectedPoint = new Point(this.selectedPoint.x + dx, this.selectedPoint.y + dy);
        }
    }

    @Override
    public void resize(int dx, int dy, int cursor) {
        if (this.selectedPoint == null) {
            return;
        }
        TGPolygon temp = new TGPolygon(this.imageUri);
        Point[] pointArray = this.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            if (!p.equals((Object)this.selectedPoint)) {
                temp.addPoint(p.x, p.y);
            } else {
                this.selectedPoint = new Point(p.x + dx, p.y + dy);
                temp.addPoint(this.selectedPoint);
            }
            ++n2;
        }
        this.reset();
        this.addPoints(temp.getPoints());
    }

    public Rectangle getBoundsRect() {
        if (this.size() == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        Point first = this.getPoints()[0];
        minX = first.x;
        minY = first.y;
        Point[] pointArray = this.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (p.y > maxY) {
                maxY = p.y;
            }
            ++n2;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public boolean isCompletedShape() {
        return this.size() > 0;
    }

    private String polyCoordsToPercent(int image_width, int image_height) {
        double help = 0.0;
        String polyPercent = "";
        int i = 0;
        while (i < this.size()) {
            Point p = this.getPoints()[i];
            help = (double)p.x * 100.0 / (double)image_width;
            polyPercent = String.valueOf(polyPercent) + help + "%" + ",";
            help = (double)p.y * 100.0 / (double)image_height;
            polyPercent = String.valueOf(polyPercent) + help + "%" + (i == this.size() - 1 ? "" : " ");
            ++i;
        }
        return polyPercent;
    }

    @Override
    public OMElement createOMElement(OMFactory factory, OMElement parent, OMNamespace ns, int imageWidth, int imageHeight) {
        OMElement polyElem = factory.createOMElement("polygon", ns, (OMContainer)parent);
        polyElem.addAttribute("points", this.polyCoordsToPercent(imageWidth, imageHeight), null);
        return polyElem;
    }

    @Override
    public TGShape.TYPE getType() {
        return TGShape.TYPE.POLY;
    }

    public static void main(String[] args) {
        Point[] p;
        TGPolygon p1 = new TGPolygon("hallo");
        p1.addPoint(new Point(2, 3));
        p1.addPoint(new Point(5, 6));
        p1.addPoint(new Point(7, 9));
        p1.addPoint(new Point(3, 3));
        p1.addPoint(new Point(1, 6));
        TGPolygon p2 = new TGPolygon("test");
        p2.addPoint(new Point(2, 3));
        p2.addPoint(new Point(5, 6));
        p2.addPoint(new Point(7, 9));
        p2.addPoint(new Point(3, 3));
        p2.addPoint(new Point(1, 6));
        Point[] pointArray = p = p2.getPoints();
        int n = p.length;
        int n2 = 0;
        while (n2 < n) {
            Point o = pointArray[n2];
            System.err.println(o);
            ++n2;
        }
        System.err.println(p1.equals(p2));
        p2.addPoint(2, 3);
        System.err.println(p1.equals(p2));
        p1.addPoint(new Point(2, 3));
        System.err.println(p1.equals(p2));
        p1.addPoint(new Point(1, 6));
        System.err.println(p1.equals(p2));
        System.err.println(p1.getPointsSequenceString());
        System.err.println(p1.getLastPoint());
        System.err.println(p1);
        System.err.println(p2);
        p1.move(3, -2);
        System.err.println(p1);
        System.err.println(p1.isPointAlmostOnSelectedRegion(13, 6));
        p1.resize(2, 3, 0);
        System.err.println(p1);
        p1.move(1, 1);
        System.err.println(p1);
        p1.resize(2, 3, 0);
        System.err.println(p1);
        String[] as = p1.getPointsSequenceString().split(",");
        double help = 0.0;
        String polyPercent = "";
        int i = 0;
        String[] stringArray = as;
        int n3 = as.length;
        int n4 = 0;
        while (n4 < n3) {
            String s = stringArray[n4];
            if (i % 2 == 0) {
                help = Double.valueOf(s) * 100.0 / 2.0;
                polyPercent = String.valueOf(polyPercent) + help + ", ";
            } else {
                help = Double.valueOf(s) * 100.0 / 2.0;
                polyPercent = String.valueOf(polyPercent) + help + (i == as.length - 1 ? "" : ", ");
            }
            ++i;
            ++n4;
        }
        System.err.println(polyPercent);
        System.err.println(p1.getPointsSequenceString());
        System.err.println(p1.getBoundsRect());
        System.err.println(p1.contains(8, 4));
        System.err.println(p1.getXPoints());
        System.err.println(p1.getYPoints());
    }
}

