/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.authn;

import info.textgrid.lab.authn.Activator;
import info.textgrid.lab.authn.Messages;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.statushandlers.StatusManager;

public class AuthBrowser
extends Composite {
    private Browser authbrowser;
    private String rbacsid = "";
    private static ListenerList sidChangedListeners = new ListenerList();
    private String webAuth;

    public AuthBrowser(Composite parent) {
        super(parent, 4);
        GridData parentGD = new GridData();
        parentGD.horizontalAlignment = 4;
        parentGD.grabExcessVerticalSpace = true;
        parentGD.grabExcessHorizontalSpace = true;
        parentGD.heightHint = 500;
        parentGD.widthHint = 860;
        parentGD.verticalAlignment = 4;
        parent.setLayoutData((Object)parentGD);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        GridDataFactory labelsFactory = GridDataFactory.createFrom((GridData)gridData);
        try {
            this.authbrowser = new Browser(parent, 0);
        }
        catch (SWTError sWTError) {
            StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.authn", "Failed to instantiate Mozilla based browser (no XULrunner?), trying default instead ..."));
            this.authbrowser = new Browser(parent, 0);
        }
        labelsFactory.applyTo((Control)this.authbrowser);
        this.setLayout((Layout)new GridLayout());
        this.authbrowser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                AuthBrowser.this.rbacsid = (String)AuthBrowser.this.authbrowser.evaluate("if (document.getElementsByName('ePPNplusSID').length==1) {return document.getElementsByName('ePPNplusSID')[0].getAttribute('content');} else {return 'reset';}");
                if (AuthBrowser.this.rbacsid == "" || AuthBrowser.this.rbacsid == "reset") {
                    return;
                }
                String[] ePPNplusSID = AuthBrowser.this.rbacsid.split("\\|");
                if (ePPNplusSID.length != 2) {
                    return;
                }
                RBACSession.setSID(ePPNplusSID[1]);
                RBACSession.setEPPN(ePPNplusSID[0]);
                Status status = new Status(0, "info.textgrid.lab.authn", NLS.bind((String)Messages.AuthBrowser_AuthenticatedAs, (Object)ePPNplusSID[0]));
                Activator.getDefault().getLog().log((IStatus)status);
                AuthBrowser.notifySIDListeners(ePPNplusSID[1], ePPNplusSID[0]);
            }
        });
        try {
            ConfClient confClient = ConfClient.getInstance();
            this.webAuth = confClient.getValue("authz");
            Status status = new Status(0, "info.textgrid.lab.authn", MessageFormat.format(Messages.AuthBrowser_AuthAt, this.webAuth));
            Activator.getDefault().getLog().log((IStatus)status);
            this.authbrowser.setUrl(this.webAuth);
        }
        catch (OfflineException e) {
            OnlineStatus.netAccessFailed((String)Messages.AuthBrowser_CouldNotContactConfserv, (Throwable)e);
        }
    }

    public static void addSIDChangedListener(ISIDChangedListener listener) {
        sidChangedListeners.add((Object)listener);
    }

    public static void removeSIDChangedListener(ISIDChangedListener listener) {
        sidChangedListeners.remove((Object)listener);
    }

    protected static void notifySIDListeners(String newSID, String newEPPN) {
        Object[] objectArray = sidChangedListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISIDChangedListener)listener).sidChanged(newSID, newEPPN);
            ++n2;
        }
    }

    public static void sessionChanged() {
        AuthBrowser.notifySIDListeners(RBACSession.getInstance().getSID(false), RBACSession.getInstance().getEPPN());
    }

    public Browser getAuthBrowser() {
        return this.authbrowser;
    }

    public void resetAuthBrowser() {
        this.authbrowser.setUrl(this.webAuth);
    }

    public String getRbacSid() {
        return this.rbacsid;
    }

    public void dispose() {
        this.authbrowser.dispose();
        super.dispose();
    }

    public static interface ISIDChangedListener {
        public void sidChanged(String var1, String var2);
    }
}

