/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.authn;

import info.textgrid.lab.authn.Activator;
import info.textgrid.lab.authn.AuthNDialog;
import info.textgrid.lab.authn.Messages;
import info.textgrid.lab.conf.ConfPlugin;
import info.textgrid.lab.core.tgauthclient.TgAuthClientUtilities;
import info.textgrid.namespaces.metadata.agent._2010.PersonType;
import info.textgrid.namespaces.middleware.tgauth.Friend;
import info.textgrid.namespaces.middleware.tgauth.GetFriendsRequest;
import info.textgrid.namespaces.middleware.tgauth.GetFriendsResponse;
import info.textgrid.namespaces.middleware.tgauth.GetNamesRequest;
import info.textgrid.namespaces.middleware.tgauth.GetNamesResponse;
import info.textgrid.namespaces.middleware.tgauth.PortTgextra;
import info.textgrid.namespaces.middleware.tgauth.UserDetail;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public final class RBACSession
implements IPropertyChangeListener {
    private static final String ENV_OVERRIDE_VAR = "TEXTGRIDLAB_SID";
    private static String sid = "";
    private static String ePPN = "";
    private static RBACSession rbacsession;
    private static boolean neverAsk;
    private static boolean authDialogIsOpen;
    private static HashMap<String, UserDetail> nameCache;
    private static ArrayList<Friend> friends;
    private static PortTgextra stub;

    static {
        neverAsk = false;
        authDialogIsOpen = false;
        nameCache = new HashMap();
        friends = new ArrayList();
        stub = null;
    }

    private RBACSession() {
        ConfPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public static RBACSession getInstance() {
        if (rbacsession == null) {
            rbacsession = new RBACSession();
        }
        return rbacsession;
    }

    public static synchronized void setSID(String sID) {
        sid = sID;
        friends = new ArrayList();
    }

    public static synchronized void setEPPN(String eppn) {
        ePPN = eppn;
    }

    public static synchronized void neverAsk(boolean state) {
        neverAsk = state;
    }

    protected static synchronized void authDialogIsOpen(boolean state) {
        authDialogIsOpen = state;
    }

    public String getSID(boolean openAuthNDialogue) {
        String override_sid = System.getenv().get(ENV_OVERRIDE_VAR);
        if (override_sid != null) {
            sid = override_sid;
        }
        if (openAuthNDialogue && sid == "" && !neverAsk && !authDialogIsOpen) {
            authDialogIsOpen = true;
            if (this.inUIThread()) {
                this.startJobDirect();
            } else {
                this.startJobInUIThread();
            }
        }
        authDialogIsOpen = false;
        return sid;
    }

    public String getEPPN() {
        return ePPN;
    }

    private void startJobInUIThread() {
        UIJob uij = new UIJob(Messages.RBACSession_AuthNDialogue){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AuthNDialog aud = new AuthNDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                aud.open();
                return new Status(0, "info.textgrid.lab.authn", "opened Authentication Dialogue");
            }
        };
        uij.schedule();
        try {
            uij.join();
        }
        catch (InterruptedException e) {
            Status status = new Status(4, "info.textgrid.lab.authn", "Could not wait for AuthN dialogue to be closed!", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    private void startJobDirect() {
        AuthNDialog aud = new AuthNDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        aud.open();
    }

    private boolean inUIThread() {
        return Display.getCurrent() != null;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public ArrayList<Friend> getFriends(boolean retrieveFromRBAC) {
        if (retrieveFromRBAC) {
            Job job = new Job(Messages.RBACSession_FriendRetrieval){

                public IStatus run(IProgressMonitor monitor) {
                    GetFriendsRequest getFreq = new GetFriendsRequest();
                    getFreq.setAuth(sid);
                    getFreq.setLog("");
                    stub = RBACSession.this.getRBACStub();
                    GetFriendsResponse resp = new GetFriendsResponse();
                    resp = stub.getFriends(getFreq);
                    RBACSession.this.setFriends(resp);
                    return new Status(0, "info.textgrid.lab.authn", Messages.RBACSession_RetrievingContacts);
                }
            };
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                Status status = new Status(4, "info.textgrid.lab.authn", Messages.RBACSession_FriendRetrievalError, (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return friends;
    }

    private synchronized void setFriends(GetFriendsResponse gfr) {
        Friend[] friendArr = gfr.getFriends().toArray(new Friend[0]);
        if (friendArr == null) {
            friends = new ArrayList();
            return;
        }
        Arrays.sort(friendArr, new Comparator<Friend>(){

            @Override
            public int compare(Friend f1, Friend f2) {
                return f2.getScore().compareTo(f1.getScore());
            }
        });
        friends = new ArrayList<Friend>(Arrays.asList(friendArr));
    }

    private synchronized void setNames(GetNamesResponse gnr) {
        for (UserDetail ud : gnr.getUserdetails()) {
            nameCache.put(ud.getEPPN(), ud);
        }
    }

    private PortTgextra getRBACStub() {
        if (stub == null) {
            stub = TgAuthClientUtilities.getTgAuthServiceStub();
        }
        return stub;
    }

    public UserDetail getDetails(String ePPN) {
        if (!nameCache.containsKey(ePPN)) {
            ArrayList<String> a = new ArrayList<String>(1);
            a.add(ePPN);
            this.retrieveDetailsFromRBAC(a);
        }
        return nameCache.get(ePPN);
    }

    public PersonType getPerson(String ePPN) {
        PersonType personType = new PersonType();
        personType.setId("eduPersonPrincipalName:" + ePPN.trim());
        UserDetail details = this.getDetails(ePPN);
        personType.setValue(details != null ? details.getName() : ePPN);
        return personType;
    }

    public String getFullName(String ePPN) {
        return this.getDetails(ePPN).getName();
    }

    public PersonType getPerson() {
        return this.getPerson(this.getEPPN());
    }

    public void retrieveDetailsFromRBAC(ArrayList<String> ePPNs) {
        final ArrayList<String> todo = new ArrayList<String>();
        for (String ePPN : ePPNs) {
            if (nameCache.containsKey(ePPN)) continue;
            todo.add(ePPN);
            UserDetail ud = new UserDetail();
            ud.setName(ePPN);
            nameCache.put(ePPN, ud);
        }
        Job job = new Job(Messages.RBACSession_UserDetailsRetrieval){

            public IStatus run(IProgressMonitor monitor) {
                GetNamesRequest getNreq = new GetNamesRequest();
                getNreq.setAuth(sid);
                getNreq.setLog("");
                getNreq.getEPPN().addAll(todo);
                stub = RBACSession.this.getRBACStub();
                GetNamesResponse resp = new GetNamesResponse();
                resp = stub.getNames(getNreq);
                if (resp != null && resp.getUserdetails() != null && resp.getUserdetails().size() > 0) {
                    RBACSession.this.setNames(resp);
                }
                return new Status(0, "info.textgrid.lab.authn", Messages.RBACSession_RetrievingNameRecords);
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Status status = new Status(4, "info.textgrid.lab.authn", Messages.RBACSession_NameRecordsError, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }
}

