/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.multicharbrowser;

import info.textgrid.lab.xmleditor.multicharbrowser.Activator;
import info.textgrid.lab.xmleditor.multicharbrowser.CustomCharsetData;
import info.textgrid.lab.xmleditor.multicharbrowser.CustomCharsetDataSet;
import info.textgrid.lab.xmleditor.multicharbrowser.StreamWriterUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

public class CustomCharsetResourceReader {
    public static String bundlePath = Activator.getDefault().getBundle().getLocation();
    public static String customCharsetFilePath = String.valueOf(Activator.getDefault().getStateLocation().toPortableString()) + "/CustomCharsetDataSet.xml";
    private static Vector<CustomCharsetData> dataVector;

    public static String findResourcePath(String resourceDirectory, String requestedBundleResource) {
        String path = "";
        try {
            path = FileLocator.resolve((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(resourceDirectory).append(requestedBundleResource), null)).getFile();
        }
        catch (IOException e) {
            StreamWriterUtils.writeLogError(4, e.getMessage(), e);
        }
        return path;
    }

    public static URL findResource(String resourceDirectory, String requestedResource) {
        try {
            return FileLocator.resolve((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(resourceDirectory).append(requestedResource), null));
        }
        catch (IOException e) {
            StreamWriterUtils.writeLogError(4, "Could not resolve internal resource {0} in {1}: {2}\nThis is probably a bug, please file a bug report.", e);
            return null;
        }
    }

    public static boolean loadCustomCharsetsFromFile() {
        dataVector = new Vector();
        File xmlFile = new File(customCharsetFilePath);
        if (!xmlFile.exists()) {
            StreamWriterUtils.writeResourceToTempFile(Activator.getDefault().getStateLocation().toPortableString(), "Resources", "CustomCharsetDataSet.xml");
        }
        dataVector = CustomCharsetResourceReader.readCustomCharsetsFile();
        for (CustomCharsetData dataEntry : dataVector) {
            if (!dataEntry.getImageLocation().contains("$Bundle$")) continue;
            dataEntry.setImageLocation(CustomCharsetResourceReader.findResource("icons", dataEntry.getImageLocation().substring(dataEntry.getImageLocation().lastIndexOf("/"))).getFile());
        }
        return true;
    }

    public static void writeCustomCharsetsFile(Vector<CustomCharsetData> dataVector) {
        for (CustomCharsetData dataEntry : dataVector) {
            if (!dataEntry.getImageLocation().contains(bundlePath)) continue;
            dataEntry.setImageLocation(dataEntry.getImageLocation().replace(bundlePath, "$Bundle$"));
        }
        CustomCharsetDataSet customCharsetDataSet = new CustomCharsetDataSet();
        customCharsetDataSet.customCharsetData = dataVector;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"info.textgrid.lab.xmleditor.multicharbrowser");
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            try {
                marshaller.marshal((Object)customCharsetDataSet, (OutputStream)new FileOutputStream(new File(customCharsetFilePath)));
            }
            catch (FileNotFoundException e) {
                StreamWriterUtils.writeLogError(4, e.getMessage(), e);
            }
        }
        catch (JAXBException e1) {
            StreamWriterUtils.writeLogError(4, e1.getMessage(), (Object)e1);
        }
    }

    public static Vector<CustomCharsetData> readCustomCharsetsFile() {
        if (Activator.getDefault() instanceof Plugin) {
            Activator plugin = Activator.getDefault();
            String path = plugin.getStateLocation().toPortableString();
            String resourceDir = "Resources";
            String resourceFile = "CustomCharsetSchema.xsd";
            StreamWriterUtils.writeResourceToTempFile(path, resourceDir, resourceFile);
            Display.getCurrent().loadFont(String.valueOf(path) + "/" + resourceFile);
            try {
                CustomCharsetDataSet instance;
                JAXBContext jc = JAXBContext.newInstance((String)"info.textgrid.lab.xmleditor.multicharbrowser");
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = sf.newSchema(new File(String.valueOf(path) + "/" + resourceFile));
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                try {
                    unmarshaller.setSchema(schema);
                    instance = (CustomCharsetDataSet)unmarshaller.unmarshal(new File(customCharsetFilePath));
                }
                catch (UnmarshalException e) {
                    StreamWriterUtils.writeLogError(2, "Schema file collision: " + e.toString() + " Compensation successful.", (Object)e);
                    unmarshaller.setSchema(null);
                    instance = (CustomCharsetDataSet)unmarshaller.unmarshal(new File(customCharsetFilePath));
                }
                Vector<CustomCharsetData> myDataVector = new Vector<CustomCharsetData>();
                for (CustomCharsetData ccd : instance.customCharsetData) {
                    myDataVector.add(ccd);
                }
                return myDataVector;
            }
            catch (JAXBException e) {
                StreamWriterUtils.writeLogError(4, e.toString(), (Object)e);
            }
            catch (SAXException e) {
                StreamWriterUtils.writeLogError(4, e.toString(), e);
            }
        }
        return new Vector<CustomCharsetData>();
    }

    public static int[] resizeArray(int[] previousArray, int newSize) {
        int previousSize = Array.getLength(previousArray);
        Class<?> elementType = previousArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(previousSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(previousArray, 0, newArray, 0, preserveLength);
        }
        return (int[])newArray;
    }

    public static Vector<CustomCharsetData> getDataVector() {
        return dataVector;
    }

    public static URL validateImageLocationPath(String imageLocation) {
        if (imageLocation == "") {
            return CustomCharsetResourceReader.findResource("icons", "sample.gif");
        }
        if (imageLocation.contains("$Bundle$")) {
            return CustomCharsetResourceReader.findResource("icons", imageLocation.substring(imageLocation.lastIndexOf("/")));
        }
        if (!new File(imageLocation).exists()) {
            return CustomCharsetResourceReader.findResource("icons", "image-missing.png");
        }
        try {
            URL find = FileLocator.find((URL)new URL("file:/" + imageLocation));
            if (find == null) {
                return CustomCharsetResourceReader.findResource("icons", "sample.gif");
            }
            return FileLocator.resolve((URL)find);
        }
        catch (MalformedURLException e) {
            StreamWriterUtils.writeLogError(4, e.toString(), e);
        }
        catch (IOException e) {
            StreamWriterUtils.writeLogError(4, e.toString(), e);
        }
        return null;
    }
}

