/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.multicharbrowser;

import com.ibm.icu.lang.UCharacter;
import info.textgrid.lab.xmleditor.multicharbrowser.Activator;
import info.textgrid.lab.xmleditor.multicharbrowser.IModelViewer;
import info.textgrid.lab.xmleditor.multicharbrowser.Messages;
import info.textgrid.lab.xmleditor.multicharbrowser.StreamWriterUtils;
import info.textgrid.lab.xmleditor.multicharbrowser.UnicodeModel;
import info.textgrid.lab.xmleditor.multicharbrowser.UnicodeSymbolResourceReader;
import info.textgrid.lab.xmleditor.multicharbrowser.UnicodeView;
import info.textgrid.lab.xmleditor.multicharbrowser.ViewLabelProvider;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;

public class UnicodeViewer {
    private Table table;
    private TableViewer tableViewer;
    private TableCursor tableCursor;
    private Text searchBox;
    private Button insertButton;
    private Button mruButton;
    private Label labelUnicode;
    private Label labelPreview;
    private Label labelDescription;
    private Label labelNameUnicode;
    private Label labelNameDescription;
    private boolean currentSetIsBlock = true;
    private String currentUnicodeSet = UCharacter.UnicodeBlock.AEGEAN_NUMBERS.toString();
    private UnicodeModel chars = new UnicodeModel(this.currentUnicodeSet, this.currentSetIsBlock, 16);
    private final int columns = this.chars.getColumns();
    private static UnicodeView unicodeView;
    private TableItem selectedTableItem = null;
    private int selectedItemColumnPos = -1;
    private final Composite parentComposite;
    private boolean currentIsCustom = false;
    private String[] currentCustomChars = null;
    private Menu menuTableItemContext;
    private MenuItem copyToClipboard;
    private Menu menuMruList;
    private LinkedHashMap<String, Long> mruItemsMap;
    private Rectangle labelPreviewDrawingRectangle;
    private FormLayout layout;
    private final int borderOffset = 7;
    private String currentFontName = "MusicalSymbolsTextGrid";
    private static int currentColumns;
    private FontRegistry fontRegistry;

    static {
        currentColumns = 8;
    }

    private void addChildControls(Composite parent) {
        this.layout = new FormLayout();
        parent.setLayout((Layout)this.layout);
        this.loadSelectedFont();
        UnicodeSymbolResourceReader.readFromFile();
        this.createPreviewDrawingRectangle();
        this.setupControls(parent);
        this.createSearchBox(parent);
        this.createLabel(parent);
        this.createTable(parent);
        this.createTableViewer();
        this.createInsertButton(parent);
        this.createMruButton(parent);
        this.tableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.tableViewer.setInput((Object)this.chars);
    }

    private void createPreviewDrawingRectangle() {
        this.labelPreviewDrawingRectangle = Display.getCurrent() != null && Display.getCurrent().getActiveShell() != null ? Display.getCurrent().getActiveShell().getClientArea() : new Shell().getClientArea();
    }

    private void createSearchBox(Composite parent) {
        this.searchBox = new Text(parent, 896);
        SelectionAdapter searchBoxSelectionAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256 || UnicodeViewer.this.searchBox.getText().isEmpty() || UnicodeViewer.this.searchBox.getText().equals("Type unicode point, e.g. 2200")) {
                    UnicodeViewer.this.searchBox.setText("");
                } else {
                    String searchText = UnicodeViewer.this.searchBox.getText();
                    int searchStringAsHexInt = -1;
                    boolean done = false;
                    if (searchText.length() == 1) {
                        searchStringAsHexInt = searchText.codePointAt(0);
                    } else {
                        Pattern p = Pattern.compile("([0-9a-f])");
                        Matcher matcher = p.matcher(searchText.toLowerCase());
                        String workingString = "";
                        while (matcher.find()) {
                            workingString = String.valueOf(workingString) + matcher.group();
                        }
                        while (workingString.length() < 4) {
                            workingString = "0" + workingString;
                            UnicodeViewer.this.searchBox.setText(workingString);
                        }
                        searchStringAsHexInt = Integer.parseInt(workingString, 16);
                    }
                    String suspectedBlockName = UCharacter.UnicodeBlock.of((int)searchStringAsHexInt).toString();
                    if (suspectedBlockName.equals("LATIN_1_SUPPLEMENT") || suspectedBlockName.equals(null)) {
                        StreamWriterUtils.writeLogError(2, "Unicode Block unknown", new IllegalArgumentException("Not implemented."));
                    }
                    unicodeView.changeCharacterSet(suspectedBlockName, true);
                    TableItem[] tableItemArray = UnicodeViewer.this.table.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem ti = tableItemArray[n2];
                        int dataArrayLength = ((String[])ti.getData()).length;
                        int i = 0;
                        while (i < dataArrayLength) {
                            block12: {
                                try {
                                    int secondStringCharAsInt;
                                    char firstStringCharAsInt = ti.getText(i).charAt(0);
                                    int n3 = secondStringCharAsInt = ti.getText().length() > 1 ? ti.getText(i).charAt(1) + 7116 : 0;
                                    if (searchStringAsHexInt == firstStringCharAsInt + secondStringCharAsInt) {
                                        UnicodeViewer.this.processCharacterSelection(UnicodeViewer.this.tableCursor, ti, i);
                                        done = true;
                                    }
                                    break block12;
                                }
                                catch (IndexOutOfBoundsException ioube) {
                                    StreamWriterUtils.writeLogError(2, ioube.toString(), ioube);
                                }
                                break;
                            }
                            ++i;
                        }
                        if (done) break;
                        ++n2;
                    }
                }
            }
        };
        FormData formDataSearchBox = new FormData();
        formDataSearchBox.right = new FormAttachment(100, -7);
        formDataSearchBox.left = new FormAttachment(0, 7);
        formDataSearchBox.top = new FormAttachment(0, 7);
        this.searchBox.setLayoutData((Object)formDataSearchBox);
        this.searchBox.setForeground(new Color(null, 0, 0, 0));
        this.searchBox.setText("Type unicode point, e.g. 2200");
        this.searchBox.setToolTipText("Enter a Unicode Codepoint to get its Block shown in the table. Example: U+2200 or 2200");
        this.searchBox.selectAll();
        this.searchBox.addSelectionListener((SelectionListener)searchBoxSelectionAdapter);
    }

    private void createTable(Composite parent) {
        int style = 34820;
        this.table = new Table(parent, style);
        this.tableCursor = new TableCursor(this.table, 32);
        FormData formDataTable = new FormData();
        formDataTable.right = new FormAttachment(100, -7);
        formDataTable.left = new FormAttachment(0, 7);
        formDataTable.top = new FormAttachment((Control)this.searchBox, 7);
        formDataTable.bottom = new FormAttachment(100, -140);
        this.table.setLayoutData((Object)formDataTable);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        this.loadCurrentSelectedFont();
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 40;
            }
        });
        this.menuTableItemContext = new Menu((Control)parent);
        this.copyToClipboard = new MenuItem(this.menuTableItemContext, 64);
        this.copyToClipboard.setText("Copy to clipboard");
        this.copyToClipboard.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (UnicodeViewer.this.selectedTableItem != null) {
                    Clipboard clipBoard = new Clipboard(Display.getCurrent());
                    String insertion = UnicodeViewer.this.selectedTableItem.getText(UnicodeViewer.this.selectedItemColumnPos);
                    clipBoard.setContents((Object[])new String[]{insertion, insertion}, new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()});
                    clipBoard.dispose();
                    UnicodeViewer.this.saveMruListItem(insertion);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tableCursor.setMenu(this.menuTableItemContext);
        this.tableCursor.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 && UnicodeViewer.this.selectedTableItem != null && UnicodeViewer.this.selectedItemColumnPos >= 0) {
                    UnicodeViewer.this.insertSelectedTableItemIntoEditor();
                }
                if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                    if (e.keyCode != 0x1000004 || UnicodeViewer.this.tableCursor.getColumn() + 1 <= currentColumns) {
                        UnicodeViewer.this.selectedTableItem = UnicodeViewer.this.tableCursor.getRow();
                        UnicodeViewer.this.selectedItemColumnPos = UnicodeViewer.this.tableCursor.getColumn();
                    }
                    UnicodeViewer.this.processCharacterSelection(UnicodeViewer.this.tableCursor, UnicodeViewer.this.selectedTableItem, UnicodeViewer.this.selectedItemColumnPos);
                }
            }
        });
        this.tableCursor.setForeground(Display.getCurrent().getSystemColor(2));
        this.tableCursor.setBackground(Display.getCurrent().getSystemColor(26));
        int i = 0;
        while (i < this.columns) {
            TableColumn col = new TableColumn(this.table, 0x1000000, 0);
            col.setWidth(40);
            ++i;
        }
        this.table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (UnicodeViewer.this.table.getHorizontalBar().isVisible()) {
                    UnicodeViewer.this.table.getHorizontalBar().setVisible(false);
                }
                int viewPanelWidth = ((UnicodeViewer)UnicodeViewer.this).parentComposite.getSize().x;
                int optimalNumberOfColumns = Math.min((viewPanelWidth - 81) / 40 + 1, 16);
                if (currentColumns != optimalNumberOfColumns) {
                    if (UnicodeViewer.this.currentIsCustom) {
                        UnicodeViewer.this.chars = new UnicodeModel(optimalNumberOfColumns, UnicodeViewer.this.currentCustomChars);
                    } else {
                        UnicodeViewer.this.chars = new UnicodeModel(UnicodeViewer.this.currentUnicodeSet, UnicodeViewer.this.currentSetIsBlock, optimalNumberOfColumns);
                    }
                    currentColumns = optimalNumberOfColumns;
                    UnicodeViewer.this.tableViewer.setInput((Object)UnicodeViewer.this.chars);
                }
            }
        });
        this.table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) != 0) {
                    int width;
                    GC gc = event.gc;
                    Rectangle area = UnicodeViewer.this.table.getClientArea();
                    int columnCount = UnicodeViewer.this.table.getColumnCount();
                    if ((event.index == columnCount - 1 || columnCount == 0) && (width = area.x + area.width - event.x) > 0) {
                        Region region = new Region();
                        gc.getClipping(region);
                        region.add(event.x, event.y, width, event.height);
                        gc.setClipping(region);
                        region.dispose();
                    }
                    gc.setAdvanced(true);
                    if (gc.getAdvanced()) {
                        gc.setAlpha(127);
                    }
                    Rectangle rect = event.getBounds();
                    Color foreground = gc.getForeground();
                    Color background = gc.getBackground();
                    gc.setForeground(UnicodeViewer.this.table.getDisplay().getSystemColor(33));
                    gc.setBackground(UnicodeViewer.this.table.getDisplay().getSystemColor(25));
                    gc.fillGradientRectangle(0, rect.y, 500, rect.height, false);
                    gc.setForeground(foreground);
                    gc.setBackground(background);
                    event.detail &= 0xFFFFFFFD;
                }
            }
        });
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = UnicodeViewer.this.table.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = UnicodeViewer.this.table.getTopIndex();
                while (index < UnicodeViewer.this.table.getItemCount()) {
                    boolean visible = false;
                    TableItem item = UnicodeViewer.this.table.getItem(index);
                    int selectedItemColumn = 0;
                    while (selectedItemColumn < UnicodeViewer.this.table.getColumnCount()) {
                        Rectangle rect = item.getBounds(selectedItemColumn);
                        if (rect.contains(pt)) {
                            UnicodeViewer.this.processCharacterSelection(UnicodeViewer.this.tableCursor, item, selectedItemColumn);
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++selectedItemColumn;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
        DragSourceListener dsl = new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                event.data = UnicodeViewer.this.selectedTableItem.getText(UnicodeViewer.this.selectedItemColumnPos);
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = UnicodeViewer.this.selectedTableItem.getText(UnicodeViewer.this.selectedItemColumnPos);
            }

            public void dragFinished(DragSourceEvent event) {
                UnicodeViewer.this.saveMruListItem(UnicodeViewer.this.selectedTableItem.getText(UnicodeViewer.this.selectedItemColumnPos));
            }
        };
        DragSource dragSourceTable = new DragSource((Control)this.table, 1);
        dragSourceTable.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSourceTable.addDragListener(dsl);
        DragSource dragSourceCursor = new DragSource((Control)this.tableCursor, 1);
        dragSourceCursor.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSourceCursor.addDragListener(dsl);
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
    }

    private void createInsertButton(Composite parent) {
        this.insertButton = new Button(parent, 8);
        FormData formDataInsertButton = new FormData();
        formDataInsertButton.right = new FormAttachment(100, -7);
        formDataInsertButton.bottom = new FormAttachment(100, -7);
        this.insertButton.setLayoutData((Object)formDataInsertButton);
        this.insertButton.setText(Messages.UnicodeViewer_5);
        this.insertButton.setToolTipText(Messages.UnicodeViewer_6);
        this.insertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UnicodeViewer.this.selectedTableItem != null && UnicodeViewer.this.selectedItemColumnPos >= 0) {
                    UnicodeViewer.this.insertSelectedTableItemIntoEditor();
                }
            }
        });
    }

    private void createMruButton(Composite parent) {
        this.mruButton = new Button(parent, 8);
        FormData formDataMruButton = new FormData();
        formDataMruButton.left = new FormAttachment(0, 7);
        formDataMruButton.bottom = new FormAttachment(100, -7);
        this.mruButton.moveAbove((Control)this.insertButton);
        this.mruButton.setLayoutData((Object)formDataMruButton);
        this.mruButton.setText(Messages.UnicodeViewer_7);
        this.mruButton.setToolTipText(Messages.UnicodeViewer_8);
        this.mruButton.setEnabled(true);
        this.menuMruList = new Menu((Control)parent);
        String[] mruStringList = Activator.getDefault().getPreferenceStore().getString("MruStringListEntries").split(",");
        this.mruItemsMap = new LinkedHashMap(10, 0.75f, true);
        String[] stringArray = mruStringList;
        int n = mruStringList.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String symbol = entry.split("#")[0];
            Long time = entry.split("#").length > 1 ? Long.parseLong(entry.split("#")[1]) : System.currentTimeMillis();
            this.mruItemsMap.put(symbol, time);
            ++n2;
        }
        this.fillMruMenuItems();
        this.mruButton.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                UnicodeViewer.this.menuMruList.setLocation(Display.getCurrent().getCursorLocation());
                UnicodeViewer.this.menuMruList.setVisible(true);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void fillMruMenuItems() {
        this.menuMruList = new Menu((Control)this.menuMruList.getParent());
        MenuItem menuItemMruHeader = new MenuItem(this.menuMruList, 0);
        menuItemMruHeader.setText(Messages.UnicodeViewer_17);
        menuItemMruHeader.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UnicodeViewer.this.clearMruListItem();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new MenuItem(this.menuMruList, 2);
        Object[] objectArray = this.mruItemsMap.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String mruEntry;
            Object valueObject = objectArray[n2];
            if (valueObject instanceof String && (mruEntry = (String)valueObject).length() > 0) {
                MenuItem menuItemMruEntry = new MenuItem(this.menuMruList, 0, 2);
                menuItemMruEntry.setText(mruEntry);
                menuItemMruEntry.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        UnicodeViewer.this.insertStringIntoEditor(mruEntry);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            ++n2;
        }
        this.mruButton.setMenu(this.menuMruList);
    }

    private void saveMruListItem(String mruListItem) {
        String storeMruContent = "";
        Object[] objectArray = this.mruItemsMap.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String mruEntry;
            Object valueObject = objectArray[n2];
            if (valueObject instanceof String && (mruEntry = (String)valueObject).length() > 0) {
                storeMruContent = String.valueOf(storeMruContent) + mruEntry + "#" + this.mruItemsMap.get(mruEntry) + ",";
                this.mruItemsMap.put(mruEntry, System.currentTimeMillis());
            }
            ++n2;
        }
        if (!this.mruItemsMap.containsKey(mruListItem)) {
            this.mruItemsMap.put(mruListItem, System.currentTimeMillis());
        } else {
            this.mruItemsMap.remove(mruListItem);
            this.mruItemsMap.put(mruListItem, System.currentTimeMillis());
        }
        if (this.mruItemsMap.size() > 10) {
            Long smallestSoFar = System.currentTimeMillis();
            Object[] objectArray2 = this.mruItemsMap.values().toArray();
            int n3 = objectArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Object obj = objectArray2[n4];
                if (obj instanceof Long) {
                    Long iter = (Long)obj;
                    if (smallestSoFar > iter) {
                        smallestSoFar = iter;
                    }
                }
                ++n4;
            }
            for (Map.Entry<String, Long> nextEntry : this.mruItemsMap.entrySet()) {
                if (nextEntry.getValue().compareTo(smallestSoFar) != 0) continue;
                this.mruItemsMap.remove(nextEntry.getKey());
                break;
            }
        }
        this.fillMruMenuItems();
        Activator.getDefault().getPreferenceStore().putValue("MruStringListEntries", storeMruContent);
    }

    private void clearMruListItem() {
        Activator.getDefault().getPreferenceStore().setValue("MruStringListEntries", "");
        this.mruItemsMap.clear();
        this.fillMruMenuItems();
    }

    private void processCharacterSelection(TableCursor cursor, TableItem item, int selectedItemColumn) {
        if (item.getText(selectedItemColumn).length() > 0) {
            String uCharDef;
            char[] cs = item.getText(selectedItemColumn).toCharArray();
            char selectedCharacter = item.getText(selectedItemColumn).charAt(0);
            if (cs.length == 1) {
                String postfix = String.valueOf(Integer.toHexString(selectedCharacter)) + "(" + selectedCharacter + ")";
                uCharDef = selectedCharacter < '\u0010' ? "U+000" + postfix : (selectedCharacter < '\u0100' ? "U+00" + postfix : (selectedCharacter < '\u1000' ? "U+0" + postfix : "U+" + postfix));
            } else {
                cs[0] = item.getText(selectedItemColumn).charAt(0);
                cs[1] = item.getText(selectedItemColumn).charAt(1);
                uCharDef = "U+" + Integer.toHexString(Character.toCodePoint(cs[0], cs[1])) + Messages.UnicodeViewer_35 + Integer.toHexString(cs[0]) + Messages.UnicodeViewer_36 + Integer.toHexString(cs[1]);
            }
            this.table.showSelection();
            this.updateSelectionLabels(cursor, item, selectedItemColumn, uCharDef, selectedCharacter);
        }
    }

    private void updateSelectionLabels(TableCursor cursor, TableItem item, int selectedItemColumn, String uCharDef, int selectedCharacter) {
        String unicodeCharId = uCharDef.substring(2, Math.max(6, Math.max(uCharDef.indexOf(" "), uCharDef.indexOf("(")))).toUpperCase();
        String unicodeName = UCharacter.getExtendedName((int)selectedCharacter);
        if (unicodeName.contains("surrogate")) {
            unicodeName = UnicodeSymbolResourceReader.getMusicalSymbolsHashtable().get(unicodeCharId);
        }
        int windowWidth = this.getTable().getParent().getSize().x;
        if (unicodeName.length() > windowWidth / 12) {
            String labelNameHalves = String.valueOf(unicodeName.substring(0, windowWidth / 24)) + "..." + unicodeName.substring(unicodeName.length() - windowWidth / 24);
            this.labelDescription.setText(labelNameHalves);
        } else {
            this.labelDescription.setText(unicodeName);
        }
        this.labelDescription.setToolTipText(String.valueOf(Messages.UnicodeViewer_41) + unicodeName);
        this.labelUnicode.setText(unicodeCharId);
        this.labelUnicode.setToolTipText(String.valueOf(Messages.UnicodeViewer_42) + uCharDef + Messages.UnicodeViewer_43 + selectedCharacter);
        this.labelPreview.setText(item.getText(selectedItemColumn));
        this.labelPreview.setToolTipText(unicodeName);
        this.table.showItem(item);
        cursor.setSelection(item, selectedItemColumn);
        cursor.setVisible(true);
        cursor.setFocus();
        cursor.setToolTipText(unicodeName);
        this.selectedTableItem = item;
        this.selectedItemColumnPos = selectedItemColumn;
    }

    private void setupControls(Composite parent) {
        this.chars.updateModel(this.currentUnicodeSet);
    }

    private void createLabel(Composite parent) {
        this.labelPreview = new Label(parent, 0);
        this.labelPreview.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(Display.getCurrent().getSystemColor(16));
                gc.drawRectangle(((UnicodeViewer)UnicodeViewer.this).labelPreviewDrawingRectangle.x, ((UnicodeViewer)UnicodeViewer.this).labelPreviewDrawingRectangle.y, 74, 84);
            }
        });
        FormData formDataLabelPreview = new FormData();
        FormData formDataLabelUnicode = new FormData();
        FormData formDataLabelDescription = new FormData();
        formDataLabelUnicode.right = new FormAttachment((Control)this.labelUnicode, 50, 131072);
        formDataLabelPreview.left = new FormAttachment(0, 9);
        formDataLabelPreview.bottom = new FormAttachment(100, -47);
        formDataLabelPreview.width = 75;
        formDataLabelPreview.height = 85;
        this.labelPreview.setAlignment(0x1000000);
        this.labelPreview.setLayoutData((Object)formDataLabelPreview);
        this.labelPreview.setFont(new Font(null, this.currentFontName, 44, 0));
        this.labelPreview.setBackground(Display.getCurrent().getSystemColor(25));
        this.labelNameUnicode = new Label(parent, 0);
        FormData formDataLabelNameUnicode = new FormData();
        formDataLabelNameUnicode.right = new FormAttachment(0, 440);
        formDataLabelNameUnicode.left = new FormAttachment((Control)this.labelPreview, 82, 16384);
        formDataLabelNameUnicode.bottom = new FormAttachment(100, -120);
        this.labelNameUnicode.setLayoutData((Object)formDataLabelNameUnicode);
        this.labelNameUnicode.setText(Messages.UnicodeViewer_46);
        this.labelUnicode = new Label(parent, 0);
        formDataLabelUnicode.right = new FormAttachment(0, 440);
        formDataLabelUnicode.left = new FormAttachment((Control)this.labelPreview, 82, 16384);
        formDataLabelUnicode.bottom = new FormAttachment(100, -100);
        this.labelUnicode.setLayoutData((Object)formDataLabelUnicode);
        this.labelUnicode.setText("");
        this.labelNameDescription = new Label(parent, 0);
        FormData formDataLabelNameDescription = new FormData();
        formDataLabelNameDescription.right = new FormAttachment(0, 440);
        formDataLabelNameDescription.left = new FormAttachment((Control)this.labelPreview, 82, 16384);
        formDataLabelNameDescription.bottom = new FormAttachment(100, -67);
        this.labelNameDescription.setLayoutData((Object)formDataLabelNameDescription);
        this.labelNameDescription.setText(Messages.UnicodeViewer_48);
        this.labelDescription = new Label(parent, 0);
        formDataLabelUnicode.right = new FormAttachment(0, 440);
        formDataLabelDescription.left = new FormAttachment((Control)this.labelPreview, 82, 16384);
        formDataLabelDescription.bottom = new FormAttachment(100, -47);
        formDataLabelDescription.width = 300;
        this.labelDescription.setLayoutData((Object)formDataLabelDescription);
        this.labelDescription.setText("");
    }

    private void loadSelectedFont() {
        try {
            if (Activator.getDefault() instanceof Plugin) {
                Activator plugin = Activator.getDefault();
                String path = plugin.getStateLocation().toPortableString();
                String resourceDir = "Resources";
                String resourceFile = "MusicalSymbolsTextGrid.ttf";
                StreamWriterUtils.writeResourceToTempFile(path, resourceDir, resourceFile);
                if (!Display.getCurrent().loadFont(String.valueOf(path) + "/" + resourceFile)) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.xmleditor.multicharbrowser", "Could not load our font -- we didn't get an Exception, though ..."));
                }
            }
        }
        catch (Exception ex) {
            StreamWriterUtils.writeLogError(4, "Could not resolve internal resource {0} in {1}\nThis is probably a bug, please file a bug report.", ex);
        }
    }

    private Font getFont(FontType type) {
        String fontKey;
        if (this.fontRegistry == null) {
            this.fontRegistry = new FontRegistry(this.getControl().getDisplay(), true);
        }
        if (!this.fontRegistry.hasValueFor(fontKey = (Object)((Object)type) + "." + this.currentFontName)) {
            FontData fontData = type.getFontData(this.currentFontName);
            this.fontRegistry.put(fontKey, new FontData[]{fontData});
        }
        return this.fontRegistry.get(fontKey);
    }

    private void loadCurrentSelectedFont() {
        this.table.setFont(this.getFont(FontType.TABLE));
        this.tableCursor.setFont(this.getFont(FontType.CURSOR));
        this.labelPreview.setFont(this.getFont(FontType.PREVIEW));
        this.table.redraw();
        this.tableCursor.redraw();
        this.labelPreview.redraw();
        StatusManager.getManager().handle((IStatus)new Status(1, "info.textgrid.lab.xmleditor.multicharbrowser", MessageFormat.format("Set font {0} (and caused a redraw)", this.currentFontName)));
    }

    private void run(Shell shell) {
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void changeViewerCharset(String newCharSet, boolean isBlock) {
        this.loadCurrentSelectedFont();
        this.currentUnicodeSet = newCharSet;
        this.currentSetIsBlock = isBlock;
        this.currentIsCustom = false;
        this.tableViewer.setInput((Object)this.chars);
        this.setupControls(this.parentComposite);
        this.table.getHorizontalBar().setVisible(false);
        int viewPanelWidth = this.parentComposite.getSize().x;
        int optimalNumberOfColumns = Math.min((viewPanelWidth - 81) / 40 + 1, 16);
        this.chars = new UnicodeModel(this.currentUnicodeSet, this.currentSetIsBlock, optimalNumberOfColumns);
        this.tableViewer.setInput((Object)this.chars);
        currentColumns = optimalNumberOfColumns;
    }

    public void changeViewerCharset(String[] customChars) {
        this.loadCurrentSelectedFont();
        this.currentIsCustom = true;
        this.currentCustomChars = customChars;
        this.tableViewer.setInput((Object)this.chars);
        this.setupControls(this.parentComposite);
        this.table.getHorizontalBar().setVisible(false);
        int viewPanelWidth = this.parentComposite.getSize().x;
        int optimalNumberOfColumns = Math.min((viewPanelWidth - 81) / 40 + 1, 16);
        this.chars = new UnicodeModel(optimalNumberOfColumns, customChars);
        this.tableViewer.setInput((Object)this.chars);
        currentColumns = optimalNumberOfColumns;
    }

    public void setCurrentFontName(String currentFontName) {
        if (currentFontName != null) {
            this.currentFontName = currentFontName;
        }
        if (this.tableViewer != null && !this.tableViewer.getTable().isDisposed()) {
            this.loadCurrentSelectedFont();
            this.tableViewer.refresh(true);
        }
        if (this.labelPreview != null && !this.labelPreview.isDisposed()) {
            this.labelPreview.redraw();
        }
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public Table getTable() {
        return this.table;
    }

    public Control getControl() {
        return this.table.getParent();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public Button getInsertButton() {
        return this.insertButton;
    }

    public void close() {
        Shell shell = this.table.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
    }

    public void dispose() {
        currentColumns = -1;
        this.tableViewer.getLabelProvider().dispose();
    }

    public boolean insertSelectedTableItemIntoEditor() {
        boolean result = unicodeView.insertIntoEditor(this.selectedTableItem, this.selectedItemColumnPos);
        this.saveMruListItem(this.selectedTableItem.getText(this.selectedItemColumnPos));
        return result;
    }

    public boolean insertStringIntoEditor(String insertString) {
        boolean result = unicodeView.insertIntoEditor(insertString);
        this.saveMruListItem(insertString);
        return result;
    }

    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setText(Messages.UnicodeViewer_50);
        Composite composite = new Composite((Composite)shell, 0);
        UnicodeViewer unicodeViewer = new UnicodeViewer(composite, new UnicodeView());
        unicodeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UnicodeViewer.this.dispose();
            }
        });
        shell.open();
        unicodeViewer.run(shell);
    }

    public UnicodeViewer(Composite parent, UnicodeView unicodeview) {
        unicodeView = unicodeview;
        this.parentComposite = parent;
        this.addChildControls(parent);
    }

    private static enum FontType {
        TABLE(18, 12, 0),
        CURSOR(18, 12, 1),
        PREVIEW(44, 36, 0);

        private int height;
        private int winHeight;
        private int style;

        private FontType(int height, int winHeight, int style) {
            this.height = height;
            this.winHeight = winHeight;
            this.style = style;
        }

        public FontData getFontData(String name) {
            return new FontData(name, "win32".equals(Platform.getOS()) ? this.winHeight : this.height, this.style);
        }
    }

    public class ViewContentProvider
    implements IStructuredContentProvider,
    IModelViewer {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((UnicodeModel)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((UnicodeModel)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return UnicodeViewer.this.chars.getChars().toArray();
        }

        @Override
        public void updateModel(int start, int end) {
            UnicodeViewer.this.chars = new UnicodeModel(start, end);
            UnicodeViewer.this.tableViewer.setInput((Object)UnicodeViewer.this.chars);
        }

        @Override
        public void updateScript(String name) {
            UnicodeViewer.this.chars = new UnicodeModel(name, UnicodeViewer.this.currentSetIsBlock, 16);
            UnicodeViewer.this.tableViewer.setInput((Object)UnicodeViewer.this.chars);
        }

        @Override
        public void updateFont(String fontName) {
        }
    }
}

