/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.feedback.ui.bugreport2;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import info.textgrid.lab.feedback.ui.bugreport2.BasicReportPage;
import info.textgrid.lab.feedback.ui.bugreport2.BugDataPage;
import info.textgrid.lab.feedback.ui.bugreport2.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ConfigurationInfo;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class BugReportWizard
extends Wizard {
    private static final String BUGHANDLER_URL = "http://dev.digital-humanities.de/cgi-bin/bughandler.py";
    private BasicReportPage basicPage;
    private BugDataPage dataPage;
    private volatile String systemSummary;
    private String systemLog;
    private WizardDialog dialog;

    public BugReportWizard() {
        this.setWindowTitle(Messages.BugReportWizard_WindowTitle);
    }

    public void addPages() {
        this.basicPage = new BasicReportPage();
        this.dataPage = new BugDataPage();
        this.addPage((IWizardPage)this.basicPage);
        this.addPage((IWizardPage)this.dataPage);
    }

    public boolean performFinish() {
        final String subject = this.basicPage.subjectText.getText();
        final String description = this.basicPage.descriptionText.getText();
        final String name = this.basicPage.name.getText();
        final String mail = this.basicPage.mail.getText();
        final String eppn = this.basicPage.eppn.getText();
        try {
            final File config = this.dataPage.getTempConfFile();
            final File log = this.dataPage.getTempLogFile();
            this.dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.BugReportWizard_PostingProgress, (int)30);
                    if (progress.isCanceled()) {
                        return;
                    }
                    ArrayList parts = Lists.newArrayList();
                    parts.add(new StringPart("subject", subject, "UTF-8"));
                    parts.add(new StringPart("description", description, "UTF-8"));
                    parts.add(new StringPart("name", name, "UTF-8"));
                    parts.add(new StringPart("mail", mail, "UTF-8"));
                    parts.add(new StringPart("eppn", eppn, "UTF-8"));
                    progress.worked(5);
                    if (progress.isCanceled()) {
                        return;
                    }
                    try {
                        if (config != null) {
                            parts.add(new FilePart("config", config, "text/plain", "UTF-8"));
                        }
                        if (log != null) {
                            parts.add(new FilePart("log", log, "text/plain", "UTF-8"));
                        }
                        for (File attachment : BugReportWizard.this.dataPage.getFiles()) {
                            parts.add(new FilePart("attach", attachment));
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new InvocationTargetException(e);
                    }
                    progress.worked(5);
                    if (progress.isCanceled()) {
                        return;
                    }
                    PostMethod post = new PostMethod(BugReportWizard.BUGHANDLER_URL);
                    post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[0]), post.getParams()));
                    HttpClient client = new HttpClient();
                    progress.worked(5);
                    if (progress.isCanceled()) {
                        return;
                    }
                    try {
                        client.executeMethod((HttpMethod)post);
                        System.out.println(post.getResponseBodyAsString());
                        progress.worked(15);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.feedback.ui", String.valueOf(Messages.BugReportWizard_TempFileError) + e.getLocalizedMessage(), (Throwable)e));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void show(Shell shell) {
        this.dialog = new WizardDialog(shell == null ? this.getShell() : shell, (IWizard)this);
        this.dialog.setBlockOnOpen(false);
        this.dialog.create();
        this.dialog.open();
        Job job = new Job(Messages.BugReportWizard_CollectingData){

            protected IStatus run(IProgressMonitor monitor) {
                IPath logFileLocation = Platform.getLogFileLocation();
                try {
                    BugReportWizard.this.systemLog = Files.toString((File)logFileLocation.toFile(), (Charset)Charset.defaultCharset());
                }
                catch (IOException e) {
                    BugReportWizard.this.systemLog = e.toString();
                }
                BugReportWizard.this.systemSummary = ConfigurationInfo.getSystemSummary();
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    UIJob uiJob = new UIJob(""){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (BugReportWizard.this.systemSummary != null && BugReportWizard.this.dataPage != null && !BugReportWizard.this.dataPage.getControl().isDisposed()) {
                                BugReportWizard.this.dataPage.setSummary(BugReportWizard.this.systemSummary, BugReportWizard.this.systemLog);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.setSystem(true);
                    uiJob.schedule();
                }
            }
        });
        job.schedule();
    }
}

