/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SchemaURIResolver;

public class PipelineConfiguration {
    private Configuration config;
    private LocationProvider locationProvider;
    private URIResolver uriResolver;
    private SchemaURIResolver schemaURIResolver;
    private Controller controller;
    private ParseOptions parseOptions;
    private boolean isSerializing;
    private int hostLanguage = 50;
    private Map<String, Object> components;

    public PipelineConfiguration(Configuration config) {
        this.config = config;
        this.parseOptions = new ParseOptions();
    }

    public PipelineConfiguration(PipelineConfiguration p) {
        this.config = p.config;
        this.locationProvider = p.locationProvider;
        this.uriResolver = p.uriResolver;
        this.schemaURIResolver = p.schemaURIResolver;
        this.controller = p.controller;
        this.isSerializing = p.isSerializing;
        this.parseOptions = new ParseOptions(p.parseOptions);
        this.hostLanguage = p.hostLanguage;
        if (p.components != null) {
            this.components = new HashMap<String, Object>(p.components);
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public LocationProvider getLocationProvider() {
        return this.locationProvider;
    }

    public void setLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    public SourceLocator getSourceLocation(long locationId) {
        return new ExpressionLocation(this.locationProvider, locationId);
    }

    public ErrorListener getLocalErrorListener() {
        return this.parseOptions.getErrorListener();
    }

    public ErrorListener getErrorListener() {
        ErrorListener listener = this.parseOptions.getErrorListener();
        if (listener == null) {
            listener = this.config.getErrorListener();
        }
        return listener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.parseOptions.setErrorListener(errorListener);
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public void setParseOptions(ParseOptions options) {
        this.parseOptions = options;
    }

    public ParseOptions getParseOptions() {
        return this.parseOptions;
    }

    public void setUseXsiSchemaLocation(boolean recognize) {
        this.parseOptions.setUseXsiSchemaLocation(recognize);
    }

    public void setRecoverFromValidationErrors(boolean recover) {
        this.parseOptions.setContinueAfterValidationErrors(recover);
    }

    public boolean isRecoverFromValidationErrors() {
        return this.parseOptions.isContinueAfterValidationErrors();
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int language) {
        this.hostLanguage = language;
    }

    public boolean isSerializing() {
        return this.isSerializing;
    }

    public void setSerializing(boolean isSerializing) {
        this.isSerializing = isSerializing;
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.parseOptions.setExpandAttributeDefaults(expand);
    }

    public boolean isExpandAttributeDefaults() {
        return this.parseOptions.isExpandAttributeDefaults();
    }

    public void setComponent(String name, Object value) {
        if (this.components == null) {
            this.components = new HashMap<String, Object>();
        }
        this.components.put(name, value);
    }

    public Object getComponent(String name) {
        if (this.components == null) {
            return null;
        }
        return this.components.get(name);
    }
}

