/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.parser.ExpressionParser;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.Id;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternMaker;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.pattern.PatternWithPredicate;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.DecimalValue;

public class PatternParser
extends ExpressionParser {
    int inPredicate = 0;

    public Pattern parsePattern(String pattern, StaticContext env) throws XPathException {
        this.env = env;
        this.nameChecker = env.getConfiguration().getNameChecker();
        this.language = 1;
        Expression exp = this.parse(pattern, 0, 0, env.getLineNumber(), env);
        exp.setContainer(this.defaultContainer);
        ExpressionVisitor visitor = ExpressionVisitor.make(env, exp.getExecutable());
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(AnyItemType.getInstance(), true);
        boolean is30 = env.getXPathLanguageLevel().equals(DecimalValue.THREE);
        return PatternMaker.fromExpression(exp.simplify(visitor).typeCheck(visitor, cit), env.getConfiguration(), is30);
    }

    protected void customizeTokenizer(Tokenizer t) {
        if (!this.env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
            t.disallowUnionKeyword = true;
        }
    }

    public Expression parseExpression() throws XPathException {
        if (this.inPredicate > 0) {
            return super.parseExpression();
        }
        return this.parseBinaryExpression(this.parsePathExpression(), 10);
    }

    protected Expression parseBasicStep(boolean firstInPattern) throws XPathException {
        if (this.inPredicate > 0) {
            return super.parseBasicStep(firstInPattern);
        }
        switch (this.t.currentToken) {
            case 21: {
                if (!this.env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
                    this.grumble("A variable reference is not allowed in an XSLT pattern (except in a predicate)");
                    return null;
                }
                if (!firstInPattern) {
                    this.grumble("In an XSLT 3.0 pattern, a variable reference is allowed only as the first step in a path");
                    return null;
                }
                return super.parseBasicStep(firstInPattern);
            }
            case 5: {
                if (!this.env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
                    this.grumble("Parentheses are not allowed in an XSLT 2.0 pattern");
                    return null;
                }
                return super.parseBasicStep(firstInPattern);
            }
            case 43: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 202: 
            case 209: 
            case 217: {
                this.grumble("Token " + this.currentTokenDisplay() + " not allowed here in an XSLT pattern");
                return null;
            }
            case 35: {
                if (!firstInPattern) {
                    this.grumble("In an XSLT pattern, a function call is allowed only as the first step in a path");
                }
                return super.parseBasicStep(firstInPattern);
            }
        }
        return super.parseBasicStep(firstInPattern);
    }

    protected Expression parseTypePattern() throws XPathException {
        if (!this.env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
            this.grumble("Type patterns (~ItemType) require XSLT 3.0 to be enabled");
        }
        this.nextToken();
        ItemType type = this.parseItemType();
        Pattern pattern = new ItemTypePattern(type);
        Expression predicate = null;
        while (this.t.currentToken == 4) {
            this.nextToken();
            Expression e = this.parsePredicate();
            predicate = predicate == null ? e : new AndExpression(predicate, e);
            this.expect(203);
            this.nextToken();
        }
        if (predicate != null) {
            pattern = new PatternWithPredicate(pattern, predicate);
        }
        return new PatternSponsor(pattern);
    }

    protected Expression parsePredicate() throws XPathException {
        ++this.inPredicate;
        Expression exp = this.parseExpression();
        --this.inPredicate;
        return exp;
    }

    protected Expression parseFunctionCall() throws XPathException {
        Expression fn = super.parseFunctionCall();
        if (this.inPredicate > 0) {
            return fn;
        }
        if (fn instanceof Id) {
            if (!this.env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
                if (((Id)fn).getNumberOfArguments() != 1) {
                    this.grumble("id() in an XSLT 2.0 pattern must have only one argument");
                } else {
                    Expression arg = ((Id)fn).getArguments()[0];
                    if (!(arg instanceof VariableReference) && !(arg instanceof StringLiteral)) {
                        this.grumble("Argument to id() in a pattern must be a variable reference or string literal");
                    }
                }
            }
        } else if (fn instanceof KeyFn) {
            if (!this.env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
                if (((KeyFn)fn).getNumberOfArguments() != 2) {
                    this.grumble("key() in an XSLT 2.0 pattern must have exactly two arguments");
                } else {
                    Expression arg1;
                    Expression arg0 = ((KeyFn)fn).getArguments()[0];
                    if (!(arg0 instanceof StringLiteral)) {
                        this.grumble("First argument to key() in an XSLT 2.0 pattern must be a string literal");
                    }
                    if (!((arg1 = ((KeyFn)fn).getArguments()[1]) instanceof VariableReference) && !(arg1 instanceof Literal)) {
                        this.grumble("Second argument to id() in an XSLT 2.0 pattern must be a variable reference or literal");
                    }
                }
            }
        } else if (fn instanceof Doc) {
            if (!this.env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
                this.grumble("The doc() function is not allowed in an XSLT 2.0 pattern");
            }
        } else {
            this.grumble("The " + fn.toString() + " function is not allowed at the head of a pattern");
        }
        return fn;
    }

    public Expression parseFunctionArgument() throws XPathException {
        if (this.inPredicate > 0) {
            return super.parseFunctionArgument();
        }
        switch (this.t.currentToken) {
            case 21: {
                return this.parseVariableReference();
            }
            case 202: {
                return this.parseStringLiteral();
            }
            case 209: {
                return this.parseNumericLiteral();
            }
        }
        this.grumble("A function argument in an XSLT pattern must be a variable reference or literal");
        return null;
    }

    public Expression makeTracer(int startOffset, Expression exp, int construct, StructuredQName qName) {
        return exp;
    }
}

