/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.math.BigDecimal;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.YearMonthDurationValue;

public abstract class Converter {
    public static final StringConverter.IdentityConverter IDENTITY_CONVERTER = new StringConverter.IdentityConverter();
    public static final ToUntypedAtomicConverter TO_UNTYPED_ATOMIC = new ToUntypedAtomicConverter();
    public static final ToStringConverter TO_STRING = new ToStringConverter();
    public static final NumericToFloat NUMERIC_TO_FLOAT = new NumericToFloat();
    public static final BooleanToFloat BOOLEAN_TO_FLOAT = new BooleanToFloat();
    public static final NumericToDouble NUMERIC_TO_DOUBLE = new NumericToDouble();
    public static final BooleanToDouble BOOLEAN_TO_DOUBLE = new BooleanToDouble();
    public static final DoubleToDecimal DOUBLE_TO_DECIMAL = new DoubleToDecimal();
    public static final FloatToDecimal FLOAT_TO_DECIMAL = new FloatToDecimal();
    public static final IntegerToDecimal INTEGER_TO_DECIMAL = new IntegerToDecimal();
    public static final NumericToDecimal NUMERIC_TO_DECIMAL = new NumericToDecimal();
    public static final BooleanToDecimal BOOLEAN_TO_DECIMAL = new BooleanToDecimal();
    public static final DoubleToInteger DOUBLE_TO_INTEGER = new DoubleToInteger();
    public static final FloatToInteger FLOAT_TO_INTEGER = new FloatToInteger();
    public static final DecimalToInteger DECIMAL_TO_INTEGER = new DecimalToInteger();
    public static final NumericToInteger NUMERIC_TO_INTEGER = new NumericToInteger();
    public static final BooleanToInteger BOOLEAN_TO_INTEGER = new BooleanToInteger();
    public static final DurationToDayTimeDuration DURATION_TO_DAY_TIME_DURATION = new DurationToDayTimeDuration();
    public static final DurationToYearMonthDuration DURATION_TO_YEAR_MONTH_DURATION = new DurationToYearMonthDuration();
    public static final DateToDateTime DATE_TO_DATE_TIME = new DateToDateTime();
    public static final DateTimeToDate DATE_TIME_TO_DATE = new DateTimeToDate();
    public static final DateTimeToGMonth DATE_TIME_TO_G_MONTH = new DateTimeToGMonth();
    public static final DateTimeToGYearMonth DATE_TIME_TO_G_YEAR_MONTH = new DateTimeToGYearMonth();
    public static final DateTimeToGYear DATE_TIME_TO_G_YEAR = new DateTimeToGYear();
    public static final DateTimeToGMonthDay DATE_TIME_TO_G_MONTH_DAY = new DateTimeToGMonthDay();
    public static final DateTimeToGDay DATE_TIME_TO_G_DAY = new DateTimeToGDay();
    public static final DateTimeToTime DATE_TIME_TO_TIME = new DateTimeToTime();
    public static final NumericToBoolean NUMERIC_TO_BOOLEAN = new NumericToBoolean();
    public static final Base64BinaryToHexBinary BASE64_BINARY_TO_HEX_BINARY = new Base64BinaryToHexBinary();
    public static final HexBinaryToBase64Binary HEX_BINARY_TO_BASE64_BINARY = new HexBinaryToBase64Binary();
    public static final NotationToQName NOTATION_TO_QNAME = new NotationToQName();
    public static final QNameToNotation QNAME_TO_NOTATION = new QNameToNotation();
    private ConversionRules conversionRules;

    public static AtomicValue convert(AtomicValue value, AtomicType targetType, ConversionRules rules) throws ValidationException {
        Converter converter = rules.getConverter(value.getPrimitiveType(), targetType);
        if (converter == null) {
            ValidationException ve = new ValidationException("Cannot convert value from " + value.getPrimitiveType() + " to " + targetType);
            ve.setErrorCode("FORG0001");
            throw ve;
        }
        return converter.convert(value).asAtomic();
    }

    public static Converter getConverter(AtomicType sourceType, AtomicType targetType, ConversionRules rules) {
        if (sourceType == targetType) {
            return StringConverter.IdentityConverter.THE_INSTANCE;
        }
        int tt = targetType.getFingerprint();
        int tp = targetType.getPrimitiveType();
        int st = sourceType.getPrimitiveType();
        if (!(st != 513 && st != 631 || tp != 513 && tp != 631)) {
            return StringConverter.getStringConverter(targetType, rules);
        }
        if (!targetType.isPrimitiveType()) {
            AtomicType primTarget = (AtomicType)targetType.getPrimitiveItemType();
            if (sourceType == primTarget) {
                return new DownCastingConverter(targetType, rules);
            }
            if (st == 513 || st == 631) {
                return StringConverter.getStringConverter(targetType, rules);
            }
            Converter stageOne = Converter.getConverter(sourceType, primTarget, rules);
            if (stageOne == null) {
                return null;
            }
            DownCastingConverter stageTwo = new DownCastingConverter(targetType, rules);
            return new TwoPhaseConverter(stageOne, stageTwo);
        }
        if (st == tt) {
            UpCastingConverter upcast = new UpCastingConverter((AtomicType)sourceType.getPrimitiveItemType());
            DownCastingConverter downcast = new DownCastingConverter(targetType, rules);
            return new TwoPhaseConverter(upcast, downcast);
        }
        switch (tt) {
            case 631: {
                return TO_UNTYPED_ATOMIC;
            }
            case 513: {
                return TO_STRING;
            }
            case 516: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToFloat(rules);
                    }
                    case 515: 
                    case 517: 
                    case 533: 
                    case 635: {
                        return NUMERIC_TO_FLOAT;
                    }
                    case 514: {
                        return BOOLEAN_TO_FLOAT;
                    }
                }
                return null;
            }
            case 517: 
            case 635: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToDouble(rules);
                    }
                    case 515: 
                    case 516: 
                    case 533: 
                    case 635: {
                        return NUMERIC_TO_DOUBLE;
                    }
                    case 514: {
                        return BOOLEAN_TO_DOUBLE;
                    }
                }
                return null;
            }
            case 515: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_DECIMAL;
                    }
                    case 516: {
                        return FLOAT_TO_DECIMAL;
                    }
                    case 517: {
                        return DOUBLE_TO_DECIMAL;
                    }
                    case 533: {
                        return INTEGER_TO_DECIMAL;
                    }
                    case 635: {
                        return NUMERIC_TO_DECIMAL;
                    }
                    case 514: {
                        return BOOLEAN_TO_DECIMAL;
                    }
                }
                return null;
            }
            case 533: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_INTEGER;
                    }
                    case 516: {
                        return FLOAT_TO_INTEGER;
                    }
                    case 517: {
                        return DOUBLE_TO_INTEGER;
                    }
                    case 515: {
                        return DECIMAL_TO_INTEGER;
                    }
                    case 635: {
                        return NUMERIC_TO_INTEGER;
                    }
                    case 514: {
                        return BOOLEAN_TO_INTEGER;
                    }
                }
                return null;
            }
            case 518: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_DURATION;
                    }
                    case 633: 
                    case 634: {
                        return new UpCastingConverter(BuiltInAtomicType.DURATION);
                    }
                }
                return null;
            }
            case 633: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_YEAR_MONTH_DURATION;
                    }
                    case 518: 
                    case 634: {
                        return DURATION_TO_YEAR_MONTH_DURATION;
                    }
                }
                return null;
            }
            case 634: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_DAY_TIME_DURATION;
                    }
                    case 518: 
                    case 633: {
                        return DURATION_TO_DAY_TIME_DURATION;
                    }
                }
                return null;
            }
            case 519: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToDateTime(rules);
                    }
                    case 521: {
                        return DATE_TO_DATE_TIME;
                    }
                }
                return null;
            }
            case 520: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_TIME;
                    }
                    case 519: {
                        return DATE_TIME_TO_TIME;
                    }
                }
                return null;
            }
            case 521: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToDate(rules);
                    }
                    case 519: {
                        return DATE_TIME_TO_DATE;
                    }
                }
                return null;
            }
            case 522: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToGYearMonth(rules);
                    }
                    case 521: {
                        return TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_YEAR_MONTH, rules);
                    }
                    case 519: {
                        return DATE_TIME_TO_G_YEAR_MONTH;
                    }
                }
                return null;
            }
            case 523: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToGYear(rules);
                    }
                    case 521: {
                        return TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_YEAR, rules);
                    }
                    case 519: {
                        return DATE_TIME_TO_G_YEAR;
                    }
                }
                return null;
            }
            case 524: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToGMonthDay(rules);
                    }
                    case 521: {
                        return TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_MONTH_DAY, rules);
                    }
                    case 519: {
                        return DATE_TIME_TO_G_MONTH_DAY;
                    }
                }
                return null;
            }
            case 525: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToGDayConverter(rules);
                    }
                    case 521: {
                        return TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_DAY, rules);
                    }
                    case 519: {
                        return DATE_TIME_TO_G_DAY;
                    }
                }
                return null;
            }
            case 526: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToGMonth(rules);
                    }
                    case 521: {
                        return TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_MONTH, rules);
                    }
                    case 519: {
                        return DATE_TIME_TO_G_MONTH;
                    }
                }
                return null;
            }
            case 514: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_BOOLEAN;
                    }
                    case 515: 
                    case 516: 
                    case 517: 
                    case 533: 
                    case 635: {
                        return NUMERIC_TO_BOOLEAN;
                    }
                }
                return null;
            }
            case 528: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_BASE64_BINARY;
                    }
                    case 527: {
                        return HEX_BINARY_TO_BASE64_BINARY;
                    }
                }
                return null;
            }
            case 527: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_HEX_BINARY;
                    }
                    case 528: {
                        return BASE64_BINARY_TO_HEX_BINARY;
                    }
                }
                return null;
            }
            case 529: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToAnyURI(rules);
                    }
                }
                return null;
            }
            case 530: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToQName(rules);
                    }
                    case 531: {
                        return NOTATION_TO_QNAME;
                    }
                }
                return null;
            }
            case 531: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToNotation(rules);
                    }
                    case 530: {
                        return QNAME_TO_NOTATION;
                    }
                }
                return null;
            }
            case 632: {
                return IDENTITY_CONVERTER;
            }
        }
        throw new IllegalArgumentException("Unknown primitive type " + tt);
    }

    protected Converter() {
    }

    protected Converter(ConversionRules rules) {
        this.setConversionRules(rules);
    }

    public abstract ConversionResult convert(AtomicValue var1);

    public final void setConversionRules(ConversionRules rules) {
        this.conversionRules = rules;
    }

    public final ConversionRules getConversionRules() {
        return this.conversionRules;
    }

    public boolean isXPath30Conversion() {
        return false;
    }

    public boolean isAlwaysSuccessful() {
        return false;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
    }

    public NamespaceResolver getNamespaceResolver() {
        return null;
    }

    public static class PromoterToFloat
    extends Converter {
        private StringConverter stringToFloat = null;

        public ConversionResult convert(AtomicValue input) {
            if (input instanceof FloatValue) {
                return input;
            }
            if (input instanceof DoubleValue) {
                ValidationFailure err = new ValidationFailure("Cannot promote from xs:double to xs:float");
                err.setErrorCode("XPTY0004");
                return err;
            }
            if (input instanceof NumericValue) {
                return new FloatValue((float)((NumericValue)input).getDoubleValue());
            }
            if (input instanceof UntypedAtomicValue) {
                if (this.stringToFloat == null) {
                    this.stringToFloat = StringConverter.getStringConverter(BuiltInAtomicType.FLOAT, this.getConversionRules());
                }
                return this.stringToFloat.convert(input);
            }
            ValidationFailure err = new ValidationFailure("Cannot promote non-numeric value to xs:double");
            err.setErrorCode("XPTY0004");
            return err;
        }
    }

    public static class PromoterToDouble
    extends Converter {
        private StringConverter stringToDouble = null;

        public ConversionResult convert(AtomicValue input) {
            if (input instanceof DoubleValue) {
                return input;
            }
            if (input instanceof NumericValue) {
                return new DoubleValue(((NumericValue)input).getDoubleValue());
            }
            if (input instanceof UntypedAtomicValue) {
                if (this.stringToDouble == null) {
                    this.stringToDouble = StringConverter.getStringConverter(BuiltInAtomicType.DOUBLE, this.getConversionRules());
                }
                return this.stringToDouble.convert(input);
            }
            ValidationFailure err = new ValidationFailure("Cannot promote non-numeric value to xs:double");
            err.setErrorCode("XPTY0004");
            return err;
        }
    }

    public static class QNameToNotation
    extends Converter {
        public boolean isXPath30Conversion() {
            return true;
        }

        public ConversionResult convert(AtomicValue input) {
            return new NotationValue(((QNameValue)input).getStructuredQName(), BuiltInAtomicType.NOTATION);
        }
    }

    public static class NotationToQName
    extends Converter {
        public boolean isXPath30Conversion() {
            return true;
        }

        public ConversionResult convert(AtomicValue input) {
            return new QNameValue(((NotationValue)input).getStructuredQName(), BuiltInAtomicType.QNAME);
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class HexBinaryToBase64Binary
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new Base64BinaryValue(((HexBinaryValue)input).getBinaryValue());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class StringToBase64BinaryConverter
    extends StringConverter {
        public ConversionResult convert(AtomicValue input) {
            return this.convertString(input.getStringValueCS());
        }

        public ConversionResult convertString(CharSequence input) {
            try {
                return new Base64BinaryValue(input);
            }
            catch (XPathException e) {
                return new ValidationFailure(e);
            }
        }
    }

    public static class Base64BinaryToHexBinary
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new HexBinaryValue(((Base64BinaryValue)input).getBinaryValue());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class NumericToBoolean
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            try {
                return BooleanValue.get(input.effectiveBooleanValue());
            }
            catch (XPathException err) {
                throw new AssertionError((Object)err);
            }
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToTime
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new TimeValue(dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMicrosecond(), dt.getTimezoneInMinutes());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToGDay
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new GDayValue(dt.getDay(), dt.getTimezoneInMinutes());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToGMonthDay
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new GMonthDayValue(dt.getMonth(), dt.getDay(), dt.getTimezoneInMinutes());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToGYear
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new GYearValue(dt.getYear(), dt.getTimezoneInMinutes(), dt.isXsd10Rules());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToGYearMonth
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new GYearMonthValue(dt.getYear(), dt.getMonth(), dt.getTimezoneInMinutes(), dt.isXsd10Rules());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToGMonth
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new GMonthValue(dt.getMonth(), dt.getTimezoneInMinutes());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToDate
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new DateValue(dt.getYear(), dt.getMonth(), dt.getDay(), dt.getTimezoneInMinutes(), dt.isXsd10Rules());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateToDateTime
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return ((DateValue)input).toDateTime();
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DurationToYearMonthDuration
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DurationValue d = (DurationValue)input;
            return YearMonthDurationValue.fromMonths(d.getTotalMonths());
        }
    }

    public static class DurationToDayTimeDuration
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DurationValue d = (DurationValue)input;
            return new DayTimeDurationValue(d.signum(), d.getDays(), d.getHours(), d.getMinutes(), d.getSeconds(), d.getMicroseconds());
        }
    }

    public static class BooleanToInteger
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return ((BooleanValue)input).getBooleanValue() ? Int64Value.PLUS_ONE : Int64Value.ZERO;
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class NumericToInteger
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            try {
                if (input instanceof IntegerValue) {
                    return input;
                }
                if (input instanceof DoubleValue) {
                    return IntegerValue.makeIntegerValue((DoubleValue)input);
                }
                if (input instanceof FloatValue) {
                    return IntegerValue.makeIntegerValue(new DoubleValue(((FloatValue)input).getDoubleValue()));
                }
                return BigIntegerValue.makeIntegerValue(((NumericValue)input).getDecimalValue().toBigInteger());
            }
            catch (XPathException e) {
                return new ValidationFailure(e);
            }
        }
    }

    public static class DecimalToInteger
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            if (input instanceof IntegerValue) {
                return input;
            }
            return BigIntegerValue.makeIntegerValue(((DecimalValue)input).getDecimalValue().toBigInteger());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class FloatToInteger
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return IntegerValue.makeIntegerValue(new DoubleValue(((FloatValue)input).getDoubleValue()));
        }
    }

    public static class DoubleToInteger
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return IntegerValue.makeIntegerValue((DoubleValue)input);
        }
    }

    public static class BooleanToDecimal
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return ((BooleanValue)input).getBooleanValue() ? DecimalValue.ONE : DecimalValue.ZERO;
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class NumericToDecimal
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            try {
                BigDecimal decimal = ((NumericValue)input).getDecimalValue();
                return new DecimalValue(decimal);
            }
            catch (XPathException e) {
                return new ValidationFailure(e);
            }
        }
    }

    public static class IntegerToDecimal
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            if (input instanceof Int64Value) {
                return new DecimalValue(((Int64Value)input).longValue());
            }
            return new DecimalValue(((BigIntegerValue)input).asDecimal());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class FloatToDecimal
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            try {
                return new DecimalValue(((FloatValue)input).getFloatValue());
            }
            catch (ValidationException e) {
                return new ValidationFailure(e);
            }
        }
    }

    public static class DoubleToDecimal
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            try {
                return new DecimalValue(((DoubleValue)input).getDoubleValue());
            }
            catch (ValidationException e) {
                return new ValidationFailure(e);
            }
        }
    }

    public static class BooleanToDouble
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new DoubleValue(((BooleanValue)input).getBooleanValue() ? 1.0 : 0.0);
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class NumericToDouble
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            if (input instanceof DoubleValue) {
                return input;
            }
            return new DoubleValue(((NumericValue)input).getDoubleValue());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class BooleanToFloat
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new FloatValue(((BooleanValue)input).getBooleanValue() ? 1.0f : 0.0f);
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class NumericToFloat
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new FloatValue(((NumericValue)input).getFloatValue());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class ToStringConverter
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new StringValue(input.getStringValueCS());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class ToUntypedAtomicConverter
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new UntypedAtomicValue(input.getStringValueCS());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class TwoPhaseConverter
    extends StringConverter {
        private Converter phaseOne;
        private Converter phaseTwo;

        public TwoPhaseConverter(Converter phaseOne, Converter phaseTwo) {
            this.phaseOne = phaseOne;
            this.phaseTwo = phaseTwo;
        }

        public static TwoPhaseConverter makeTwoPhaseConverter(AtomicType inputType, AtomicType viaType, AtomicType outputType, ConversionRules rules) {
            return new TwoPhaseConverter(TwoPhaseConverter.getConverter(inputType, viaType, rules), TwoPhaseConverter.getConverter(viaType, outputType, rules));
        }

        public void setNamespaceResolver(NamespaceResolver resolver) {
            this.phaseOne.setNamespaceResolver(resolver);
            this.phaseTwo.setNamespaceResolver(resolver);
        }

        public ConversionResult convert(AtomicValue input) {
            ConversionResult temp = this.phaseOne.convert(input);
            if (temp instanceof ValidationFailure) {
                return temp;
            }
            return this.phaseTwo.convert((AtomicValue)temp);
        }

        public ConversionResult convertString(CharSequence input) {
            ConversionResult temp = ((StringConverter)this.phaseOne).convertString(input);
            if (temp instanceof ValidationFailure) {
                return temp;
            }
            return ((DownCastingConverter)this.phaseTwo).convert((AtomicValue)temp, input);
        }
    }

    public static class DownCastingConverter
    extends Converter {
        private AtomicType newType;

        public DownCastingConverter(AtomicType annotation, ConversionRules rules) {
            this.newType = annotation;
            this.setConversionRules(rules);
        }

        public ConversionResult convert(AtomicValue input) {
            return this.convert(input, input.getStringValueCS());
        }

        public ConversionResult convert(AtomicValue input, CharSequence lexicalForm) {
            ValidationFailure f = this.newType.validate(input, lexicalForm, this.getConversionRules());
            if (f == null) {
                return input.copyAsSubType(this.newType);
            }
            return f;
        }
    }

    public static class UpCastingConverter
    extends Converter {
        private AtomicType newTypeAnnotation;

        public UpCastingConverter(AtomicType annotation) {
            this.newTypeAnnotation = annotation;
        }

        public ConversionResult convert(AtomicValue input) {
            return input.copyAsSubType(this.newTypeAnnotation);
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }
}

