/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue("");
    public static final StringValue SINGLE_SPACE = new StringValue(" ");
    public static final StringValue TRUE = new StringValue("true");
    public static final StringValue FALSE = new StringValue("false");
    protected CharSequence value;
    protected boolean noSurrogates = false;

    protected StringValue() {
        this.value = "";
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(CharSequence value) {
        this.value = value == null ? "" : value;
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(CharSequence value, AtomicType typeLabel) {
        this.value = value;
        this.typeLabel = typeLabel;
    }

    public void setContainsNoSurrogates() {
        this.noSurrogates = true;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        StringValue v = new StringValue(this.value);
        v.noSurrogates = this.noSurrogates;
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.STRING;
    }

    public static StringValue makeStringValue(CharSequence value) {
        if (value == null || value.length() == 0) {
            return EMPTY_STRING;
        }
        return new StringValue(value);
    }

    public final CharSequence getPrimitiveStringValue() {
        return this.value;
    }

    public final void setStringValueCS(CharSequence value) {
        this.value = value;
    }

    public int getStringLength() {
        if (this.noSurrogates) {
            return this.value.length();
        }
        int len = StringValue.getStringLength(this.value);
        if (len == this.value.length()) {
            this.noSurrogates = true;
        }
        return len;
    }

    public static int getStringLength(CharSequence s) {
        int n = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    public boolean isZeroLength() {
        return this.value.length() == 0;
    }

    public boolean containsSurrogatePairs() {
        if (this.noSurrogates) {
            return false;
        }
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c < '\ud800' || c >= '\udbff') continue;
            return true;
        }
        this.noSurrogates = true;
        return false;
    }

    public boolean isKnownToContainNoSurrogates() {
        return this.noSurrogates;
    }

    public UnfailingIterator iterateCharacters() {
        return new CharacterIterator();
    }

    public int[] expand() {
        int[] array = new int[this.getStringLength()];
        int o = 0;
        int len = this.value.length();
        for (int i = 0; i < len; ++i) {
            int charval;
            int c = this.value.charAt(i);
            if (c >= 55296 && c <= 56319) {
                charval = (c - 55296) * 1024 + (this.value.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                charval = c;
            }
            array[o++] = charval;
        }
        return array;
    }

    public static int[] expand(CharSequence s) {
        int[] array = new int[StringValue.getStringLength(s)];
        int o = 0;
        for (int i = 0; i < s.length(); ++i) {
            int charval;
            int c = s.charAt(i);
            if (c >= 55296 && c <= 56319) {
                charval = (c - 55296) * 1024 + (s.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                charval = c;
            }
            array[o++] = charval;
        }
        return array;
    }

    public static CharSequence contract(int[] codes, int used) {
        FastStringBuffer sb = new FastStringBuffer(codes.length);
        for (int i = 0; i < used; ++i) {
            if (codes[i] < 65536) {
                sb.append((char)codes[i]);
                continue;
            }
            sb.append(UTF16CharacterSet.highSurrogate(codes[i]));
            sb.append(UTF16CharacterSet.lowSurrogate(codes[i]));
        }
        return sb;
    }

    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return collator.getCollationKey(((Object)this.value).toString());
    }

    public boolean equals(Object other) {
        throw new ClassCastException("equals on StringValue is not allowed");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean codepointEquals(StringValue other) {
        return this.value.length() == other.value.length() && ((Object)this.value).toString().equals(((Object)other.value).toString());
    }

    public boolean effectiveBooleanValue() {
        return this.value.length() > 0;
    }

    public String toString() {
        return "\"" + this.value + '\"';
    }

    public Comparable getSchemaComparable() {
        return ((Object)this.value).toString();
    }

    public boolean isIdentical(Value v) {
        return v instanceof StringValue && this instanceof AnyURIValue == v instanceof AnyURIValue && this instanceof UntypedAtomicValue == v instanceof UntypedAtomicValue && this.toString().equals(v.toString());
    }

    public static String diagnosticDisplay(String s) {
        FastStringBuffer fsb = new FastStringBuffer(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= '~') {
                fsb.append(c);
                continue;
            }
            fsb.append("\\u");
            for (int shift = 12; shift >= 0; shift -= 4) {
                fsb.append("0123456789ABCDEF".charAt(c >> shift & 0xF));
            }
        }
        return fsb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class CharacterIterator
    implements UnfailingIterator<Int64Value> {
        int inpos = 0;
        int outpos = 0;
        int current = -1;

        @Override
        public Int64Value next() {
            if (this.inpos < StringValue.this.value.length()) {
                char c;
                if ((c = StringValue.this.value.charAt(this.inpos++)) >= '\ud800' && c <= '\udbff') {
                    try {
                        this.current = (c - 55296) * 1024 + (StringValue.this.value.charAt(this.inpos++) - 56320) + 65536;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.err.println("Invalid surrogate at end of string");
                        System.err.println(StringValue.diagnosticDisplay(((Object)StringValue.this.value).toString()));
                        e.printStackTrace();
                        throw e;
                    }
                } else {
                    this.current = c;
                }
                ++this.outpos;
                return new Int64Value(this.current);
            }
            this.outpos = -1;
            return null;
        }

        @Override
        public Int64Value current() {
            if (this.outpos < 1) {
                return null;
            }
            return new Int64Value(this.current);
        }

        @Override
        public int position() {
            return this.outpos;
        }

        @Override
        public void close() {
        }

        @Override
        public UnfailingIterator<Int64Value> getAnother() {
            return new CharacterIterator();
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

