/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AggregationReader {
    private static final QName RESOURCE = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
    private static QName AGGREGATES = new QName("http://www.openarchives.org/ore/terms/", "aggregates");

    public static List<URI> read(Source aggregation, boolean strict) throws XMLStreamException, URISyntaxException {
        LinkedList result = Lists.newLinkedList();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", true);
        XMLEventReader reader = factory.createXMLEventReader(aggregation);
        while (reader.hasNext()) {
            StartElement startElement;
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement() || !AGGREGATES.equals((startElement = event.asStartElement()).getName())) continue;
            try {
                Attribute resourceAttribute = startElement.getAttributeByName(RESOURCE);
                if (resourceAttribute != null) {
                    URI uri = new URI(resourceAttribute.getValue().trim());
                    result.add(uri);
                    continue;
                }
                String elementText = reader.getElementText();
                URI uri = new URI(elementText.trim());
                result.add(uri);
            }
            catch (XMLStreamException e) {
                if (!strict) continue;
                throw e;
            }
            catch (URISyntaxException e) {
                if (!strict) continue;
                throw e;
            }
        }
        return result;
    }

    public static List<URI> read(TextGridObject object, boolean strict) throws CoreException {
        IFile file = (IFile)AdapterUtils.getAdapter((Object)object, IFile.class);
        if (file != null) {
            InputStream stream = file.getContents();
            try {
                List<URI> list = AggregationReader.read(new StreamSource(stream), false);
                return list;
            }
            catch (XMLStreamException e) {
                throw new AggregationException(NLS.bind((String)"Aggregation {0} contains invalid content", (Object)object), e);
            }
            catch (URISyntaxException e) {
                throw new AggregationException(NLS.bind((String)"Aggregation {0} contains an invalid URI", (Object)object), e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new AggregationException(NLS.bind((String)"Failed to close open stream from {0}", (Object)object), e);
                }
            }
        }
        return ImmutableList.of();
    }

    public static class AggregationException
    extends CoreException {
        private static final long serialVersionUID = 5457750241923815265L;

        public AggregationException(String message, Throwable cause) {
            super((IStatus)new Status(4, "info.textgrid.lab.core.model", message == null && cause != null ? cause.getMessage() : message, cause));
        }
    }
}

