/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.TextGridFaultType;
import java.net.URI;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class TextGridErrorHandler {
    private static TextGridErrorHandler _instance = new TextGridErrorHandler();
    private static Hashtable<String, TextGridError> errorList = new Hashtable();
    private final int SPANOFTIME = 2000;
    private final String INFO_DELETED = "An {0} occured during an operation on {1}:\nThis error isn't followed up, because the object is already deleted.";
    private final String INFO_REPETITIVE = "An {0} occured during an operation on {1}:\nThis error isn't followed up, because it's a repetitive  error.";

    public static TextGridErrorHandler getInstance() {
        return _instance;
    }

    public IStatus handleError(Throwable tgError, TextGridFaultType errorFaultType, URI uri) {
        boolean throwError = false;
        try {
            if (uri != null && !TextGridObject.getInstance(uri, false).isDeleted()) {
                ErrorKey errorKey = new ErrorKey(uri, errorFaultType.getCause());
                TextGridError listError = errorList.get(errorKey.toString());
                if (listError == null) {
                    throwError = true;
                } else if (listError.time + 2000L < System.currentTimeMillis()) {
                    throwError = true;
                }
                errorList.put(errorKey.toString(), new TextGridError(tgError, errorFaultType));
                if (throwError) {
                    if (errorFaultType.getFaultNo() > 0) {
                        this.displayError(errorFaultType);
                        return Activator.handleProblem(2, tgError, "An {0} occured during an operation on {1}:\n{2}\nCause: {3}", tgError.getClass().getSimpleName(), uri, errorFaultType.getFaultMessage(), errorFaultType.getCause());
                    }
                    return Activator.handleError(tgError, "An {0} occured during an operation on {1}:\n{2}\nCause: {3}", tgError.getClass().getSimpleName(), uri, errorFaultType.getFaultMessage(), errorFaultType.getCause());
                }
                return Activator.handleProblem(1, tgError, "An {0} occured during an operation on {1}:\nThis error isn't followed up, because it's a repetitive  error.", tgError.getClass().getSimpleName(), uri);
            }
            return Activator.handleProblem(1, tgError, "An {0} occured during an operation on {1}:\nThis error isn't followed up, because the object is already deleted.", tgError.getClass().getSimpleName(), uri);
        }
        catch (CrudServiceException e) {
            return Activator.handleError(tgError, "An {0} occured during an operation on {1}:\n{2}\nCause: {3}", ((Object)((Object)e)).getClass().getSimpleName(), uri, CrudServiceException.getFaultType((Throwable)((Object)e), TextGridFaultType.class).getFaultMessage(), CrudServiceException.getFaultType((Throwable)((Object)e), TextGridFaultType.class).getCause());
        }
    }

    private void displayError(final TextGridFaultType errorFaultType) {
        UIJob displayJob = new UIJob("Displaying error message ..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)errorFaultType.getFaultMessage(), (String)errorFaultType.getCause());
                return Status.OK_STATUS;
            }
        };
        displayJob.setSystem(true);
        displayJob.schedule();
    }

    class ErrorKey {
        private URI uri;
        private String localCause;

        public ErrorKey(URI uri, String localCause) {
            this.uri = uri;
            this.localCause = localCause;
        }

        public String toString() {
            return this.uri + this.localCause;
        }
    }

    class TextGridError {
        private Throwable error;
        private TextGridFaultType faultType;
        private long time;

        public TextGridError(Throwable error, TextGridFaultType faultType) {
            this.error = error;
            this.faultType = faultType;
            this.time = System.currentTimeMillis();
        }
    }
}

