/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.core.model.IChildListChangedListener;
import info.textgrid.lab.core.model.IChildListParent;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.ChunkingElementCollector;
import info.textgrid.lab.core.tgauthclient.TgAuthClientUtilities;
import info.textgrid.lab.log.logsession;
import info.textgrid.namespaces.middleware.tgauth.GetAllProjectsRequest;
import info.textgrid.namespaces.middleware.tgauth.GetAllProjectsResponse;
import info.textgrid.namespaces.middleware.tgauth.PortTgextra;
import info.textgrid.namespaces.middleware.tgauth.ProjectInfo;
import info.textgrid.namespaces.middleware.tgauth.RolesetResponse;
import info.textgrid.namespaces.middleware.tgauth.TgAssignedProjectsRequest;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class TextGridProjectRoot
extends PlatformObject
implements IDeferredWorkbenchAdapter,
IChildListParent,
ISchedulingRule {
    private static TextGridProjectRoot root_level_none;
    private LinkedList<TextGridProject> projects = null;
    private ListenerList projectChangedListeners = new ListenerList();
    private LEVELS level = LEVELS.NONE;

    private TextGridProjectRoot() {
    }

    public void reset() {
        if (this.projects != null) {
            for (TextGridProject project : this.projects) {
                project.reset();
            }
        }
        this.resetProjects();
    }

    public void resetProjects() {
        this.projects = null;
        this.notifyChildListChangedListeners();
    }

    private void setLevel(LEVELS level) {
        this.level = level;
    }

    private LEVELS getLevel() {
        return this.level;
    }

    public static TextGridProjectRoot getInstance() {
        if (root_level_none == null) {
            root_level_none = new TextGridProjectRoot();
            TextGridProjectRoot.root_level_none.level = LEVELS.NONE;
        }
        return root_level_none;
    }

    public static TextGridProjectRoot getInstance(LEVELS level) {
        TextGridProjectRoot root = new TextGridProjectRoot();
        root.setLevel(level);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        monitor.beginTask("Loading", -1);
        TextGridProjectRoot textGridProjectRoot = this;
        synchronized (textGridProjectRoot) {
            ChunkingElementCollector groupingCollector = new ChunkingElementCollector(collector, 16);
            if (object instanceof TextGridProjectRoot) {
                this.projects = new LinkedList();
                try {
                    String rbacID = RBACSession.getInstance().getSID(this.level != LEVELS.OBSERVER_OR_PUBLIC_RESOURCES);
                    String loggingParam = logsession.getInstance().getloginfo();
                    PortTgextra stub = null;
                    stub = TgAuthClientUtilities.getTgAuthServiceStub();
                    RolesetResponse response = null;
                    List projectstrings = null;
                    TgAssignedProjectsRequest request = new TgAssignedProjectsRequest();
                    request.setAuth(rbacID);
                    request.setLog(loggingParam);
                    request.setLevel(Integer.valueOf(this.getLevel().ordinal()));
                    response = stub.tgAssignedProjects(request);
                    OnlineStatus.setOnline();
                    if (response != null) {
                        projectstrings = response.getRole();
                    }
                    GetAllProjectsRequest gap = new GetAllProjectsRequest();
                    gap.setAuth(rbacID);
                    gap.setLog(loggingParam);
                    GetAllProjectsResponse allProjects = new GetAllProjectsResponse();
                    allProjects = stub.getAllProjects(gap);
                    if (allProjects != null && this.projects != null && projectstrings != null) {
                        List allPI = allProjects.getProject();
                        block5: for (ProjectInfo pi : allPI) {
                            for (String myProject : projectstrings) {
                                if (!pi.getId().equals(myProject)) continue;
                                TextGridProject project = TextGridProject.getProjectInstance(pi);
                                this.projects.add(project);
                                groupingCollector.add((Object)project, monitor);
                                continue block5;
                            }
                        }
                    }
                }
                catch (RemoteException e) {
                    OnlineStatus.netAccessFailed((String)"Could not fetch assigned projects", (Throwable)e);
                }
            } else {
                throw new IllegalArgumentException(MessageFormat.format("NavigatorRoot''s fetchDeferredChildren does not know the children of {0}s like {1}", object.getClass(), object));
            }
            groupingCollector.done();
            collector.done();
            monitor.done();
        }
    }

    public ISchedulingRule getRule(Object object) {
        return this;
    }

    public boolean isContainer() {
        return true;
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (o == this) {
            switch (this.level) {
                case OBSERVER_OR_PUBLIC_RESOURCES: {
                    return "Everything readable";
                }
                case OBSERVER: {
                    return "My Observer Projects";
                }
                case EDITOR: {
                    return "My Editor Projects";
                }
                case PROJECT_LEADER: {
                    return "My Manager Projects";
                }
                case NONE: {
                    return "My Projects";
                }
            }
        }
        return "TextGrid Projects";
    }

    public Object getParent(Object o) {
        return null;
    }

    @Override
    public void addChildListChangedListener(IChildListChangedListener listener) {
        this.projectChangedListeners.add((Object)listener);
    }

    @Override
    public void removeChildListChangedListener(IChildListChangedListener listener) {
        this.projectChangedListeners.remove((Object)listener);
    }

    protected void notifyChildListChangedListeners() {
        Object[] listeners = this.projectChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IChildListChangedListener)listeners[i]).childListChanged(this);
            ++i;
        }
    }

    public boolean contains(ISchedulingRule rule) {
        return rule instanceof TextGridProjectRoot && rule.equals(this);
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule instanceof TextGridProjectRoot;
    }

    public static enum LEVELS {
        NONE,
        OBSERVER_OR_PUBLIC_RESOURCES,
        OBSERVER,
        EDITOR,
        PROJECT_LEADER;

    }
}

