/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model.util;

import info.textgrid.lab.core.model.util.ModelUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public abstract class LongOperation<T> {
    private T result;

    public abstract T run(IProgressMonitor var1) throws CoreException;

    public T busyCursor(IProgressMonitor monitor) throws CoreException {
        if (!ModelUtil.inUIThread()) {
            this.setResult(this.run(monitor));
        } else {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(this.createRunnable());
            }
            catch (InvocationTargetException e) {
                LongOperationException.fail(e);
            }
            catch (InterruptedException e) {
                LongOperationException.fail(e);
            }
        }
        return this.getResult();
    }

    public T runInJob(IProgressMonitor monitor, String message) throws CoreException {
        this.setResult(this.run(monitor));
        return this.getResult();
    }

    protected T getResult() {
        return this.result;
    }

    private void setResult(T result) {
        this.result = result;
    }

    private IRunnableWithProgress createRunnable() {
        return new OperationRunnable();
    }

    protected class JoiningRunnable
    implements IRunnableWithProgress {
        private Job job;

        public JoiningRunnable(Job wrappingJob) {
            this.job = wrappingJob;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.job.join();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    public static class LongOperationException
    extends CoreException {
        private static final long serialVersionUID = -4799958323881890920L;

        public LongOperationException(Throwable e) {
            super(Status.CANCEL_STATUS);
        }

        public static void fail(Throwable throwable) throws CoreException {
            if (throwable.getCause() instanceof CoreException) {
                throw (CoreException)throwable.getCause();
            }
            if (throwable.getCause() instanceof RuntimeException) {
                throw (RuntimeException)throwable.getCause();
            }
            throw new LongOperationException(throwable.getCause());
        }
    }

    private class OperationRunnable
    implements IRunnableWithProgress {
        private OperationRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                LongOperation.this.setResult(LongOperation.this.run(monitor));
            }
            catch (CoreException e) {
                LongOperation.this.setResult(null);
                throw new InvocationTargetException(e);
            }
        }
    }

    protected class RunnableWrappingJob
    extends Job {
        private IRunnableWithProgress runnable;

        public RunnableWrappingJob(IRunnableWithProgress runnable, String title) {
            super(title);
            this.runnable = runnable;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    this.runnable.run(monitor);
                }
                catch (InvocationTargetException e) {
                    LongOperationException.fail(e.getCause());
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }
    }
}

