/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResourceDelta;

public class ResourceDeltaPrinter {
    private IResourceDelta delta;
    private int level = 0;
    private static final ImmutableMap<Integer, String> FLAG_LEGEND = new ImmutableMap.Builder().put((Object)1, (Object)"ADDED").put((Object)2, (Object)"REMOVED").put((Object)4, (Object)"CHANGED").put((Object)8, (Object)"ADDED_PHANTOM").put((Object)16, (Object)"REMOVED_PHANTOM").put((Object)256, (Object)"CONTENT").put((Object)4096, (Object)"MOVED_FROM").put((Object)8192, (Object)"MOVED_TO").put((Object)2048, (Object)"COPIED_FROM").put((Object)16384, (Object)"OPEN").put((Object)32768, (Object)"TYPE").put((Object)65536, (Object)"SYNC").put((Object)131072, (Object)"MARKERS").put((Object)262144, (Object)"REPLACED").put((Object)524288, (Object)"DESCRIPTION").put((Object)0x100000, (Object)"ENCODING").put((Object)0x200000, (Object)"LOCAL_CHANGED").build();

    public static ResourceDeltaPrinter build(IResourceDelta delta) {
        return new ResourceDeltaPrinter(delta, 0);
    }

    protected static ResourceDeltaPrinter build(IResourceDelta delta, int level) {
        return new ResourceDeltaPrinter(delta, level);
    }

    protected static List<ResourceDeltaPrinter> build(IResourceDelta[] deltas, int level) {
        ArrayList<ResourceDeltaPrinter> result = new ArrayList<ResourceDeltaPrinter>(deltas.length);
        IResourceDelta[] iResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            result.add(ResourceDeltaPrinter.build(delta, level));
            ++n2;
        }
        return result;
    }

    private ResourceDeltaPrinter(IResourceDelta delta, int level) {
        this.level = level;
        this.delta = delta;
    }

    private String getKindStr() {
        switch (this.delta.getKind()) {
            case 1: {
                return "added";
            }
            case 2: {
                return "removed";
            }
            case 4: {
                return "changed";
            }
            case 8: {
                return "added (phantom)";
            }
            case 16: {
                return "removed (phantom)";
            }
        }
        return "unknown change (" + this.delta.getKind() + ")";
    }

    public String flagsToString(int flags) {
        ArrayList flagNames = Lists.newArrayListWithCapacity((int)FLAG_LEGEND.size());
        for (Integer flag : FLAG_LEGEND.keySet()) {
            if ((flags & flag) == 0) continue;
            flagNames.add((String)FLAG_LEGEND.get((Object)flag));
        }
        return Joiner.on((String)" | ").join((Iterable)flagNames);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i <= this.level) {
            result.append(' ');
            ++i;
        }
        result.append(this.getKindStr()).append(' ').append(this.delta.getResource());
        result.append(", flags: ").append(this.flagsToString(this.delta.getFlags()));
        result.append(" (").append(Integer.toHexString(this.delta.getFlags())).append(")");
        IResourceDelta[] deltas = this.delta.getAffectedChildren();
        if (deltas != null && deltas.length > 0) {
            for (ResourceDeltaPrinter printer : ResourceDeltaPrinter.build(deltas, this.level + 1)) {
                result.append('\n').append(printer);
            }
        }
        return result.toString();
    }
}

