/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.dialogs;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.dialogs.INewObjectPreparator;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizard;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizardPage;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import info.textgrid.lab.xmleditor.dialogs.Messages;
import info.textgrid.lab.xmleditor.dialogs.NewXMLObjectPreparator;
import info.textgrid.lab.xmleditor.mpeditor.Activator;
import java.util.EnumSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.ui.internal.dialogs.SelectXMLCatalogIdPanel;

public class SelectSchemaPage
extends WizardPage
implements ITextGridWizardPage,
SelectionListener,
ISelectionChangedListener {
    private SelectXMLCatalogIdPanel catalogIdPanel;
    private TextGridObjectTableViewer schemaTable;
    private NewXMLObjectPreparator preparator;
    private ICatalogEntry catalogEntry;
    private TextGridObject schemaObject;
    private Button noSchema;

    public SelectSchemaPage() {
        super(Messages.SelectSchemaPage_PageTitle, Messages.SelectSchemaPage_PageMessage, null);
    }

    public void finishPage() {
        this.preparator.setXMLCatalogEntry(this.catalogEntry);
        if (this.catalogEntry != null) {
            this.preparator.setGrammarURI(this.catalogEntry.getURI());
        }
        if (this.schemaObject != null) {
            this.preparator.setXMLCatalogEntry(null);
            this.preparator.setGrammarObject(this.schemaObject);
        }
        if (this.catalogEntry == null && this.schemaObject == null) {
            this.preparator.setGrammarURI(null);
            this.preparator.setXMLCatalogEntry(null);
        }
    }

    public void init(ITextGridWizard wizard, INewObjectPreparator preparator) {
        if (preparator instanceof NewXMLObjectPreparator) {
            this.preparator = (NewXMLObjectPreparator)preparator;
        } else {
            Activator.handleProblem(2, null, "Select schema page initialized from wizard {0} with a strange preparator: {1} (which is a {2}) ", wizard, preparator, preparator != null ? preparator.getClass() : null);
        }
    }

    public void loadObject(TextGridObject textGridObject) {
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridDataFactory fillGrabData = GridDataFactory.fillDefaults();
        fillGrabData.grab(true, true);
        GridLayoutFactory.fillDefaults().applyTo(control);
        fillGrabData.applyTo((Control)control);
        this.setControl((Control)control);
        this.noSchema = new Button(control, 16);
        this.noSchema.setLayoutData((Object)new GridData(4, 128, true, false));
        this.noSchema.setText(Messages.SelectSchemaPage_DoNotAssociateSchema);
        this.noSchema.setToolTipText(Messages.SelectSchemaPage_CreateEmptyXML);
        this.noSchema.addSelectionListener((SelectionListener)this);
        this.noSchema.setSelection(true);
        Label repHeader = new Label(control, 16384);
        repHeader.setText(Messages.SelectSchemaPage_SchemasFromRep);
        this.schemaTable = new TextGridObjectTableViewer(control, 0x10010004);
        this.schemaTable.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.TITLE, TextGridObjectTableViewer.Column.PROJECT, TextGridObjectTableViewer.Column.AUTHORS));
        fillGrabData.applyTo(this.schemaTable.getControl());
        this.schemaTable.getTable().addSelectionListener((SelectionListener)this);
        this.schemaTable.addSelectionChangedListener((ISelectionChangedListener)this);
        this.schemaTable.queryMetadata("format:\"text/xsd+xml\"");
        Label repInfo = new Label(control, 64);
        repInfo.setLayoutData((Object)new GridData(4, 4, true, false));
        repInfo.setText(Messages.SelectSchemaPage_ImportSchemaNote);
        Label separator = new Label(control, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label catInfo = new Label(control, 64);
        catInfo.setLayoutData((Object)new GridData(4, 4, true, false));
        catInfo.setText(Messages.SelectSchemaPage_BuiltinSchemaNote);
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        this.catalogIdPanel = new SelectXMLCatalogIdPanel(control, xmlCatalog);
        this.catalogIdPanel.getTableViewer().getTable().addSelectionListener((SelectionListener)this);
        this.catalogIdPanel.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.setMessage(Messages.SelectSchemaPage_SchemaExplanation);
        this.validatePageComplete();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.catalogIdPanel.getTableViewer().getTable()) {
            this.schemaTable.getTable().deselectAll();
            this.noSchema.setSelection(false);
        } else if (e.widget == this.schemaTable.getTable()) {
            this.catalogIdPanel.getTableViewer().getTable().deselectAll();
            this.noSchema.setSelection(false);
        } else if (e.widget == this.noSchema && this.noSchema.getSelection()) {
            this.schemaTable.getTable().deselectAll();
            this.catalogIdPanel.getTableViewer().getTable().deselectAll();
            this.schemaObject = null;
            this.catalogEntry = null;
            this.validatePageComplete();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object object = sel.getFirstElement();
            if (object instanceof ICatalogEntry) {
                this.catalogEntry = (ICatalogEntry)object;
                this.schemaObject = null;
            } else {
                TextGridObject tgo = (TextGridObject)AdapterUtils.getAdapter((Object)object, TextGridObject.class);
                if (tgo != null) {
                    this.schemaObject = tgo;
                    this.catalogEntry = null;
                }
            }
        }
        this.validatePageComplete();
    }

    private void validatePageComplete() {
        this.setPageComplete(this.schemaObject != null || this.catalogEntry != null || this.noSchema.getSelection());
    }
}

