/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor;

import info.textgrid.lab.xmleditor.mpeditor.MPXmlEditorPart;
import info.textgrid.lab.xmleditor.mpeditor.Messages;
import java.lang.reflect.Field;
import net.sf.vex.core.Caret;
import net.sf.vex.core.Rectangle;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.BoxAndOffset;
import net.sf.vex.swt.VexWidget;
import net.sf.vex.widget.HostComponent;
import net.sf.vex.widget.VexWidgetImpl;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;

class DebugViewPage
implements IPageBookViewPage {
    private static final int X = 1;
    private static final int Y = 2;
    private static final int WIDTH = 3;
    private static final int HEIGHT = 4;
    private static Field implField;
    private static Field rootBoxField;
    private static Field caretField;
    private static Field hostComponentField;
    private IPageSite site;
    private MPXmlEditorPart vexEditor;
    private VexWidget vexWidget;
    private VexWidgetImpl impl;
    private Composite composite;
    private Label loadingLabel;
    private Table table;
    private TableItem documentItem;
    private TableItem viewportItem;
    private TableItem caretOffsetItem;
    private TableItem caretAbsItem;
    private TableItem caretRelItem;
    private TableItem mouseAbsItem;
    private TableItem mouseRelItem;
    private TableItem currentBoxItem;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (DebugViewPage.this.vexWidget == null) {
                DebugViewPage.this.createDebugPanel();
            }
            DebugViewPage.this.repopulate();
        }
    };
    private ControlListener controlListener = new ControlListener(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            int width = ((DebugViewPage)DebugViewPage.this).table.getSize().x;
            int numWidth = Math.round((float)width * 0.125f);
            DebugViewPage.this.table.getColumn(0).setWidth(width / 2);
            DebugViewPage.this.table.getColumn(1).setWidth(numWidth);
            DebugViewPage.this.table.getColumn(2).setWidth(numWidth);
            DebugViewPage.this.table.getColumn(3).setWidth(numWidth);
            DebugViewPage.this.table.getColumn(4).setWidth(numWidth);
        }
    };
    private MouseMoveListener mouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            Rectangle rect = new Rectangle(e.x, e.y, 0, 0);
            Rectangle viewport = DebugViewPage.this.getViewport();
            DebugViewPage.setItemFromRect(DebugViewPage.this.mouseAbsItem, rect);
            DebugViewPage.setItemRel(DebugViewPage.this.mouseRelItem, viewport, rect);
            int mouseX = e.x + viewport.getX();
            int mouseY = e.y + viewport.getY();
            this.setCurBoxItem(mouseX, mouseY);
        }

        private void setCurBoxItem(int x, int y) {
            BoxAndOffset cursorBox = DebugViewPage.this.impl.getBoxAt(x, y);
            if (cursorBox != null) {
                DebugViewPage.this.impl.setDebugRect(new Rectangle(cursorBox.box.getX() + cursorBox.x, cursorBox.box.getY() + cursorBox.y, cursorBox.box.getWidth(), cursorBox.box.getHeight()));
                DebugViewPage.this.impl.repaint();
                String text = cursorBox == null ? "[none]" : String.valueOf(cursorBox.box.getClass().getSimpleName()) + ": " + cursorBox.box.toString();
                DebugViewPage.this.currentBoxItem.setText(1, text);
            }
        }
    };

    static {
        try {
            implField = VexWidget.class.getDeclaredField("impl");
            implField.setAccessible(true);
            rootBoxField = VexWidgetImpl.class.getDeclaredField("rootBox");
            rootBoxField.setAccessible(true);
            caretField = VexWidgetImpl.class.getDeclaredField("caret");
            caretField.setAccessible(true);
            hostComponentField = VexWidgetImpl.class.getDeclaredField("hostComponent");
            hostComponentField.setAccessible(true);
        }
        catch (Exception exception) {}
    }

    public DebugViewPage(MPXmlEditorPart vexEditor) {
        this.vexEditor = vexEditor;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FillLayout());
        if (this.vexEditor.getWysiwymEditor().isLoaded()) {
            this.createDebugPanel();
        } else {
            this.loadingLabel = new Label(this.composite, 0);
            this.loadingLabel.setText("Loading...");
        }
        this.vexEditor.getEditorSite().getSelectionProvider().addSelectionChangedListener(this.selectionListener);
    }

    public void dispose() {
        if (this.vexWidget != null && !this.vexWidget.isDisposed()) {
            this.vexWidget.removeMouseMoveListener(this.mouseMoveListener);
        }
        this.vexEditor.getEditorSite().getSelectionProvider().removeSelectionChangedListener(this.selectionListener);
        this.impl.setDebugRect(null);
        this.impl.repaint();
    }

    public Control getControl() {
        return this.composite;
    }

    public IPageSite getSite() {
        return this.site;
    }

    public void init(IPageSite site) throws PartInitException {
        this.site = site;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
    }

    private void createDebugPanel() {
        if (this.loadingLabel != null) {
            this.loadingLabel.dispose();
            this.loadingLabel = null;
        }
        this.vexWidget = this.vexEditor.getWysiwymEditor().getVexWidget();
        try {
            this.impl = (VexWidgetImpl)implField.get(this.vexWidget);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.composite.setLayout((Layout)layout);
        ScrolledComposite sc = new ScrolledComposite(this.composite, 512);
        this.table = new Table((Composite)sc, 0);
        this.table.setHeaderVisible(true);
        sc.setContent((Control)this.table);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        sc.setLayoutData((Object)gd);
        TableColumn column = new TableColumn(this.table, 16384);
        column.setText("Item");
        column = new TableColumn(this.table, 131072);
        column.setText("X");
        column = new TableColumn(this.table, 131072);
        column.setText("Y");
        column = new TableColumn(this.table, 131072);
        column.setText("Width");
        column = new TableColumn(this.table, 131072);
        column.setText(Messages.DebugViewPage_9);
        this.table.addControlListener(this.controlListener);
        this.documentItem = new TableItem(this.table, 0);
        this.documentItem.setText(0, "Document");
        this.viewportItem = new TableItem(this.table, 0);
        this.viewportItem.setText(0, "Viewport");
        this.caretOffsetItem = new TableItem(this.table, 0);
        this.caretOffsetItem.setText(0, "Caret Offset");
        this.caretAbsItem = new TableItem(this.table, 0);
        this.caretAbsItem.setText(0, "Caret Abs.");
        this.caretRelItem = new TableItem(this.table, 0);
        this.caretRelItem.setText(0, "Caret Rel.");
        this.mouseAbsItem = new TableItem(this.table, 0);
        this.mouseAbsItem.setText(0, "Mouse Abs.");
        this.mouseRelItem = new TableItem(this.table, 0);
        this.mouseRelItem.setText(0, "Mouse Rel.");
        this.currentBoxItem = new TableItem(this.table, 0);
        this.currentBoxItem.setText(0, "Cur. Box");
        Button updateButton = new Button(this.composite, 8);
        updateButton.setText("Refresh");
        updateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DebugViewPage.this.repopulate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.composite.layout();
        this.vexWidget.addMouseMoveListener(this.mouseMoveListener);
        this.repopulate();
    }

    private Rectangle getCaretBounds() {
        Caret caret = (Caret)this.getFieldValue(caretField, this.impl);
        return caret.getBounds();
    }

    private Rectangle getRootBoxBounds() {
        Box rootBox = (Box)this.getFieldValue(rootBoxField, this.impl);
        return new Rectangle(rootBox.getX(), rootBox.getY(), rootBox.getWidth(), rootBox.getHeight());
    }

    private Rectangle getViewport() {
        HostComponent hc = (HostComponent)this.getFieldValue(hostComponentField, this.impl);
        return hc.getViewport();
    }

    private Object getFieldValue(Field field, Object o) {
        try {
            return field.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void repopulate() {
        DebugViewPage.setItemFromRect(this.documentItem, this.getRootBoxBounds());
        Rectangle viewport = this.getViewport();
        this.caretOffsetItem.setText(1, Integer.toString(this.impl.getCaretOffset()));
        DebugViewPage.setItemFromRect(this.viewportItem, viewport);
        DebugViewPage.setItemFromRect(this.caretAbsItem, this.getCaretBounds());
        DebugViewPage.setItemRel(this.caretRelItem, viewport, this.getCaretBounds());
    }

    private static void setItemFromRect(TableItem item, Rectangle rect) {
        item.setText(1, Integer.toString(rect.getX()));
        item.setText(2, Integer.toString(rect.getY()));
        item.setText(3, Integer.toString(rect.getWidth()));
        item.setText(4, Integer.toString(rect.getHeight()));
    }

    private static void setItemRel(TableItem item, Rectangle viewport, Rectangle rect) {
        item.setText(1, Integer.toString(rect.getX() + viewport.getX()));
        item.setText(2, Integer.toString(rect.getY() + viewport.getY()));
        item.setText(3, Integer.toString(rect.getWidth()));
        item.setText(4, Integer.toString(rect.getHeight()));
    }
}

