/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.xmleditor.mpeditor.Messages;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCacheListener;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SchemaManager
implements CMDocumentCacheListener {
    private static SchemaManager instance = null;
    private Set<CMDocumentCache> knownCaches = Sets.newHashSet();
    private Map<URI, TextGridObject> localSchemas = Maps.newHashMap();

    public static SchemaManager getInstance() {
        if (instance == null) {
            instance = new SchemaManager();
        }
        return instance;
    }

    protected SchemaManager() {
    }

    public void associateWith(IEditorPart editor) {
        ITextEditor textEditor = (ITextEditor)AdapterUtils.getAdapter((Object)editor, ITextEditor.class);
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        if (document instanceof IStructuredDocument) {
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)document);
            try {
                if (model instanceof IDOMModel) {
                    IDOMDocument domDocument = ((IDOMModel)model).getDocument();
                    CMDocumentCache cache = ModelQueryUtil.getCMDocumentCache((Document)domDocument);
                    if (!this.knownCaches.contains(cache)) {
                        this.knownCaches.add(cache);
                        cache.addListener((CMDocumentCacheListener)this);
                    }
                    ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)domDocument);
                    CMDocumentManager cmDocumentManager = modelQuery.getCMDocumentManager();
                    CMDocument correspondingCMDocument = modelQuery.getCorrespondingCMDocument((Node)domDocument);
                    cmDocumentManager.setPropertyEnabled("autoLoad", true);
                    if (correspondingCMDocument != null) {
                        System.out.println("YAY, found a corresponding CMDocument!" + correspondingCMDocument);
                    }
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
    }

    public void cacheCleared(CMDocumentCache cache) {
    }

    public void cacheUpdated(CMDocumentCache cache, String uri, int oldStatus, int newStatus, CMDocument cmDocument) {
        TextGridObject schemaObject = null;
        if (uri != null) {
            schemaObject = this.findSchemaObject(URI.create(uri));
        }
        if (newStatus == 4) {
            this.handleBrokenSchema(uri, cmDocument, schemaObject);
        } else if (newStatus == 2) {
            this.showStatus(uri, schemaObject, Messages.SchemaManager_LoadingSchemaX, false);
        } else if (newStatus == 3) {
            this.showStatus(uri, schemaObject, Messages.SchemaManager_SchemaXLoaded, false);
        }
    }

    private void handleBrokenSchema(String uri, CMDocument cmDocument, TextGridObject schemaObject) {
        StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.xmleditor.mpeditor", MessageFormat.format(Messages.SchemaManager_ContentModelFailed, uri, cmDocument, schemaObject)), 1);
        try {
            this.showStatus(uri, schemaObject, NLS.bind((String)Messages.SchemaManager_FailedToLoadSchema, (Object)schemaObject.getTitle()), true);
        }
        catch (CoreException coreException) {
            this.showStatus(uri, schemaObject, NLS.bind((String)Messages.SchemaManager_FailedToLoadSchema, (Object)uri), true);
        }
        IFile schemaFile = (IFile)AdapterUtils.getAdapter((Object)schemaObject, IFile.class);
        if (schemaFile != null) {
            try {
                IMarker marker = schemaFile.createMarker("org.eclipse.core.resources.marker.problemmarker");
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)Messages.SchemaManager_FailedToLoadParseSchema);
                Object[] markers = schemaFile.findMarkers(null, true, 2);
                System.out.println(Joiner.on((String)", ").join(markers));
                PlatformUI.getWorkbench().getDecoratorManager().update("info.textgrid.lab.debug.decorators.ResourceProblemDecorator");
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.xmleditor.mpeditor");
            }
        }
    }

    private void showStatus(final String uri, final TextGridObject schemaObject, final String message, final boolean error) {
        new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    int severity = error ? 4 : 1;
                    String filledInMessage = NLS.bind((String)message, (Object)(schemaObject != null ? schemaObject.getTitle() : uri));
                    StatusManager.getManager().handle((IStatus)new Status(severity, "info.textgrid.lab.xmleditor.mpeditor", filledInMessage));
                    IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                    IEditorStatusLine editorStatusLine = (IEditorStatusLine)AdapterUtils.getAdapter((Object)activeEditor, IEditorStatusLine.class);
                    if (editorStatusLine == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (schemaObject != null) {
                        editorStatusLine.setMessage(error, filledInMessage, schemaObject.getContentType(false).getImage(true));
                    } else {
                        editorStatusLine.setMessage(error, filledInMessage, null);
                    }
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "info.textgrid.lab.xmleditor.mpeditor");
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void registerLocalSchema(TextGridObject schemaObject, URI localURI) {
        this.localSchemas.put(localURI, schemaObject);
    }

    protected TextGridObject findSchemaObject(URI localURI) {
        return this.localSchemas.get(localURI);
    }
}

